/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.bolt;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.storm.elasticsearch.bolt.AbstractEsBolt;
import org.apache.storm.elasticsearch.common.DefaultEsTupleMapper;
import org.apache.storm.elasticsearch.common.EsConfig;
import org.apache.storm.elasticsearch.common.EsTupleMapper;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;

public class EsIndexBolt
extends AbstractEsBolt {
    private final EsTupleMapper tupleMapper;

    public EsIndexBolt(EsConfig esConfig) {
        this(esConfig, new DefaultEsTupleMapper());
    }

    public EsIndexBolt(EsConfig esConfig, EsTupleMapper tupleMapper) {
        super(esConfig);
        this.tupleMapper = Objects.requireNonNull(tupleMapper);
    }

    @Override
    public void prepare(Map<String, Object> map, TopologyContext topologyContext, OutputCollector outputCollector) {
        super.prepare(map, topologyContext, outputCollector);
    }

    public void process(Tuple tuple) {
        try {
            String source = this.tupleMapper.getSource((ITuple)tuple);
            String index = this.tupleMapper.getIndex((ITuple)tuple);
            String type = this.tupleMapper.getType((ITuple)tuple);
            String id = this.tupleMapper.getId((ITuple)tuple);
            Map<String, String> params = this.tupleMapper.getParams((ITuple)tuple, new HashMap<String, String>());
            client.performRequest("put", EsIndexBolt.getEndpoint(index, type, id), params, (HttpEntity)new StringEntity(source), new Header[0]);
            this.collector.ack(tuple);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(tuple);
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
    }
}

