/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.bolt;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Objects;
import org.apache.http.util.Args;
import org.apache.storm.elasticsearch.common.EsConfig;
import org.apache.storm.elasticsearch.common.StormElasticSearchClient;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseTickTupleAwareRichBolt;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEsBolt
extends BaseTickTupleAwareRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEsBolt.class);
    protected static RestClient client;
    protected static final ObjectMapper objectMapper;
    protected OutputCollector collector;
    private EsConfig esConfig;

    public AbstractEsBolt(EsConfig esConfig) {
        this.esConfig = Objects.requireNonNull(esConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Map<String, Object> map, TopologyContext topologyContext, OutputCollector outputCollector) {
        try {
            this.collector = outputCollector;
            Class<AbstractEsBolt> clazz = AbstractEsBolt.class;
            synchronized (AbstractEsBolt.class) {
                if (client == null) {
                    client = new StormElasticSearchClient(this.esConfig).construct();
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            LOG.warn("unable to initialize EsBolt ", (Throwable)e);
        }
        {
            return;
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
    }

    static String getEndpoint(String index, String type, String id) {
        Objects.requireNonNull(index);
        Args.notBlank(index, "index");
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(index);
        if (type != null && !type.isEmpty()) {
            sb.append("/").append(type);
        }
        if (id != null && !id.isEmpty()) {
            sb.append("/").append(id);
        }
        return sb.toString();
    }

    static RestClient getClient() {
        return client;
    }

    static void replaceClient(RestClient client) {
        AbstractEsBolt.client = client;
    }

    static {
        objectMapper = new ObjectMapper();
    }
}

