/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.uninverting;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.uninverting.FieldCacheImpl;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;

interface FieldCache {
    public static final FieldCache DEFAULT = new FieldCacheImpl();
    public static final Parser NUMERIC_UTILS_INT_PARSER = new Parser(){

        @Override
        public long parseValue(BytesRef term) {
            return NumericUtils.prefixCodedToInt(term);
        }

        @Override
        public TermsEnum termsEnum(Terms terms) throws IOException {
            return NumericUtils.filterPrefixCodedInts(terms.iterator());
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_INT_PARSER";
        }
    };
    public static final Parser NUMERIC_UTILS_FLOAT_PARSER = new Parser(){

        @Override
        public long parseValue(BytesRef term) {
            int val = NumericUtils.prefixCodedToInt(term);
            if (val < 0) {
                val ^= Integer.MAX_VALUE;
            }
            return val;
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_FLOAT_PARSER";
        }

        @Override
        public TermsEnum termsEnum(Terms terms) throws IOException {
            return NumericUtils.filterPrefixCodedInts(terms.iterator());
        }
    };
    public static final Parser NUMERIC_UTILS_LONG_PARSER = new Parser(){

        @Override
        public long parseValue(BytesRef term) {
            return NumericUtils.prefixCodedToLong(term);
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_LONG_PARSER";
        }

        @Override
        public TermsEnum termsEnum(Terms terms) throws IOException {
            return NumericUtils.filterPrefixCodedLongs(terms.iterator());
        }
    };
    public static final Parser NUMERIC_UTILS_DOUBLE_PARSER = new Parser(){

        @Override
        public long parseValue(BytesRef term) {
            long val = NumericUtils.prefixCodedToLong(term);
            if (val < 0L) {
                val ^= Long.MAX_VALUE;
            }
            return val;
        }

        public String toString() {
            return FieldCache.class.getName() + ".NUMERIC_UTILS_DOUBLE_PARSER";
        }

        @Override
        public TermsEnum termsEnum(Terms terms) throws IOException {
            return NumericUtils.filterPrefixCodedLongs(terms.iterator());
        }
    };
    public static final BytesRef INT32_TERM_PREFIX = new BytesRef(new byte[]{96});
    public static final BytesRef INT64_TERM_PREFIX = new BytesRef(new byte[]{32});

    public Bits getDocsWithField(LeafReader var1, String var2) throws IOException;

    public NumericDocValues getNumerics(LeafReader var1, String var2, Parser var3, boolean var4) throws IOException;

    public BinaryDocValues getTerms(LeafReader var1, String var2, boolean var3) throws IOException;

    public BinaryDocValues getTerms(LeafReader var1, String var2, boolean var3, float var4) throws IOException;

    public SortedDocValues getTermsIndex(LeafReader var1, String var2) throws IOException;

    public SortedDocValues getTermsIndex(LeafReader var1, String var2, float var3) throws IOException;

    public SortedSetDocValues getDocTermOrds(LeafReader var1, String var2, BytesRef var3) throws IOException;

    public CacheEntry[] getCacheEntries();

    public void purgeAllCaches();

    public void purgeByCacheKey(Object var1);

    public void setInfoStream(PrintStream var1);

    public PrintStream getInfoStream();

    public static final class CacheEntry {
        private final Object readerKey;
        private final String fieldName;
        private final Class<?> cacheType;
        private final Object custom;
        private final Accountable value;

        public CacheEntry(Object readerKey, String fieldName, Class<?> cacheType, Object custom, Accountable value) {
            this.readerKey = readerKey;
            this.fieldName = fieldName;
            this.cacheType = cacheType;
            this.custom = custom;
            this.value = value;
        }

        public Object getReaderKey() {
            return this.readerKey;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Class<?> getCacheType() {
            return this.cacheType;
        }

        public Object getCustom() {
            return this.custom;
        }

        public Object getValue() {
            return this.value;
        }

        public String getEstimatedSize() {
            long bytesUsed = this.value == null ? 0L : this.value.ramBytesUsed();
            return RamUsageEstimator.humanReadableUnits(bytesUsed);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("'").append(this.getReaderKey()).append("'=>");
            b.append("'").append(this.getFieldName()).append("',");
            b.append(this.getCacheType()).append(",").append(this.getCustom());
            b.append("=>").append(this.getValue().getClass().getName()).append("#");
            b.append(System.identityHashCode(this.getValue()));
            String s2 = this.getEstimatedSize();
            b.append(" (size =~ ").append(s2).append(')');
            return b.toString();
        }
    }

    public static interface Parser {
        public TermsEnum termsEnum(Terms var1) throws IOException;

        public long parseValue(BytesRef var1);
    }

    public static final class CreationPlaceholder
    implements Accountable {
        Accountable value;

        @Override
        public long ramBytesUsed() {
            return RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }
}

