/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import org.apache.lucene.spatial.util.GeoDistanceUtils;
import org.apache.lucene.spatial.util.GeoProjectionUtils;
import org.apache.lucene.util.SloppyMath;

public class GeoRelationUtils {
    private GeoRelationUtils() {
    }

    public static boolean pointInRectPrecise(double lon, double lat, double minLon, double minLat, double maxLon, double maxLat) {
        return lon >= minLon && lon <= maxLon && lat >= minLat && lat <= maxLat;
    }

    public static boolean pointInPolygon(double[] x, double[] y, double lat, double lon) {
        assert (x.length == y.length);
        boolean inPoly = false;
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] <= lon && x[i - 1] >= lon) && (!(x[i - 1] <= lon) || !(x[i] >= lon)) || !(y[i] + (lon - x[i]) / (x[i - 1] - x[i]) * (y[i - 1] - y[i]) <= lat)) continue;
            inPoly = !inPoly;
        }
        return inPoly;
    }

    public static boolean rectDisjoint(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return aMaxX < bMinX || aMinX > bMaxX || aMaxY < bMinY || aMinY > bMaxY;
    }

    public static boolean rectWithin(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return !(aMinX < bMinX || aMinY < bMinY || aMaxX > bMaxX || aMaxY > bMaxY);
    }

    public static boolean rectCrosses(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return !GeoRelationUtils.rectDisjoint(aMinX, aMinY, aMaxX, aMaxY, bMinX, bMinY, bMaxX, bMaxY) && !GeoRelationUtils.rectWithin(aMinX, aMinY, aMaxX, aMaxY, bMinX, bMinY, bMaxX, bMaxY);
    }

    public static boolean rectContains(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return !(bMinX < aMinX || bMinY < aMinY || bMaxX > aMaxX || bMaxY > aMaxY);
    }

    public static boolean rectIntersects(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return !(aMaxX < bMinX || aMinX > bMaxX || aMaxY < bMinY || aMinY > bMaxY);
    }

    public static boolean rectCrossesPolyPrecise(double rMinX, double rMinY, double rMaxX, double rMaxY, double[] shapeX, double[] shapeY, double sMinX, double sMinY, double sMaxX, double sMaxY) {
        if (GeoRelationUtils.rectDisjoint(rMinX, rMinY, rMaxX, rMaxY, sMinX, sMinY, sMaxX, sMaxY)) {
            return false;
        }
        return GeoRelationUtils.rectCrossesPoly(rMinX, rMinY, rMaxX, rMaxY, shapeX, shapeY);
    }

    public static boolean rectCrossesPolyApprox(double rMinX, double rMinY, double rMaxX, double rMaxY, double[] shapeX, double[] shapeY, double sMinX, double sMinY, double sMaxX, double sMaxY) {
        if (GeoRelationUtils.rectDisjoint(rMinX, rMinY, rMaxX, rMaxY, sMinX, sMinY, sMaxX, sMaxY)) {
            return false;
        }
        int polyLength = shapeX.length - 1;
        for (int p = 0; p < polyLength; p = (int)((short)(p + 1))) {
            if (!GeoRelationUtils.lineCrossesRect(shapeX[p], shapeY[p], shapeX[p + 1], shapeY[p + 1], rMinX, rMinY, rMaxX, rMaxY)) continue;
            return true;
        }
        return false;
    }

    private static boolean rectCrossesPoly(double rMinX, double rMinY, double rMaxX, double rMaxY, double[] shapeX, double[] shapeY) {
        double[][] bbox = new double[][]{{rMinX, rMinY}, {rMaxX, rMinY}, {rMaxX, rMaxY}, {rMinX, rMaxY}, {rMinX, rMinY}};
        int polyLength = shapeX.length - 1;
        for (int b = 0; b < 4; b = (int)((short)(b + 1))) {
            double a1 = bbox[b + 1][1] - bbox[b][1];
            double b1 = bbox[b][0] - bbox[b + 1][0];
            double c1 = a1 * bbox[b + 1][0] + b1 * bbox[b + 1][1];
            for (int p = 0; p < polyLength; ++p) {
                boolean touching;
                double b2 = shapeX[p] - shapeX[p + 1];
                double a2 = shapeY[p + 1] - shapeY[p];
                double d = a1 * b2 - a2 * b1;
                if (d == 0.0) continue;
                double c2 = a2 * shapeX[p + 1] + b2 * shapeY[p + 1];
                double s2 = 1.0 / d * (b2 * c1 - b1 * c2);
                double t = 1.0 / d * (a1 * c2 - a2 * c1);
                double x00 = StrictMath.min(bbox[b][0], bbox[b + 1][0]) - 1.0E-6;
                double x01 = StrictMath.max(bbox[b][0], bbox[b + 1][0]) + 1.0E-6;
                double y00 = StrictMath.min(bbox[b][1], bbox[b + 1][1]) - 1.0E-6;
                double y01 = StrictMath.max(bbox[b][1], bbox[b + 1][1]) + 1.0E-6;
                double x10 = StrictMath.min(shapeX[p], shapeX[p + 1]) - 1.0E-6;
                double x11 = StrictMath.max(shapeX[p], shapeX[p + 1]) + 1.0E-6;
                double y10 = StrictMath.min(shapeY[p], shapeY[p + 1]) - 1.0E-6;
                double y11 = StrictMath.max(shapeY[p], shapeY[p + 1]) + 1.0E-6;
                boolean bl = touching = x00 == s2 && y00 == t || x01 == s2 && y01 == t || x10 == s2 && y10 == t || x11 == s2 && y11 == t;
                if (touching || x00 > s2 || x01 < s2 || y00 > t || y01 < t || x10 > s2 || x11 < s2 || y10 > t || y11 < t) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean lineCrossesRect(double aX1, double aY1, double aX2, double aY2, double rMinX, double rMinY, double rMaxX, double rMaxY) {
        if (GeoRelationUtils.pointInRectPrecise(aX1, aY1, rMinX, rMinY, rMaxX, rMaxY) ? !GeoRelationUtils.pointInRectPrecise(aX2, aY2, rMinX, rMinY, rMaxX, rMaxY) : GeoRelationUtils.pointInRectPrecise(aX2, aY2, rMinX, rMinY, rMaxX, rMaxY)) {
            return true;
        }
        return GeoRelationUtils.lineCrossesLine(aX1, aY1, aX2, aY2, rMinX, rMinY, rMaxX, rMaxY) || GeoRelationUtils.lineCrossesLine(aX1, aY1, aX2, aY2, rMaxX, rMinY, rMinX, rMaxY);
    }

    private static boolean lineCrossesLine(double aX1, double aY1, double aX2, double aY2, double bX1, double bY1, double bX2, double bY2) {
        double aX2X1d = aX2 - aX1;
        double aY2Y1d = aY2 - aY1;
        double bX2X1d = bX2 - bX1;
        double bY2Y1d = bY2 - bY1;
        double t1B = aX2X1d * (bY2 - aY1) - aY2Y1d * (bX2 - aX1);
        double test1 = (aX2X1d * (bY1 - aY1) - aY2Y1d * (bX1 - aX1)) * t1B;
        double t2B = bX2X1d * (aY2 - bY1) - bY2Y1d * (aX2 - bX1);
        double test2 = (bX2X1d * (aY1 - bY1) - bY2Y1d * (aX1 - bX1)) * t2B;
        if (test1 < 0.0 && test2 < 0.0) {
            return true;
        }
        if (test1 == 0.0 || test2 == 0.0) {
            if (aX1 == aX2 || bX1 == bX2) {
                double minAy = Math.min(aY1, aY2);
                double maxAy = Math.max(aY1, aY2);
                double minBy = Math.min(bY1, bY2);
                double maxBy = Math.max(bY1, bY2);
                return !(minBy >= maxAy) && !(maxBy <= minAy);
            }
            double minAx = Math.min(aX1, aX2);
            double maxAx = Math.max(aX1, aX2);
            double minBx = Math.min(bX1, bX2);
            double maxBx = Math.max(bX1, bX2);
            return !(minBx >= maxAx) && !(maxBx <= minAx);
        }
        return false;
    }

    public static boolean rectWithinPolyPrecise(double rMinX, double rMinY, double rMaxX, double rMaxY, double[] shapeX, double[] shapeY, double sMinX, double sMinY, double sMaxX, double sMaxY) {
        return !GeoRelationUtils.rectCrossesPolyPrecise(rMinX, rMinY, rMaxX, rMaxY, shapeX, shapeY, sMinX, sMinY, sMaxX, sMaxY) && GeoRelationUtils.pointInPolygon(shapeX, shapeY, rMinY, rMinX) && GeoRelationUtils.pointInPolygon(shapeX, shapeY, rMinY, rMaxX) && GeoRelationUtils.pointInPolygon(shapeX, shapeY, rMaxY, rMaxX) && GeoRelationUtils.pointInPolygon(shapeX, shapeY, rMaxY, rMinX);
    }

    public static boolean rectWithinPolyApprox(double rMinX, double rMinY, double rMaxX, double rMaxY, double[] shapeX, double[] shapeY, double sMinX, double sMinY, double sMaxX, double sMaxY) {
        if (GeoRelationUtils.rectCrosses(rMinX, rMinY, rMaxX, rMaxY, sMinX, sMinY, sMaxX, sMaxY)) {
            return false;
        }
        return !GeoRelationUtils.rectCrossesPolyApprox(rMinX, rMinY, rMaxX, rMaxY, shapeX, shapeY, sMinX, sMinY, sMaxX, sMaxY) && GeoRelationUtils.pointInPolygon(shapeX, shapeY, rMinY, rMinX);
    }

    private static boolean rectAnyCornersInCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters, boolean approx) {
        if (approx) {
            return GeoRelationUtils.rectAnyCornersInCircleSloppy(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radiusMeters);
        }
        double w = Math.abs(rMaxX - rMinX);
        if (w <= 90.0) {
            return GeoDistanceUtils.haversin(centerLat, centerLon, rMinY, rMinX) <= radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMaxY, rMinX) <= radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMaxY, rMaxX) <= radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMinY, rMaxX) <= radiusMeters;
        }
        double p1 = rMinX + (w /= 4.0);
        double p2 = p1 + w;
        double p3 = p2 + w;
        return GeoDistanceUtils.haversin(centerLat, centerLon, rMinY, rMinX) <= radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMaxY, rMinX) <= radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMaxY, p1) <= radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMinY, p1) <= radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMinY, p2) <= radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMaxY, p2) <= radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMaxY, p3) <= radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMinY, p3) <= radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMaxY, rMaxX) <= radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMinY, rMaxX) <= radiusMeters;
    }

    private static boolean rectAnyCornersInCircleSloppy(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters) {
        return SloppyMath.haversin(centerLat, centerLon, rMinY, rMinX) * 1000.0 <= radiusMeters || SloppyMath.haversin(centerLat, centerLon, rMaxY, rMinX) * 1000.0 <= radiusMeters || SloppyMath.haversin(centerLat, centerLon, rMaxY, rMaxX) * 1000.0 <= radiusMeters || SloppyMath.haversin(centerLat, centerLon, rMinY, rMaxX) * 1000.0 <= radiusMeters;
    }

    private static boolean rectAnyCornersOutsideCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters, boolean approx) {
        if (approx) {
            return GeoRelationUtils.rectAnyCornersOutsideCircleSloppy(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radiusMeters);
        }
        if (Math.abs(rMaxX - rMinX) <= 70.0) {
            return GeoDistanceUtils.haversin(centerLat, centerLon, rMinY, rMinX) > radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMaxY, rMinX) > radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMaxY, rMaxX) > radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMinY, rMaxX) > radiusMeters;
        }
        return GeoRelationUtils.rectCrossesOblateCircle(centerLon, centerLat, radiusMeters, rMinX, rMinY, rMaxX, rMaxY);
    }

    public static boolean rectCrossesOblateCircle(double centerLon, double centerLat, double radiusMeters, double rMinLon, double rMinLat, double rMaxLon, double rMaxLat) {
        double w = Math.abs(rMaxLon - rMinLon);
        int segs = (int)Math.ceil(w / 45.0);
        w /= (double)segs;
        int i = 1;
        double p1 = rMinLon;
        double[] pt = new double[2];
        do {
            double midLon;
            double d2;
            double maxLon = i == segs ? rMaxLon : p1 + w;
            double d1 = GeoDistanceUtils.haversin(centerLat, centerLon, rMinLat, p1);
            if (d1 > radiusMeters || (d2 = GeoDistanceUtils.haversin(centerLat, centerLon, rMinLat, maxLon)) > radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMaxLat, p1) > radiusMeters || GeoDistanceUtils.haversin(centerLat, centerLon, rMaxLat, maxLon) > radiusMeters) {
                return true;
            }
            if ((rMaxLat > 88.0 || rMinLat < -88.0) && (pt = GeoProjectionUtils.pointFromLonLatBearingGreatCircle(p1, rMinLat, GeoProjectionUtils.bearingGreatCircle(p1, rMinLat, p1, rMaxLat), radiusMeters - d1, pt))[1] < rMinLat || pt[1] < rMaxLat || (pt = GeoProjectionUtils.pointFromLonLatBearingGreatCircle(maxLon, rMinLat, GeoProjectionUtils.bearingGreatCircle(maxLon, rMinLat, maxLon, rMaxLat), radiusMeters - d2, pt))[1] < rMinLat || pt[1] < rMaxLat || (pt = GeoProjectionUtils.pointFromLonLatBearingGreatCircle(maxLon, rMinLat, GeoProjectionUtils.bearingGreatCircle(maxLon, rMinLat, midLon = p1 + 0.5 * (maxLon - p1), rMaxLat), radiusMeters - GeoDistanceUtils.haversin(centerLat, centerLon, rMinLat, midLon), pt))[1] < rMinLat || !(pt[1] < rMaxLat)) {
                return true;
            }
            p1 += w;
        } while ((i = (int)((short)(i + 1))) <= segs);
        return false;
    }

    private static boolean rectAnyCornersOutsideCircleSloppy(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters) {
        return SloppyMath.haversin(centerLat, centerLon, rMinY, rMinX) * 1000.0 > radiusMeters || SloppyMath.haversin(centerLat, centerLon, rMaxY, rMinX) * 1000.0 > radiusMeters || SloppyMath.haversin(centerLat, centerLon, rMaxY, rMaxX) * 1000.0 > radiusMeters || SloppyMath.haversin(centerLat, centerLon, rMinY, rMaxX) * 1000.0 > radiusMeters;
    }

    public static boolean rectWithinCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters) {
        return GeoRelationUtils.rectWithinCircle(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radiusMeters, false);
    }

    public static boolean rectWithinCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters, boolean approx) {
        return !GeoRelationUtils.rectAnyCornersOutsideCircle(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radiusMeters, approx);
    }

    public static boolean rectCrossesCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters) {
        return GeoRelationUtils.rectCrossesCircle(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radiusMeters, false);
    }

    public static boolean rectCrossesCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters, boolean approx) {
        if (approx) {
            return GeoRelationUtils.rectAnyCornersInCircle(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radiusMeters, approx) || GeoRelationUtils.isClosestPointOnRectWithinRange(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radiusMeters, approx);
        }
        return GeoRelationUtils.rectAnyCornersInCircle(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radiusMeters, approx) && GeoRelationUtils.rectAnyCornersOutsideCircle(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radiusMeters, approx) || GeoRelationUtils.isClosestPointOnRectWithinRange(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radiusMeters, approx);
    }

    private static boolean isClosestPointOnRectWithinRange(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters, boolean approx) {
        boolean haverShortCut;
        double[] closestPt = new double[]{0.0, 0.0};
        GeoDistanceUtils.closestPointOnBBox(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, closestPt);
        boolean bl = haverShortCut = GeoDistanceUtils.haversin(centerLat, centerLon, closestPt[1], closestPt[0]) <= radiusMeters;
        if (approx || haverShortCut) {
            return haverShortCut;
        }
        double lon1 = rMinX;
        double lon2 = rMaxX;
        double lat1 = rMinY;
        double lat2 = rMaxY;
        if (closestPt[0] == rMinX || closestPt[0] == rMaxX) {
            lon2 = lon1 = closestPt[0];
        } else if (closestPt[1] == rMinY || closestPt[1] == rMaxY) {
            lat2 = lat1 = closestPt[1];
        }
        return GeoRelationUtils.lineCrossesSphere(lon1, lat1, 0.0, lon2, lat2, 0.0, centerLon, centerLat, 0.0, radiusMeters);
    }

    private static boolean lineCrossesSphere(double lon1, double lat1, double alt1, double lon2, double lat2, double alt2, double centerLon, double centerLat, double centerAlt, double radiusMeters) {
        double[] ecf1 = GeoProjectionUtils.llaToECF(lon1, lat1, alt1, null);
        double[] ecf2 = GeoProjectionUtils.llaToECF(lon2, lat2, alt2, null);
        double[] cntr = GeoProjectionUtils.llaToECF(centerLon, centerLat, centerAlt, null);
        double[] oneEighty = GeoProjectionUtils.pointFromLonLatBearingGreatCircle(centerLon, centerLat, 180.0, radiusMeters, new double[3]);
        GeoProjectionUtils.llaToECF(oneEighty[0], oneEighty[1], 0.0, oneEighty);
        radiusMeters = GeoDistanceUtils.linearDistance(oneEighty, cntr);
        double dX = ecf2[0] - ecf1[0];
        double dY = ecf2[1] - ecf1[1];
        double dZ = ecf2[2] - ecf1[2];
        double fX = ecf1[0] - cntr[0];
        double fY = ecf1[1] - cntr[1];
        double fZ = ecf1[2] - cntr[2];
        double a = dX * dX + dY * dY + dZ * dZ;
        double b = 2.0 * (fX * dX + fY * dY + fZ * dZ);
        double c = fX * fX + fY * fY + fZ * fZ - radiusMeters * radiusMeters;
        double discrim = b * b - 4.0 * a * c;
        if (discrim < 0.0) {
            return false;
        }
        discrim = StrictMath.sqrt(discrim);
        double a2 = 2.0 * a;
        double t1 = (-b - discrim) / a2;
        double t2 = (-b + discrim) / a2;
        if (t1 < 0.0 || t1 > 1.0) {
            return !(t2 < 0.0) && !(t2 > 1.0);
        }
        return true;
    }
}

