/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.query;

import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class SpatialOperation
implements Serializable {
    private static final Map<String, SpatialOperation> registry = new HashMap<String, SpatialOperation>();
    private static final List<SpatialOperation> list = new ArrayList<SpatialOperation>();
    public static final SpatialOperation BBoxIntersects = new SpatialOperation("BBoxIntersects"){

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return indexedShape.getBoundingBox().relate(queryShape).intersects();
        }
    };
    public static final SpatialOperation BBoxWithin = new SpatialOperation("BBoxWithin"){
        {
            this.register("BBoxCoveredBy");
        }

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            Rectangle bbox = indexedShape.getBoundingBox();
            return bbox.relate(queryShape) == SpatialRelation.WITHIN || bbox.equals(queryShape);
        }
    };
    public static final SpatialOperation Contains = new SpatialOperation("Contains"){
        {
            this.register("Covers");
        }

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return indexedShape.relate(queryShape) == SpatialRelation.CONTAINS || indexedShape.equals(queryShape);
        }
    };
    public static final SpatialOperation Intersects = new SpatialOperation("Intersects"){

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return indexedShape.relate(queryShape).intersects();
        }
    };
    public static final SpatialOperation IsEqualTo = new SpatialOperation("Equals"){
        {
            this.register("IsEqualTo");
        }

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return indexedShape.equals(queryShape);
        }
    };
    public static final SpatialOperation IsDisjointTo = new SpatialOperation("Disjoint"){
        {
            this.register("IsDisjointTo");
        }

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return !indexedShape.relate(queryShape).intersects();
        }
    };
    public static final SpatialOperation IsWithin = new SpatialOperation("Within"){
        {
            this.register("IsWithin");
            this.register("CoveredBy");
        }

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return indexedShape.relate(queryShape) == SpatialRelation.WITHIN || indexedShape.equals(queryShape);
        }
    };
    public static final SpatialOperation Overlaps = new SpatialOperation("Overlaps"){

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return indexedShape.relate(queryShape) == SpatialRelation.INTERSECTS;
        }
    };
    private final String name;

    protected SpatialOperation(String name) {
        this.name = name;
        this.register(name);
        list.add(this);
    }

    protected void register(String name) {
        registry.put(name, this);
        registry.put(name.toUpperCase(Locale.ROOT), this);
    }

    public static SpatialOperation get(String v) {
        SpatialOperation op = registry.get(v);
        if (op == null) {
            op = registry.get(v.toUpperCase(Locale.ROOT));
        }
        if (op == null) {
            throw new IllegalArgumentException("Unknown Operation: " + v);
        }
        return op;
    }

    public static List<SpatialOperation> values() {
        return list;
    }

    public static boolean is(SpatialOperation op, SpatialOperation ... tst) {
        for (SpatialOperation t : tst) {
            if (op != t) continue;
            return true;
        }
        return false;
    }

    public abstract boolean evaluate(Shape var1, Shape var2);

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

