/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import org.apache.lucene.search.spans.FilterSpans;
import org.apache.lucene.search.spans.SpanPositionCheckQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanPositionRangeQuery
extends SpanPositionCheckQuery {
    protected int start;
    protected int end;

    public SpanPositionRangeQuery(SpanQuery match, int start, int end) {
        super(match);
        this.start = start;
        this.end = end;
    }

    @Override
    protected FilterSpans.AcceptStatus acceptPosition(Spans spans) throws IOException {
        assert (spans.startPosition() != spans.endPosition());
        FilterSpans.AcceptStatus res = spans.startPosition() >= this.end ? FilterSpans.AcceptStatus.NO_MORE_IN_CURRENT_DOC : (spans.startPosition() >= this.start && spans.endPosition() <= this.end ? FilterSpans.AcceptStatus.YES : FilterSpans.AcceptStatus.NO);
        return res;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanPosRange(");
        buffer.append(this.match.toString(field));
        buffer.append(", ").append(this.start).append(", ");
        buffer.append(this.end);
        buffer.append(")");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SpanPositionRangeQuery other = (SpanPositionRangeQuery)o;
        return this.end == other.end && this.start == other.start;
    }

    @Override
    public int hashCode() {
        int h2 = super.hashCode() ^ this.end;
        h2 = h2 * 127 ^ this.start;
        return h2;
    }
}

