/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocValuesDocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

@Deprecated
public abstract class DocValuesRangeFilter<T>
extends Filter {
    final String field;
    final T lowerVal;
    final T upperVal;
    final boolean includeLower;
    final boolean includeUpper;

    private DocValuesRangeFilter(String field, T lowerVal, T upperVal, boolean includeLower, boolean includeUpper) {
        this.field = field;
        this.lowerVal = lowerVal;
        this.upperVal = upperVal;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    @Override
    public abstract DocIdSet getDocIdSet(LeafReaderContext var1, Bits var2) throws IOException;

    public static DocValuesRangeFilter<String> newStringRange(String field, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        return new DocValuesRangeFilter<String>(field, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
                int upperPoint;
                final SortedDocValues fcsi = DocValues.getSorted(context.reader(), this.field);
                int lowerPoint = this.lowerVal == null ? -1 : fcsi.lookupTerm(new BytesRef((CharSequence)this.lowerVal));
                int n = upperPoint = this.upperVal == null ? -1 : fcsi.lookupTerm(new BytesRef((CharSequence)this.upperVal));
                final int inclusiveLowerPoint = lowerPoint == -1 && this.lowerVal == null ? 0 : (this.includeLower && lowerPoint >= 0 ? lowerPoint : (lowerPoint >= 0 ? lowerPoint + 1 : Math.max(0, -lowerPoint - 1)));
                final int inclusiveUpperPoint = upperPoint == -1 && this.upperVal == null ? Integer.MAX_VALUE : (this.includeUpper && upperPoint >= 0 ? upperPoint : (upperPoint >= 0 ? upperPoint - 1 : -upperPoint - 2));
                if (inclusiveUpperPoint < 0 || inclusiveLowerPoint > inclusiveUpperPoint) {
                    return null;
                }
                assert (inclusiveLowerPoint >= 0 && inclusiveUpperPoint >= 0);
                return new DocValuesDocIdSet(context.reader().maxDoc(), acceptDocs){

                    @Override
                    protected final boolean matchDoc(int doc) {
                        int docOrd = fcsi.getOrd(doc);
                        return docOrd >= inclusiveLowerPoint && docOrd <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static DocValuesRangeFilter<BytesRef> newBytesRefRange(String field, BytesRef lowerVal, BytesRef upperVal, boolean includeLower, boolean includeUpper) {
        return new DocValuesRangeFilter<BytesRef>(field, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
                int upperPoint;
                final SortedDocValues fcsi = DocValues.getSorted(context.reader(), this.field);
                int lowerPoint = this.lowerVal == null ? -1 : fcsi.lookupTerm((BytesRef)this.lowerVal);
                int n = upperPoint = this.upperVal == null ? -1 : fcsi.lookupTerm((BytesRef)this.upperVal);
                final int inclusiveLowerPoint = lowerPoint == -1 && this.lowerVal == null ? 0 : (this.includeLower && lowerPoint >= 0 ? lowerPoint : (lowerPoint >= 0 ? lowerPoint + 1 : Math.max(0, -lowerPoint - 1)));
                final int inclusiveUpperPoint = upperPoint == -1 && this.upperVal == null ? Integer.MAX_VALUE : (this.includeUpper && upperPoint >= 0 ? upperPoint : (upperPoint >= 0 ? upperPoint - 1 : -upperPoint - 2));
                if (inclusiveUpperPoint < 0 || inclusiveLowerPoint > inclusiveUpperPoint) {
                    return null;
                }
                assert (inclusiveLowerPoint >= 0 && inclusiveUpperPoint >= 0);
                return new DocValuesDocIdSet(context.reader().maxDoc(), acceptDocs){

                    @Override
                    protected final boolean matchDoc(int doc) {
                        int docOrd = fcsi.getOrd(doc);
                        return docOrd >= inclusiveLowerPoint && docOrd <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static DocValuesRangeFilter<Integer> newIntRange(String field, Integer lowerVal, Integer upperVal, boolean includeLower, boolean includeUpper) {
        return new DocValuesRangeFilter<Integer>(field, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
                int inclusiveUpperPoint;
                int inclusiveLowerPoint;
                int i;
                if (this.lowerVal != null) {
                    i = (Integer)this.lowerVal;
                    if (!this.includeLower && i == Integer.MAX_VALUE) {
                        return null;
                    }
                    inclusiveLowerPoint = this.includeLower ? i : i + 1;
                } else {
                    inclusiveLowerPoint = Integer.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    i = (Integer)this.upperVal;
                    if (!this.includeUpper && i == Integer.MIN_VALUE) {
                        return null;
                    }
                    inclusiveUpperPoint = this.includeUpper ? i : i - 1;
                } else {
                    inclusiveUpperPoint = Integer.MAX_VALUE;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return null;
                }
                final NumericDocValues values = DocValues.getNumeric(context.reader(), this.field);
                return new DocValuesDocIdSet(context.reader().maxDoc(), acceptDocs){

                    @Override
                    protected boolean matchDoc(int doc) {
                        int value = (int)values.get(doc);
                        return value >= inclusiveLowerPoint && value <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static DocValuesRangeFilter<Long> newLongRange(String field, Long lowerVal, Long upperVal, boolean includeLower, boolean includeUpper) {
        return new DocValuesRangeFilter<Long>(field, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
                long inclusiveUpperPoint;
                long inclusiveLowerPoint;
                long i;
                if (this.lowerVal != null) {
                    i = (Long)this.lowerVal;
                    if (!this.includeLower && i == Long.MAX_VALUE) {
                        return null;
                    }
                    inclusiveLowerPoint = this.includeLower ? i : i + 1L;
                } else {
                    inclusiveLowerPoint = Long.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    i = (Long)this.upperVal;
                    if (!this.includeUpper && i == Long.MIN_VALUE) {
                        return null;
                    }
                    inclusiveUpperPoint = this.includeUpper ? i : i - 1L;
                } else {
                    inclusiveUpperPoint = Long.MAX_VALUE;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return null;
                }
                final NumericDocValues values = DocValues.getNumeric(context.reader(), this.field);
                return new DocValuesDocIdSet(context.reader().maxDoc(), acceptDocs){

                    @Override
                    protected boolean matchDoc(int doc) {
                        long value = values.get(doc);
                        return value >= inclusiveLowerPoint && value <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static DocValuesRangeFilter<Float> newFloatRange(String field, Float lowerVal, Float upperVal, boolean includeLower, boolean includeUpper) {
        return new DocValuesRangeFilter<Float>(field, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
                float inclusiveUpperPoint;
                float inclusiveLowerPoint;
                int i;
                float f;
                if (this.lowerVal != null) {
                    f = ((Float)this.lowerVal).floatValue();
                    if (!this.includeUpper && f > 0.0f && Float.isInfinite(f)) {
                        return null;
                    }
                    i = NumericUtils.floatToSortableInt(f);
                    inclusiveLowerPoint = NumericUtils.sortableIntToFloat(this.includeLower ? i : i + 1);
                } else {
                    inclusiveLowerPoint = Float.NEGATIVE_INFINITY;
                }
                if (this.upperVal != null) {
                    f = ((Float)this.upperVal).floatValue();
                    if (!this.includeUpper && f < 0.0f && Float.isInfinite(f)) {
                        return null;
                    }
                    i = NumericUtils.floatToSortableInt(f);
                    inclusiveUpperPoint = NumericUtils.sortableIntToFloat(this.includeUpper ? i : i - 1);
                } else {
                    inclusiveUpperPoint = Float.POSITIVE_INFINITY;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return null;
                }
                final NumericDocValues values = DocValues.getNumeric(context.reader(), this.field);
                return new DocValuesDocIdSet(context.reader().maxDoc(), acceptDocs){

                    @Override
                    protected boolean matchDoc(int doc) {
                        float value = Float.intBitsToFloat((int)values.get(doc));
                        return value >= inclusiveLowerPoint && value <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static DocValuesRangeFilter<Double> newDoubleRange(String field, Double lowerVal, Double upperVal, boolean includeLower, boolean includeUpper) {
        return new DocValuesRangeFilter<Double>(field, lowerVal, upperVal, includeLower, includeUpper){

            @Override
            public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
                double inclusiveUpperPoint;
                double inclusiveLowerPoint;
                long i;
                double f;
                if (this.lowerVal != null) {
                    f = (Double)this.lowerVal;
                    if (!this.includeUpper && f > 0.0 && Double.isInfinite(f)) {
                        return null;
                    }
                    i = NumericUtils.doubleToSortableLong(f);
                    inclusiveLowerPoint = NumericUtils.sortableLongToDouble(this.includeLower ? i : i + 1L);
                } else {
                    inclusiveLowerPoint = Double.NEGATIVE_INFINITY;
                }
                if (this.upperVal != null) {
                    f = (Double)this.upperVal;
                    if (!this.includeUpper && f < 0.0 && Double.isInfinite(f)) {
                        return null;
                    }
                    i = NumericUtils.doubleToSortableLong(f);
                    inclusiveUpperPoint = NumericUtils.sortableLongToDouble(this.includeUpper ? i : i - 1L);
                } else {
                    inclusiveUpperPoint = Double.POSITIVE_INFINITY;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return null;
                }
                final NumericDocValues values = DocValues.getNumeric(context.reader(), this.field);
                return new DocValuesDocIdSet(context.reader().maxDoc(), acceptDocs){

                    @Override
                    protected boolean matchDoc(int doc) {
                        double value = Double.longBitsToDouble(values.get(doc));
                        return value >= inclusiveLowerPoint && value <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    @Override
    public final String toString(String defaultField) {
        StringBuilder sb = new StringBuilder(this.field).append(":");
        return sb.append(this.includeLower ? (char)'[' : '{').append(this.lowerVal == null ? "*" : this.lowerVal.toString()).append(" TO ").append(this.upperVal == null ? "*" : this.upperVal.toString()).append(this.includeUpper ? (char)']' : '}').toString();
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        DocValuesRangeFilter other = (DocValuesRangeFilter)o;
        if (!this.field.equals(other.field) || this.includeLower != other.includeLower || this.includeUpper != other.includeUpper) {
            return false;
        }
        if (this.lowerVal != null ? !this.lowerVal.equals(other.lowerVal) : other.lowerVal != null) {
            return false;
        }
        return !(this.upperVal != null ? !this.upperVal.equals(other.upperVal) : other.upperVal != null);
    }

    @Override
    public final int hashCode() {
        int h2 = super.hashCode();
        h2 = 31 * h2 + this.field.hashCode();
        h2 ^= this.lowerVal != null ? this.lowerVal.hashCode() : 550356204;
        h2 = h2 << 1 | h2 >>> 31;
        h2 ^= this.upperVal != null ? this.upperVal.hashCode() : -1674416163;
        return h2 ^= (this.includeLower ? 1549299360 : -365038026) ^ (this.includeUpper ? 1721088258 : 1948649653);
    }

    public String getField() {
        return this.field;
    }

    public boolean includesLower() {
        return this.includeLower;
    }

    public boolean includesUpper() {
        return this.includeUpper;
    }

    public T getLowerVal() {
        return this.lowerVal;
    }

    public T getUpperVal() {
        return this.upperVal;
    }
}

