/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public final class DisjunctionMaxQuery
extends Query
implements Iterable<Query> {
    private final ArrayList<Query> disjuncts = new ArrayList();
    private final float tieBreakerMultiplier;

    @Deprecated
    public DisjunctionMaxQuery(float tieBreakerMultiplier) {
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    public DisjunctionMaxQuery(Collection<Query> disjuncts, float tieBreakerMultiplier) {
        Objects.requireNonNull(disjuncts, "Collection of Querys must not be null");
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        this.add(disjuncts);
    }

    @Deprecated
    public void add(Query query) {
        this.disjuncts.add(Objects.requireNonNull(query, "Query must not be null"));
    }

    @Deprecated
    public void add(Collection<Query> disjuncts) {
        this.disjuncts.addAll(Objects.requireNonNull(disjuncts, "Query connection must not be null"));
    }

    @Override
    public Iterator<Query> iterator() {
        return this.disjuncts.iterator();
    }

    public ArrayList<Query> getDisjuncts() {
        return this.disjuncts;
    }

    public float getTieBreakerMultiplier() {
        return this.tieBreakerMultiplier;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new DisjunctionMaxWeight(searcher, needsScores);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        int numDisjunctions = this.disjuncts.size();
        if (numDisjunctions == 1) {
            return this.disjuncts.get(0);
        }
        boolean actuallyRewritten = false;
        ArrayList<Query> rewrittenDisjuncts = new ArrayList<Query>();
        for (Query sub : this.disjuncts) {
            Query rewrittenSub = sub.rewrite(reader);
            actuallyRewritten |= rewrittenSub != sub;
            rewrittenDisjuncts.add(rewrittenSub);
        }
        if (actuallyRewritten) {
            return new DisjunctionMaxQuery(rewrittenDisjuncts, this.tieBreakerMultiplier);
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        int numDisjunctions = this.disjuncts.size();
        for (int i = 0; i < numDisjunctions; ++i) {
            Query subquery = this.disjuncts.get(i);
            if (subquery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subquery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subquery.toString(field));
            }
            if (i == numDisjunctions - 1) continue;
            buffer.append(" | ");
        }
        buffer.append(")");
        if (this.tieBreakerMultiplier != 0.0f) {
            buffer.append("~");
            buffer.append(this.tieBreakerMultiplier);
        }
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DisjunctionMaxQuery)) {
            return false;
        }
        DisjunctionMaxQuery other = (DisjunctionMaxQuery)o;
        return super.equals(o) && this.tieBreakerMultiplier == other.tieBreakerMultiplier && this.disjuncts.equals(other.disjuncts);
    }

    @Override
    public int hashCode() {
        int h2 = super.hashCode();
        h2 = 31 * h2 + Float.floatToIntBits(this.tieBreakerMultiplier);
        h2 = 31 * h2 + this.disjuncts.hashCode();
        return h2;
    }

    protected class DisjunctionMaxWeight
    extends Weight {
        protected final ArrayList<Weight> weights;
        private final boolean needsScores;

        public DisjunctionMaxWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            super(DisjunctionMaxQuery.this);
            this.weights = new ArrayList();
            for (Query disjunctQuery : DisjunctionMaxQuery.this.disjuncts) {
                this.weights.add(searcher.createWeight(disjunctQuery, needsScores));
            }
            this.needsScores = needsScores;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            for (Weight weight : this.weights) {
                weight.extractTerms(terms);
            }
        }

        @Override
        public float getValueForNormalization() throws IOException {
            float max = 0.0f;
            float sum = 0.0f;
            for (Weight currentWeight : this.weights) {
                float sub = currentWeight.getValueForNormalization();
                sum += sub;
                max = Math.max(max, sub);
            }
            return (sum - max) * DisjunctionMaxQuery.this.tieBreakerMultiplier * DisjunctionMaxQuery.this.tieBreakerMultiplier + max;
        }

        @Override
        public void normalize(float norm, float boost) {
            for (Weight wt : this.weights) {
                wt.normalize(norm, boost);
            }
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            ArrayList<Scorer> scorers = new ArrayList<Scorer>();
            for (Weight w : this.weights) {
                Scorer subScorer = w.scorer(context);
                if (subScorer == null) continue;
                scorers.add(subScorer);
            }
            if (scorers.isEmpty()) {
                return null;
            }
            if (scorers.size() == 1) {
                return (Scorer)scorers.get(0);
            }
            return new DisjunctionMaxScorer(this, DisjunctionMaxQuery.this.tieBreakerMultiplier, scorers, this.needsScores);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            boolean match = false;
            float max = 0.0f;
            float sum = 0.0f;
            ArrayList<Explanation> subs = new ArrayList<Explanation>();
            for (Weight wt : this.weights) {
                Explanation e = wt.explain(context, doc);
                if (!e.isMatch()) continue;
                match = true;
                subs.add(e);
                sum += e.getValue();
                max = Math.max(max, e.getValue());
            }
            if (match) {
                float score = max + (sum - max) * DisjunctionMaxQuery.this.tieBreakerMultiplier;
                String desc = DisjunctionMaxQuery.this.tieBreakerMultiplier == 0.0f ? "max of:" : "max plus " + DisjunctionMaxQuery.this.tieBreakerMultiplier + " times others of:";
                return Explanation.match(score, desc, subs);
            }
            return Explanation.noMatch("No matching clause", new Explanation[0]);
        }
    }
}

