/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueLong;

public class LongFieldSource
extends FieldCacheSource {
    public LongFieldSource(String field) {
        super(field);
    }

    @Override
    public String description() {
        return "long(" + this.field + ')';
    }

    public long externalToLong(String extVal) {
        return Long.parseLong(extVal);
    }

    public Object longToObject(long val) {
        return val;
    }

    public String longToString(long val) {
        return this.longToObject(val).toString();
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortField(this.field, SortField.Type.LONG, reverse);
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues arr = DocValues.getNumeric(readerContext.reader(), this.field);
        final Bits valid = DocValues.getDocsWithField(readerContext.reader(), this.field);
        return new LongDocValues(this){

            @Override
            public long longVal(int doc) {
                return arr.get(doc);
            }

            @Override
            public boolean exists(int doc) {
                return arr.get(doc) != 0L || valid.get(doc);
            }

            @Override
            public Object objectVal(int doc) {
                return valid.get(doc) ? LongFieldSource.this.longToObject(arr.get(doc)) : null;
            }

            @Override
            public String strVal(int doc) {
                return valid.get(doc) ? LongFieldSource.this.longToString(arr.get(doc)) : null;
            }

            @Override
            protected long externalToLong(String extVal) {
                return LongFieldSource.this.externalToLong(extVal);
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueLong mval;
                    {
                        this.mval = LongFieldSource.this.newMutableValueLong();
                    }

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) {
                        this.mval.value = arr.get(doc);
                        this.mval.exists = this.mval.value != 0L || valid.get(doc);
                    }
                };
            }
        };
    }

    protected MutableValueLong newMutableValueLong() {
        return new MutableValueLong();
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        LongFieldSource other = (LongFieldSource)o;
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int h2 = this.getClass().hashCode();
        return h2 += super.hashCode();
    }
}

