/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Iterator;
import org.apache.lucene.index.DocumentsWriterFlushControl;
import org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.util.InfoStream;

abstract class FlushPolicy {
    protected LiveIndexWriterConfig indexWriterConfig;
    protected InfoStream infoStream;

    FlushPolicy() {
    }

    public abstract void onDelete(DocumentsWriterFlushControl var1, DocumentsWriterPerThreadPool.ThreadState var2);

    public void onUpdate(DocumentsWriterFlushControl control, DocumentsWriterPerThreadPool.ThreadState state) {
        this.onInsert(control, state);
        this.onDelete(control, state);
    }

    public abstract void onInsert(DocumentsWriterFlushControl var1, DocumentsWriterPerThreadPool.ThreadState var2);

    protected synchronized void init(LiveIndexWriterConfig indexWriterConfig) {
        this.indexWriterConfig = indexWriterConfig;
        this.infoStream = indexWriterConfig.getInfoStream();
    }

    protected DocumentsWriterPerThreadPool.ThreadState findLargestNonPendingWriter(DocumentsWriterFlushControl control, DocumentsWriterPerThreadPool.ThreadState perThreadState) {
        assert (perThreadState.dwpt.getNumDocsInRAM() > 0);
        long maxRamSoFar = perThreadState.bytesUsed;
        DocumentsWriterPerThreadPool.ThreadState maxRamUsingThreadState = perThreadState;
        assert (!perThreadState.flushPending) : "DWPT should have flushed";
        Iterator<DocumentsWriterPerThreadPool.ThreadState> activePerThreadsIterator = control.allActiveThreadStates();
        int count = 0;
        while (activePerThreadsIterator.hasNext()) {
            long nextRam;
            DocumentsWriterPerThreadPool.ThreadState next = activePerThreadsIterator.next();
            if (next.flushPending || (nextRam = next.bytesUsed) <= 0L || next.dwpt.getNumDocsInRAM() <= 0) continue;
            if (this.infoStream.isEnabled("FP")) {
                this.infoStream.message("FP", "thread state has " + nextRam + " bytes; docInRAM=" + next.dwpt.getNumDocsInRAM());
            }
            ++count;
            if (nextRam <= maxRamSoFar) continue;
            maxRamSoFar = nextRam;
            maxRamUsingThreadState = next;
        }
        if (this.infoStream.isEnabled("FP")) {
            this.infoStream.message("FP", count + " in-use non-flushing threads states");
        }
        assert (this.assertMessage("set largest ram consuming thread pending on lower watermark"));
        return maxRamUsingThreadState;
    }

    private boolean assertMessage(String s2) {
        if (this.infoStream.isEnabled("FP")) {
            this.infoStream.message("FP", s2);
        }
        return true;
    }
}

