/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.Bounds;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.LatLonBounds;
import org.apache.lucene.geo3d.Membership;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.Vector;
import org.apache.lucene.geo3d.XYZBounds;

public class Plane
extends Vector {
    protected static final GeoPoint[] NO_POINTS = new GeoPoint[0];
    protected static final Membership[] NO_BOUNDS = new Membership[0];
    protected static final Plane normalYPlane = new Plane(0.0, 1.0, 0.0, 0.0);
    protected static final Plane normalXPlane = new Plane(1.0, 0.0, 0.0, 0.0);
    protected static final Plane normalZPlane = new Plane(0.0, 0.0, 1.0, 0.0);
    public final double D;

    public Plane(double A2, double B, double C2, double D) {
        super(A2, B, C2);
        this.D = D;
    }

    public Plane(Vector A2, Vector B) {
        super(A2, B);
        this.D = 0.0;
    }

    public Plane(PlanetModel planetModel, double sinLat) {
        super(0.0, 0.0, 1.0);
        this.D = -sinLat * Plane.computeDesiredEllipsoidMagnitude(planetModel, sinLat);
    }

    public Plane(double x, double y) {
        super(y, -x, 0.0);
        this.D = 0.0;
    }

    public Plane(Vector v, double D) {
        super(v.x, v.y, v.z);
        this.D = D;
    }

    public static Plane constructNormalizedZPlane(Vector ... planePoints) {
        double bestDistance = 0.0;
        Vector bestPoint = null;
        for (Vector point : planePoints) {
            double pointDist = point.x * point.x + point.y * point.y;
            if (!(pointDist > bestDistance)) continue;
            bestDistance = pointDist;
            bestPoint = point;
        }
        return Plane.constructNormalizedZPlane(bestPoint.x, bestPoint.y);
    }

    public static Plane constructNormalizedYPlane(Vector ... planePoints) {
        double bestDistance = 0.0;
        Vector bestPoint = null;
        for (Vector point : planePoints) {
            double pointDist = point.x * point.x + point.z * point.z;
            if (!(pointDist > bestDistance)) continue;
            bestDistance = pointDist;
            bestPoint = point;
        }
        return Plane.constructNormalizedYPlane(bestPoint.x, bestPoint.z, 0.0);
    }

    public static Plane constructNormalizedXPlane(Vector ... planePoints) {
        double bestDistance = 0.0;
        Vector bestPoint = null;
        for (Vector point : planePoints) {
            double pointDist = point.y * point.y + point.z * point.z;
            if (!(pointDist > bestDistance)) continue;
            bestDistance = pointDist;
            bestPoint = point;
        }
        return Plane.constructNormalizedXPlane(bestPoint.y, bestPoint.z, 0.0);
    }

    public static Plane constructNormalizedZPlane(double x, double y) {
        if (Math.abs(x) < 1.0E-12 && Math.abs(y) < 1.0E-12) {
            return null;
        }
        double denom = 1.0 / Math.sqrt(x * x + y * y);
        return new Plane(y * denom, -x * denom, 0.0, 0.0);
    }

    public static Plane constructNormalizedYPlane(double x, double z, double DValue) {
        if (Math.abs(x) < 1.0E-12 && Math.abs(z) < 1.0E-12) {
            return null;
        }
        double denom = 1.0 / Math.sqrt(x * x + z * z);
        return new Plane(z * denom, 0.0, -x * denom, DValue);
    }

    public static Plane constructNormalizedXPlane(double y, double z, double DValue) {
        if (Math.abs(y) < 1.0E-12 && Math.abs(z) < 1.0E-12) {
            return null;
        }
        double denom = 1.0 / Math.sqrt(y * y + z * z);
        return new Plane(0.0, z * denom, -y * denom, DValue);
    }

    public double evaluate(Vector v) {
        return this.dotProduct(v) + this.D;
    }

    public double evaluate(double x, double y, double z) {
        return this.dotProduct(x, y, z) + this.D;
    }

    public boolean evaluateIsZero(Vector v) {
        return Math.abs(this.evaluate(v)) < 1.0E-12;
    }

    public boolean evaluateIsZero(double x, double y, double z) {
        return Math.abs(this.evaluate(x, y, z)) < 1.0E-12;
    }

    @Override
    public Plane normalize() {
        Vector normVect = super.normalize();
        if (normVect == null) {
            return null;
        }
        return new Plane(normVect, this.D);
    }

    public double arcDistance(PlanetModel planetModel, GeoPoint v, Membership ... bounds) {
        return this.arcDistance(planetModel, v.x, v.y, v.z, bounds);
    }

    public double arcDistance(PlanetModel planetModel, double x, double y, double z, Membership ... bounds) {
        if (this.evaluateIsZero(x, y, z)) {
            if (Plane.meetsAllBounds(x, y, z, bounds)) {
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        Plane perpPlane = new Plane(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x, 0.0);
        GeoPoint[] intersectionPoints = this.findIntersections(planetModel, perpPlane, new Membership[0]);
        double minDistance = Double.MAX_VALUE;
        for (GeoPoint intersectionPoint : intersectionPoints) {
            double theDistance;
            if (!Plane.meetsAllBounds(intersectionPoint, bounds) || !((theDistance = intersectionPoint.arcDistance(x, y, z)) < minDistance)) continue;
            minDistance = theDistance;
        }
        return minDistance;
    }

    public double normalDistance(Vector v, Membership ... bounds) {
        return this.normalDistance(v.x, v.y, v.z, bounds);
    }

    public double normalDistance(double x, double y, double z, Membership ... bounds) {
        double perpZ;
        double perpY;
        double dist = this.evaluate(x, y, z);
        double perpX = x - dist * this.x;
        if (!Plane.meetsAllBounds(perpX, perpY = y - dist * this.y, perpZ = z - dist * this.z, bounds)) {
            return Double.MAX_VALUE;
        }
        return Math.abs(dist);
    }

    public double normalDistanceSquared(Vector v, Membership ... bounds) {
        return this.normalDistanceSquared(v.x, v.y, v.z, bounds);
    }

    public double normalDistanceSquared(double x, double y, double z, Membership ... bounds) {
        double normal = this.normalDistance(x, y, z, bounds);
        if (normal == Double.MAX_VALUE) {
            return normal;
        }
        return normal * normal;
    }

    public double linearDistance(PlanetModel planetModel, GeoPoint v, Membership ... bounds) {
        return this.linearDistance(planetModel, v.x, v.y, v.z, bounds);
    }

    public double linearDistance(PlanetModel planetModel, double x, double y, double z, Membership ... bounds) {
        if (this.evaluateIsZero(x, y, z)) {
            if (Plane.meetsAllBounds(x, y, z, bounds)) {
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        Plane perpPlane = new Plane(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x, 0.0);
        GeoPoint[] intersectionPoints = this.findIntersections(planetModel, perpPlane, new Membership[0]);
        double minDistance = Double.MAX_VALUE;
        for (GeoPoint intersectionPoint : intersectionPoints) {
            double theDistance;
            if (!Plane.meetsAllBounds(intersectionPoint, bounds) || !((theDistance = intersectionPoint.linearDistance(x, y, z)) < minDistance)) continue;
            minDistance = theDistance;
        }
        return minDistance;
    }

    public double linearDistanceSquared(PlanetModel planetModel, GeoPoint v, Membership ... bounds) {
        return this.linearDistanceSquared(planetModel, v.x, v.y, v.z, bounds);
    }

    public double linearDistanceSquared(PlanetModel planetModel, double x, double y, double z, Membership ... bounds) {
        double linearDistance = this.linearDistance(planetModel, x, y, z, bounds);
        return linearDistance * linearDistance;
    }

    public GeoPoint[] interpolate(GeoPoint start, GeoPoint end, double[] proportions) {
        double delta;
        double newEndAngle;
        double cosHA;
        double sinHA;
        double sinRA;
        double cosRA;
        double A2 = this.x;
        double B = this.y;
        double C2 = this.z;
        double transX = -this.D * A2;
        double transY = -this.D * B;
        double transZ = -this.D * C2;
        double magnitude = this.magnitude();
        if (magnitude >= 1.0E-12) {
            double denom = 1.0 / magnitude;
            A2 *= denom;
            B *= denom;
            C2 *= denom;
            double xyMagnitude = Math.sqrt(A2 * A2 + B * B);
            if (xyMagnitude >= 1.0E-12) {
                double xyDenom = 1.0 / xyMagnitude;
                cosRA = A2 * xyDenom;
                sinRA = -B * xyDenom;
            } else {
                cosRA = 1.0;
                sinRA = 0.0;
            }
            sinHA = xyMagnitude;
            cosHA = C2;
        } else {
            cosRA = 1.0;
            sinRA = 0.0;
            cosHA = 1.0;
            sinHA = 0.0;
        }
        Vector modifiedStart = Plane.modify(start, transX, transY, transZ, sinRA, cosRA, sinHA, cosHA);
        Vector modifiedEnd = Plane.modify(end, transX, transY, transZ, sinRA, cosRA, sinHA, cosHA);
        if (Math.abs(modifiedStart.z) >= 1.0E-12) {
            throw new IllegalArgumentException("Start point was not on plane: " + modifiedStart.z);
        }
        if (Math.abs(modifiedEnd.z) >= 1.0E-12) {
            throw new IllegalArgumentException("End point was not on plane: " + modifiedEnd.z);
        }
        double startAngle = Math.atan2(modifiedStart.y, modifiedStart.x);
        double endAngle = Math.atan2(modifiedEnd.y, modifiedEnd.x);
        double startMagnitude = Math.sqrt(modifiedStart.x * modifiedStart.x + modifiedStart.y * modifiedStart.y);
        for (newEndAngle = endAngle; newEndAngle < startAngle; newEndAngle += Math.PI * 2) {
        }
        if (newEndAngle - startAngle <= Math.PI) {
            delta = newEndAngle - startAngle;
        } else {
            double newStartAngle;
            for (newStartAngle = startAngle; newStartAngle < endAngle; newStartAngle += Math.PI * 2) {
            }
            delta = newStartAngle - endAngle;
        }
        GeoPoint[] returnValues = new GeoPoint[proportions.length];
        for (int i = 0; i < returnValues.length; ++i) {
            double newAngle = startAngle + proportions[i] * delta;
            double sinNewAngle = Math.sin(newAngle);
            double cosNewAngle = Math.cos(newAngle);
            Vector newVector = new Vector(cosNewAngle * startMagnitude, sinNewAngle * startMagnitude, 0.0);
            returnValues[i] = Plane.reverseModify(newVector, transX, transY, transZ, sinRA, cosRA, sinHA, cosHA);
        }
        return returnValues;
    }

    protected static Vector modify(GeoPoint start, double transX, double transY, double transZ, double sinRA, double cosRA, double sinHA, double cosHA) {
        return start.translate(transX, transY, transZ).rotateXY(sinRA, cosRA).rotateXZ(sinHA, cosHA);
    }

    protected static GeoPoint reverseModify(Vector point, double transX, double transY, double transZ, double sinRA, double cosRA, double sinHA, double cosHA) {
        Vector result = point.rotateXZ(-sinHA, cosHA).rotateXY(-sinRA, cosRA).translate(-transX, -transY, -transZ);
        return new GeoPoint(result.x, result.y, result.z);
    }

    public GeoPoint[] findIntersections(PlanetModel planetModel, Plane q, Membership ... bounds) {
        if (this.isNumericallyIdentical(q)) {
            return null;
        }
        return this.findIntersections(planetModel, q, bounds, NO_BOUNDS);
    }

    protected GeoPoint[] findIntersections(PlanetModel planetModel, Plane q, Membership[] bounds, Membership[] moreBounds) {
        double z0;
        double y0;
        double x0;
        double denom;
        Vector lineVector = new Vector(this.y * q.z - this.z * q.y, this.z * q.x - this.x * q.z, this.x * q.y - this.y * q.x);
        if (Math.abs(lineVector.x) < 1.0E-12 && Math.abs(lineVector.y) < 1.0E-12 && Math.abs(lineVector.z) < 1.0E-12) {
            return NO_POINTS;
        }
        double denomYZ = this.y * q.z - this.z * q.y;
        double denomXZ = this.x * q.z - this.z * q.x;
        double denomXY = this.x * q.y - this.y * q.x;
        if (Math.abs(denomYZ) >= Math.abs(denomXZ) && Math.abs(denomYZ) >= Math.abs(denomXY)) {
            if (Math.abs(denomYZ) < 1.0E-24) {
                return NO_POINTS;
            }
            denom = 1.0 / denomYZ;
            x0 = 0.0;
            y0 = (-this.D * q.z - this.z * -q.D) * denom;
            z0 = (this.y * -q.D + this.D * q.y) * denom;
        } else if (Math.abs(denomXZ) >= Math.abs(denomXY) && Math.abs(denomXZ) >= Math.abs(denomYZ)) {
            if (Math.abs(denomXZ) < 1.0E-24) {
                return NO_POINTS;
            }
            denom = 1.0 / denomXZ;
            x0 = (-this.D * q.z - this.z * -q.D) * denom;
            y0 = 0.0;
            z0 = (this.x * -q.D + this.D * q.x) * denom;
        } else {
            if (Math.abs(denomXY) < 1.0E-24) {
                return NO_POINTS;
            }
            denom = 1.0 / denomXY;
            x0 = (-this.D * q.y - this.y * -q.D) * denom;
            y0 = (this.x * -q.D + this.D * q.x) * denom;
            z0 = 0.0;
        }
        double A2 = lineVector.x * lineVector.x * planetModel.inverseAbSquared + lineVector.y * lineVector.y * planetModel.inverseAbSquared + lineVector.z * lineVector.z * planetModel.inverseCSquared;
        double B = 2.0 * (lineVector.x * x0 * planetModel.inverseAbSquared + lineVector.y * y0 * planetModel.inverseAbSquared + lineVector.z * z0 * planetModel.inverseCSquared);
        double C2 = x0 * x0 * planetModel.inverseAbSquared + y0 * y0 * planetModel.inverseAbSquared + z0 * z0 * planetModel.inverseCSquared - 1.0;
        double BsquaredMinus = B * B - 4.0 * A2 * C2;
        if (Math.abs(BsquaredMinus) < 1.0E-24) {
            double inverse2A = 1.0 / (2.0 * A2);
            double t = -B * inverse2A;
            GeoPoint point = new GeoPoint(lineVector.x * t + x0, lineVector.y * t + y0, lineVector.z * t + z0);
            if (point.isWithin(bounds, moreBounds)) {
                return new GeoPoint[]{point};
            }
            return NO_POINTS;
        }
        if (BsquaredMinus > 0.0) {
            double inverse2A = 1.0 / (2.0 * A2);
            double sqrtTerm = Math.sqrt(BsquaredMinus);
            double t1 = (-B + sqrtTerm) * inverse2A;
            double t2 = (-B - sqrtTerm) * inverse2A;
            GeoPoint point1 = new GeoPoint(lineVector.x * t1 + x0, lineVector.y * t1 + y0, lineVector.z * t1 + z0);
            GeoPoint point2 = new GeoPoint(lineVector.x * t2 + x0, lineVector.y * t2 + y0, lineVector.z * t2 + z0);
            if (point1.isWithin(bounds, moreBounds)) {
                if (point2.isWithin(bounds, moreBounds)) {
                    return new GeoPoint[]{point1, point2};
                }
                return new GeoPoint[]{point1};
            }
            if (point2.isWithin(bounds, moreBounds)) {
                return new GeoPoint[]{point2};
            }
            return NO_POINTS;
        }
        return NO_POINTS;
    }

    public void recordBounds(PlanetModel planetModel, XYZBounds boundsInfo, Membership ... bounds) {
        double denom0;
        double l;
        double m3;
        GeoPoint thePoint2;
        GeoPoint thePoint1;
        double denom2;
        double denom1;
        double l2;
        double l1;
        double commonDenom;
        double sqrtResult;
        GeoPoint thePoint;
        double l3;
        double m4;
        double sqrtTerm;
        double c;
        double b;
        double a;
        double qSquared;
        double q;
        double A2 = this.x;
        double B = this.y;
        double C2 = this.z;
        if (!boundsInfo.isSmallestMinZ(planetModel) || !boundsInfo.isLargestMaxZ(planetModel)) {
            if (Math.abs(A2) >= 1.0E-12 || Math.abs(B) >= 1.0E-12) {
                GeoPoint[] points;
                Plane normalizedZPlane = Plane.constructNormalizedZPlane(A2, B);
                for (GeoPoint point : points = this.findIntersections(planetModel, normalizedZPlane, bounds, NO_BOUNDS)) {
                    assert (planetModel.pointOnSurface(point));
                    Plane.addPoint(boundsInfo, bounds, point);
                }
            } else {
                GeoPoint[] points = this.findIntersections(planetModel, normalYPlane, NO_BOUNDS, NO_BOUNDS);
                boundsInfo.addZValue(points[0]);
            }
        }
        double k = 1.0 / ((this.x * this.x + this.y * this.y) * planetModel.ab * planetModel.ab + this.z * this.z * planetModel.c * planetModel.c);
        double abSquared = planetModel.ab * planetModel.ab;
        double cSquared = planetModel.c * planetModel.c;
        double ASquared = A2 * A2;
        double BSquared = B * B;
        double CSquared = C2 * C2;
        double r = 2.0 * this.D * k;
        double rSquared = r * r;
        if (!boundsInfo.isSmallestMinX(planetModel) || !boundsInfo.isLargestMaxX(planetModel)) {
            q = A2 * abSquared * k;
            qSquared = q * q;
            a = ASquared * abSquared * rSquared + BSquared * abSquared * rSquared + CSquared * cSquared * rSquared - 4.0;
            b = -2.0 * A2 * abSquared * r + 2.0 * ASquared * abSquared * r * q + 2.0 * BSquared * abSquared * r * q + 2.0 * CSquared * cSquared * r * q;
            c = abSquared - 2.0 * A2 * abSquared * q + ASquared * abSquared * qSquared + BSquared * abSquared * qSquared + CSquared * cSquared * qSquared;
            if (Math.abs(a) >= 1.0E-24) {
                sqrtTerm = b * b - 4.0 * a * c;
                if (Math.abs(sqrtTerm) < 1.0E-24) {
                    m4 = -b / (2.0 * a);
                    l3 = r * m4 + q;
                    double denom02 = 0.5 / m4;
                    thePoint = new GeoPoint((1.0 - l3 * A2) * abSquared * denom02, -l3 * B * abSquared * denom02, -l3 * C2 * cSquared * denom02);
                    Plane.addPoint(boundsInfo, bounds, thePoint);
                } else if (sqrtTerm > 0.0) {
                    sqrtResult = Math.sqrt(sqrtTerm);
                    commonDenom = 0.5 / a;
                    double m1 = (-b + sqrtResult) * commonDenom;
                    assert (Math.abs(a * m1 * m1 + b * m1 + c) < 1.0E-12);
                    double m22 = (-b - sqrtResult) * commonDenom;
                    assert (Math.abs(a * m22 * m22 + b * m22 + c) < 1.0E-12);
                    l1 = r * m1 + q;
                    l2 = r * m22 + q;
                    denom1 = 0.5 / m1;
                    denom2 = 0.5 / m22;
                    thePoint1 = new GeoPoint((1.0 - l1 * A2) * abSquared * denom1, -l1 * B * abSquared * denom1, -l1 * C2 * cSquared * denom1);
                    thePoint2 = new GeoPoint((1.0 - l2 * A2) * abSquared * denom2, -l2 * B * abSquared * denom2, -l2 * C2 * cSquared * denom2);
                    Plane.addPoint(boundsInfo, bounds, thePoint1);
                    Plane.addPoint(boundsInfo, bounds, thePoint2);
                }
            } else if (Math.abs(b) > 1.0E-24) {
                m3 = -c / b;
                l = r * m3 + q;
                denom0 = 0.5 / m3;
                GeoPoint thePoint3 = new GeoPoint((1.0 - l * A2) * abSquared * denom0, -l * B * abSquared * denom0, -l * C2 * cSquared * denom0);
                Plane.addPoint(boundsInfo, bounds, thePoint3);
            }
        }
        if (!boundsInfo.isSmallestMinY(planetModel) || !boundsInfo.isLargestMaxY(planetModel)) {
            q = B * abSquared * k;
            qSquared = q * q;
            a = ASquared * abSquared * rSquared + BSquared * abSquared * rSquared + CSquared * cSquared * rSquared - 4.0;
            b = 2.0 * ASquared * abSquared * r * q - 2.0 * B * abSquared * r + 2.0 * BSquared * abSquared * r * q + 2.0 * CSquared * cSquared * r * q;
            c = ASquared * abSquared * qSquared + abSquared - 2.0 * B * abSquared * q + BSquared * abSquared * qSquared + CSquared * cSquared * qSquared;
            if (Math.abs(a) >= 1.0E-24) {
                sqrtTerm = b * b - 4.0 * a * c;
                if (Math.abs(sqrtTerm) < 1.0E-24) {
                    m4 = -b / (2.0 * a);
                    l3 = r * m4 + q;
                    double denom03 = 0.5 / m4;
                    thePoint = new GeoPoint(-l3 * A2 * abSquared * denom03, (1.0 - l3 * B) * abSquared * denom03, -l3 * C2 * cSquared * denom03);
                    Plane.addPoint(boundsInfo, bounds, thePoint);
                } else if (sqrtTerm > 0.0) {
                    sqrtResult = Math.sqrt(sqrtTerm);
                    commonDenom = 0.5 / a;
                    double m1 = (-b + sqrtResult) * commonDenom;
                    assert (Math.abs(a * m1 * m1 + b * m1 + c) < 1.0E-12);
                    double m23 = (-b - sqrtResult) * commonDenom;
                    assert (Math.abs(a * m23 * m23 + b * m23 + c) < 1.0E-12);
                    l1 = r * m1 + q;
                    l2 = r * m23 + q;
                    denom1 = 0.5 / m1;
                    denom2 = 0.5 / m23;
                    thePoint1 = new GeoPoint(-l1 * A2 * abSquared * denom1, (1.0 - l1 * B) * abSquared * denom1, -l1 * C2 * cSquared * denom1);
                    thePoint2 = new GeoPoint(-l2 * A2 * abSquared * denom2, (1.0 - l2 * B) * abSquared * denom2, -l2 * C2 * cSquared * denom2);
                    Plane.addPoint(boundsInfo, bounds, thePoint1);
                    Plane.addPoint(boundsInfo, bounds, thePoint2);
                }
            } else if (Math.abs(b) > 1.0E-24) {
                m3 = -c / b;
                l = r * m3 + q;
                denom0 = 0.5 / m3;
                GeoPoint thePoint4 = new GeoPoint(-l * A2 * abSquared * denom0, (1.0 - l * B) * abSquared * denom0, -l * C2 * cSquared * denom0);
                Plane.addPoint(boundsInfo, bounds, thePoint4);
            }
        }
    }

    public void recordBounds(PlanetModel planetModel, LatLonBounds boundsInfo, Membership ... bounds) {
        double A2 = this.x;
        double B = this.y;
        double C2 = this.z;
        if (!boundsInfo.checkNoTopLatitudeBound() || !boundsInfo.checkNoBottomLatitudeBound()) {
            if (Math.abs(A2) >= 1.0E-12 || Math.abs(B) >= 1.0E-12) {
                GeoPoint[] points;
                Plane verticalPlane = Plane.constructNormalizedZPlane(A2, B);
                for (GeoPoint point : points = this.findIntersections(planetModel, verticalPlane, bounds, NO_BOUNDS)) {
                    Plane.addPoint(boundsInfo, bounds, point);
                }
            } else {
                GeoPoint[] points = this.findIntersections(planetModel, normalXPlane, NO_BOUNDS, NO_BOUNDS);
                boundsInfo.addZValue(points[0]);
            }
        }
        if (!boundsInfo.checkNoLongitudeBound()) {
            if (Math.abs(C2) < 1.0E-12) {
                if (Math.abs(this.D) >= 1.0E-12) {
                    if (Math.abs(A2) > Math.abs(B)) {
                        double b = 2.0 * B * this.D * planetModel.inverseAbSquared;
                        double a = B * B * planetModel.inverseAbSquared + A2 * A2 * planetModel.inverseAbSquared;
                        double c = this.D * this.D * planetModel.inverseAbSquared - A2 * A2;
                        double sqrtClause = b * b - 4.0 * a * c;
                        if (Math.abs(sqrtClause) < 1.0E-24) {
                            double y0 = -b / (2.0 * a);
                            double x0 = (-this.D - B * y0) / A2;
                            double z0 = 0.0;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0, y0, z0));
                        } else if (sqrtClause > 0.0) {
                            double sqrtResult = Math.sqrt(sqrtClause);
                            double denom = 1.0 / (2.0 * a);
                            double Hdenom = 1.0 / A2;
                            double y0a = (-b + sqrtResult) * denom;
                            double y0b = (-b - sqrtResult) * denom;
                            double x0a = (-this.D - B * y0a) * Hdenom;
                            double x0b = (-this.D - B * y0b) * Hdenom;
                            double z0a = 0.0;
                            double z0b = 0.0;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0a, y0a, z0a));
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0b, y0b, z0b));
                        }
                    } else {
                        double b = 2.0 * A2 * this.D * planetModel.inverseAbSquared;
                        double a = B * B * planetModel.inverseAbSquared + A2 * A2 * planetModel.inverseAbSquared;
                        double c = this.D * this.D * planetModel.inverseAbSquared - B * B;
                        double sqrtClause = b * b - 4.0 * a * c;
                        if (Math.abs(sqrtClause) < 1.0E-24) {
                            double x0 = -b / (2.0 * a);
                            double y0 = (-this.D - A2 * x0) / B;
                            double z0 = 0.0;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0, y0, z0));
                        } else if (sqrtClause > 0.0) {
                            double sqrtResult = Math.sqrt(sqrtClause);
                            double denom = 1.0 / (2.0 * a);
                            double Idenom = 1.0 / B;
                            double x0a = (-b + sqrtResult) * denom;
                            double x0b = (-b - sqrtResult) * denom;
                            double y0a = (-this.D - A2 * x0a) * Idenom;
                            double y0b = (-this.D - A2 * x0b) * Idenom;
                            double z0a = 0.0;
                            double z0b = 0.0;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0a, y0a, z0a));
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0b, y0b, z0b));
                        }
                    }
                }
            } else {
                double E = A2 * A2 * planetModel.inverseCSquared + C2 * C2 * planetModel.inverseAbSquared;
                double F = B * B * planetModel.inverseCSquared + C2 * C2 * planetModel.inverseAbSquared;
                double G = 2.0 * A2 * B * planetModel.inverseCSquared;
                double H = 2.0 * A2 * this.D * planetModel.inverseCSquared;
                double I = 2.0 * B * this.D * planetModel.inverseCSquared;
                double J = this.D * this.D * planetModel.inverseCSquared - C2 * C2;
                if (Math.abs(J) >= 1.0E-12 && J > 0.0) {
                    if (Math.abs(H) > Math.abs(I)) {
                        double b = 4.0 * E * I * J - 2.0 * G * H * J;
                        double a = E * I * I - G * H * I + F * H * H;
                        double c = 4.0 * E * J * J - J * H * H;
                        double sqrtClause = b * b - 4.0 * a * c;
                        if (Math.abs(sqrtClause) < 1.0E-36) {
                            double y0 = -b / (2.0 * a);
                            double x0 = (-2.0 * J - I * y0) / H;
                            double z0 = (-A2 * x0 - B * y0 - this.D) / C2;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0, y0, z0));
                        } else if (sqrtClause > 0.0) {
                            double sqrtResult = Math.sqrt(sqrtClause);
                            double denom = 1.0 / (2.0 * a);
                            double Hdenom = 1.0 / H;
                            double Cdenom = 1.0 / C2;
                            double y0a = (-b + sqrtResult) * denom;
                            double y0b = (-b - sqrtResult) * denom;
                            double x0a = (-2.0 * J - I * y0a) * Hdenom;
                            double x0b = (-2.0 * J - I * y0b) * Hdenom;
                            double z0a = (-A2 * x0a - B * y0a - this.D) * Cdenom;
                            double z0b = (-A2 * x0b - B * y0b - this.D) * Cdenom;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0a, y0a, z0a));
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0b, y0b, z0b));
                        }
                    } else {
                        double b = 4.0 * F * H * J - 2.0 * G * I * J;
                        double a = E * I * I - G * H * I + F * H * H;
                        double c = 4.0 * F * J * J - J * I * I;
                        double sqrtClause = b * b - 4.0 * a * c;
                        if (Math.abs(sqrtClause) < 1.0E-36) {
                            double x0 = -b / (2.0 * a);
                            double y0 = (-2.0 * J - H * x0) / I;
                            double z0 = (-A2 * x0 - B * y0 - this.D) / C2;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0, y0, z0));
                        } else if (sqrtClause > 0.0) {
                            double sqrtResult = Math.sqrt(sqrtClause);
                            double denom = 1.0 / (2.0 * a);
                            double Idenom = 1.0 / I;
                            double Cdenom = 1.0 / C2;
                            double x0a = (-b + sqrtResult) * denom;
                            double x0b = (-b - sqrtResult) * denom;
                            double y0a = (-2.0 * J - H * x0a) * Idenom;
                            double y0b = (-2.0 * J - H * x0b) * Idenom;
                            double z0a = (-A2 * x0a - B * y0a - this.D) * Cdenom;
                            double z0b = (-A2 * x0b - B * y0b - this.D) * Cdenom;
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0a, y0a, z0a));
                            Plane.addPoint(boundsInfo, bounds, new GeoPoint(x0b, y0b, z0b));
                        }
                    }
                }
            }
        }
    }

    protected static void addPoint(Bounds boundsInfo, Membership[] bounds, GeoPoint point) {
        for (Membership bound : bounds) {
            if (bound.isWithin(point)) continue;
            return;
        }
        boundsInfo.addPoint(point);
    }

    public boolean intersects(PlanetModel planetModel, Plane q, GeoPoint[] notablePoints, GeoPoint[] moreNotablePoints, Membership[] bounds, Membership ... moreBounds) {
        if (this.isNumericallyIdentical(q)) {
            for (GeoPoint p : notablePoints) {
                if (!Plane.meetsAllBounds(p, bounds, moreBounds)) continue;
                return true;
            }
            for (GeoPoint p : moreNotablePoints) {
                if (!Plane.meetsAllBounds(p, bounds, moreBounds)) continue;
                return true;
            }
            return false;
        }
        return this.findIntersections(planetModel, q, bounds, moreBounds).length > 0;
    }

    protected boolean isNumericallyIdentical(Plane p) {
        if (Math.abs(this.y * p.z - this.z * p.y) >= 1.0E-12) {
            return false;
        }
        if (Math.abs(this.z * p.x - this.x * p.z) >= 1.0E-12) {
            return false;
        }
        if (Math.abs(this.x * p.y - this.y * p.x) >= 1.0E-12) {
            return false;
        }
        double denom = 1.0 / (p.x * p.x + p.y * p.y + p.z * p.z);
        return this.evaluateIsZero(-p.x * p.D * denom, -p.y * p.D * denom, -p.z * p.D * denom);
    }

    protected static boolean meetsAllBounds(Vector p, Membership[] bounds) {
        return Plane.meetsAllBounds(p.x, p.y, p.z, bounds);
    }

    protected static boolean meetsAllBounds(double x, double y, double z, Membership[] bounds) {
        for (Membership bound : bounds) {
            if (bound.isWithin(x, y, z)) continue;
            return false;
        }
        return true;
    }

    protected static boolean meetsAllBounds(Vector p, Membership[] bounds, Membership[] moreBounds) {
        return Plane.meetsAllBounds(p.x, p.y, p.z, bounds, moreBounds);
    }

    protected static boolean meetsAllBounds(double x, double y, double z, Membership[] bounds, Membership[] moreBounds) {
        return Plane.meetsAllBounds(x, y, z, bounds) && Plane.meetsAllBounds(x, y, z, moreBounds);
    }

    public GeoPoint getSampleIntersectionPoint(PlanetModel planetModel, Plane q) {
        GeoPoint[] intersections = this.findIntersections(planetModel, q, NO_BOUNDS, NO_BOUNDS);
        if (intersections.length == 0) {
            return null;
        }
        return intersections[0];
    }

    @Override
    public String toString() {
        return "[A=" + this.x + ", B=" + this.y + "; C=" + this.z + "; D=" + this.D + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof Plane)) {
            return false;
        }
        Plane other = (Plane)o;
        return other.D == this.D;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.D);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

