/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.elasticsearch.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.elasticsearch.common.DefaultEsTupleMapper;
import org.apache.storm.elasticsearch.common.EsConstants;
import org.apache.storm.elasticsearch.common.EsTupleMapper;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.tuple.Values;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public class EsTestUtil {
    public static Tuple generateTestTuple(String source, String index, String type, String id) {
        TopologyBuilder builder = new TopologyBuilder();
        GeneralTopologyContext topologyContext = new GeneralTopologyContext(builder.createTopology(), (Map)new Config(), new HashMap(), new HashMap(), new HashMap(), ""){

            public Fields getComponentOutputFields(String componentId, String streamId) {
                return new Fields(new String[]{"source", "index", "type", "id"});
            }
        };
        return new TupleImpl(topologyContext, (List)new Values(new Object[]{source, index, type, id}), 1, "");
    }

    public static EsTupleMapper generateDefaultTupleMapper() {
        return new DefaultEsTupleMapper();
    }

    public static Node startEsNode() {
        Node node = NodeBuilder.nodeBuilder().data(true).settings(Settings.settingsBuilder().put("cluster.name", EsConstants.clusterName).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("processors", 1).put("http.enabled", true).put("index.percolator.map_unmapped_fields_as_string", true).put("index.store.type", "mmapfs").put("path.home", "./data")).build();
        node.start();
        return node;
    }

    public static void waitForSeconds(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

