/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.rules.refactor.impl;

import com.hp.hpl.jena.sparql.function.FunctionRegistry;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionRegistry;
import java.io.IOException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.clerezza.rdf.core.access.WeightedTcProvider;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.core.sparql.query.ConstructQuery;
import org.apache.stanbol.rules.base.api.Adaptable;
import org.apache.stanbol.rules.base.api.NoSuchRecipeException;
import org.apache.stanbol.rules.base.api.Recipe;
import org.apache.stanbol.rules.base.api.RecipeConstructionException;
import org.apache.stanbol.rules.base.api.RuleAdapter;
import org.apache.stanbol.rules.base.api.RuleAdapterManager;
import org.apache.stanbol.rules.base.api.RuleAtomCallExeption;
import org.apache.stanbol.rules.base.api.RuleStore;
import org.apache.stanbol.rules.base.api.UnavailableRuleObjectException;
import org.apache.stanbol.rules.base.api.UnsupportedTypeForExportException;
import org.apache.stanbol.rules.manager.arqextention.CreatePropertyURIStringFromLabel;
import org.apache.stanbol.rules.manager.arqextention.CreateStandardLabel;
import org.apache.stanbol.rules.manager.arqextention.CreateURI;
import org.apache.stanbol.rules.refactor.api.Refactorer;
import org.apache.stanbol.rules.refactor.api.RefactoringException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefactorerImpl
implements Refactorer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected RuleStore ruleStore;
    protected TcManager tcManager;
    protected WeightedTcProvider weightedTcProvider;
    protected RuleAdapterManager ruleAdapterManager;

    public RefactorerImpl() {
    }

    public RefactorerImpl(WeightedTcProvider weightedTcProvider, TcManager tcManager, RuleStore ruleStore, RuleAdapterManager ruleAdapterManager, Dictionary<String, Object> configuration) {
        this();
        this.weightedTcProvider = weightedTcProvider;
        this.tcManager = tcManager;
        this.ruleStore = ruleStore;
        this.ruleAdapterManager = ruleAdapterManager;
        this.activate(configuration);
    }

    protected void activate(ComponentContext context) throws IOException {
        this.log.info("in " + this.getClass() + " activate with context " + context);
        if (context == null) {
            throw new IllegalStateException("No valid" + ComponentContext.class + " parsed in activate!");
        }
        this.activate(context.getProperties());
    }

    protected void activate(Dictionary<String, Object> configuration) {
        PropertyFunctionRegistry.get().put("http://www.stlab.istc.cnr.it/semion/function#createURI", CreateURI.class);
        FunctionRegistry.get().put("http://www.stlab.istc.cnr.it/semion/function#createLabel", CreateStandardLabel.class);
        FunctionRegistry.get().put("http://www.stlab.istc.cnr.it/semion/function#propString", CreatePropertyURIStringFromLabel.class);
        this.log.debug(Refactorer.class + "activated.");
    }

    protected void deactivate(ComponentContext context) {
        this.log.info("in " + this.getClass() + " deactivate with context " + context);
        this.weightedTcProvider = null;
        this.tcManager = null;
        this.ruleStore = null;
    }

    @Override
    public MGraph getRefactoredDataSet(UriRef uriRef) {
        return this.weightedTcProvider.getMGraph(uriRef);
    }

    private Graph sparqlConstruct(ConstructQuery constructQuery, UriRef datasetID) {
        MGraph graph = this.weightedTcProvider.getMGraph(datasetID);
        return this.sparqlConstruct(constructQuery, (TripleCollection)graph);
    }

    private Graph sparqlConstruct(ConstructQuery constructQuery, TripleCollection tripleCollection) {
        return this.tcManager.executeSparqlQuery(constructQuery, tripleCollection);
    }

    @Override
    public void graphRefactoring(UriRef refactoredOntologyID, UriRef datasetID, UriRef recipeID) throws RefactoringException, NoSuchRecipeException {
        try {
            try {
                Recipe recipe = this.ruleStore.getRecipe(recipeID);
                RuleAdapter ruleAdapter = this.ruleAdapterManager.getAdapter((Adaptable)recipe, ConstructQuery.class);
                List constructQueries = (List)ruleAdapter.adaptTo((Adaptable)recipe, ConstructQuery.class);
                LockableMGraph mGraph = this.tcManager.createMGraph(refactoredOntologyID);
                for (ConstructQuery constructQuery : constructQueries) {
                    mGraph.addAll((Collection)this.sparqlConstruct(constructQuery, datasetID));
                }
            }
            catch (RecipeConstructionException e) {
                throw new RefactoringException("The cause of the refactoring excpetion is: " + e.getMessage(), e);
            }
            catch (UnavailableRuleObjectException e) {
                throw new RefactoringException("The cause of the refactoring excpetion is: " + e.getMessage(), e);
            }
            catch (UnsupportedTypeForExportException e) {
                throw new RefactoringException("The cause of the refactoring excpetion is: " + e.getMessage(), e);
            }
            catch (RuleAtomCallExeption e) {
                throw new RefactoringException("The cause of the refactoring excpetion is: " + e.getMessage(), e);
            }
        }
        catch (NoSuchRecipeException e1) {
            this.log.error("No Such recipe in the Rule Store", (Throwable)e1);
            throw e1;
        }
    }

    @Override
    public TripleCollection graphRefactoring(UriRef graphID, UriRef recipeID) throws RefactoringException, NoSuchRecipeException {
        SimpleMGraph unionMGraph = null;
        try {
            Recipe recipe = this.ruleStore.getRecipe(recipeID);
            RuleAdapter ruleAdapter = this.ruleAdapterManager.getAdapter((Adaptable)recipe, ConstructQuery.class);
            List constructQueries = (List)ruleAdapter.adaptTo((Adaptable)recipe, ConstructQuery.class);
            unionMGraph = new SimpleMGraph();
            for (ConstructQuery constructQuery : constructQueries) {
                unionMGraph.addAll((Collection)this.sparqlConstruct(constructQuery, graphID));
            }
        }
        catch (NoSuchRecipeException e1) {
            this.log.error("Refactor : No Such recipe in the Rule Store", (Throwable)e1);
            throw e1;
        }
        catch (RecipeConstructionException e) {
            throw new RefactoringException("The cause of the refactoring excpetion is: " + e.getMessage(), e);
        }
        catch (UnavailableRuleObjectException e) {
            throw new RefactoringException("The cause of the refactoring excpetion is: " + e.getMessage(), e);
        }
        catch (UnsupportedTypeForExportException e) {
            throw new RefactoringException("The cause of the refactoring excpetion is: " + e.getMessage(), e);
        }
        catch (RuleAtomCallExeption e) {
            throw new RefactoringException("The cause of the refactoring excpetion is: " + e.getMessage(), e);
        }
        return unionMGraph.getGraph();
    }

    @Override
    public TripleCollection graphRefactoring(TripleCollection inputGraph, Recipe recipe) throws RefactoringException {
        try {
            RuleAdapter ruleAdapter = this.ruleAdapterManager.getAdapter((Adaptable)recipe, ConstructQuery.class);
            List constructQueries = (List)ruleAdapter.adaptTo((Adaptable)recipe, ConstructQuery.class);
            for (ConstructQuery constructQuery : constructQueries) {
                System.out.println(constructQuery.toString());
            }
            SimpleMGraph unionMGraph = new SimpleMGraph();
            for (ConstructQuery constructQuery : constructQueries) {
                unionMGraph.addAll((Collection)this.sparqlConstruct(constructQuery, inputGraph));
            }
            return unionMGraph;
        }
        catch (UnavailableRuleObjectException e) {
            throw new RefactoringException("The cause of the refactoring excpetion is: " + e.getMessage(), e);
        }
        catch (UnsupportedTypeForExportException e) {
            throw new RefactoringException("The cause of the refactoring excpetion is: " + e.getMessage(), e);
        }
        catch (RuleAtomCallExeption e) {
            throw new RefactoringException("The cause of the refactoring excpetion is: " + e.getMessage(), e);
        }
    }

    protected void bindRuleStore(RuleStore ruleStore) {
        this.ruleStore = ruleStore;
    }

    protected void unbindRuleStore(RuleStore ruleStore) {
        if (this.ruleStore == ruleStore) {
            this.ruleStore = null;
        }
    }

    protected void bindTcManager(TcManager tcManager) {
        this.tcManager = tcManager;
    }

    protected void unbindTcManager(TcManager tcManager) {
        if (this.tcManager == tcManager) {
            this.tcManager = null;
        }
    }

    protected void bindWeightedTcProvider(WeightedTcProvider weightedTcProvider) {
        this.weightedTcProvider = weightedTcProvider;
    }

    protected void unbindWeightedTcProvider(WeightedTcProvider weightedTcProvider) {
        if (this.weightedTcProvider == weightedTcProvider) {
            this.weightedTcProvider = null;
        }
    }

    protected void bindRuleAdapterManager(RuleAdapterManager ruleAdapterManager) {
        this.ruleAdapterManager = ruleAdapterManager;
    }

    protected void unbindRuleAdapterManager(RuleAdapterManager ruleAdapterManager) {
        if (this.ruleAdapterManager == ruleAdapterManager) {
            this.ruleAdapterManager = null;
        }
    }
}

