/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.model.sesame;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.apache.stanbol.entityhub.model.sesame.RdfValueFactory;
import org.apache.stanbol.entityhub.servicesapi.model.Reference;
import org.apache.stanbol.entityhub.servicesapi.model.Text;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.XMLSchema;

class ValueTypeFilter<T>
implements Predicate {
    private boolean referenceState;
    private boolean plainLiteralState;
    private Set<URI> xmlTypes;
    private Set<String> languages;
    private Class<? extends Value> sesameType;

    public ValueTypeFilter(String ... languages) {
        if (languages == null || languages.length < 1) {
            this.languages = null;
        } else if (languages.length == 1) {
            String language = languages[0];
            if (language != null) {
                language = language.toLowerCase(Locale.ROOT);
            }
            this.languages = Collections.singleton(language);
        } else {
            this.languages = new HashSet<String>();
            for (String language : languages) {
                if (language != null) {
                    language = language.toLowerCase(Locale.ROOT);
                }
                this.languages.add(language);
            }
        }
        this.plainLiteralState = true;
    }

    public ValueTypeFilter(Class<T> type) {
        if (type.equals(Text.class)) {
            this.plainLiteralState = true;
        } else if (type.equals(Reference.class)) {
            this.referenceState = true;
        } else if (Value.class.isAssignableFrom(type)) {
            this.sesameType = type.asSubclass(Value.class);
        } else {
            this.xmlTypes = RdfValueFactory.JAVA_TO_XML_DATATYPE_MAPPINGS.get(type);
        }
    }

    public boolean evaluate(Object object) {
        if (object == null) {
            return false;
        }
        if (this.sesameType != null) {
            return this.sesameType.isAssignableFrom(object.getClass());
        }
        if (this.referenceState && object instanceof URI) {
            return true;
        }
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            if (this.plainLiteralState && (literal.getDatatype() == null || XMLSchema.STRING.equals((Object)literal.getDatatype())) && (this.languages == null || this.languages.contains(literal.getLanguage()))) {
                return true;
            }
            if (!this.plainLiteralState && this.xmlTypes != null && literal.getDatatype() != null) {
                return this.xmlTypes.contains(literal.getDatatype());
            }
            return false;
        }
        return false;
    }
}

