/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.model.sesame;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.stanbol.entityhub.model.sesame.RdfReference;
import org.apache.stanbol.entityhub.model.sesame.RdfRepresentation;
import org.apache.stanbol.entityhub.model.sesame.RdfText;
import org.apache.stanbol.entityhub.servicesapi.model.Reference;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.Text;
import org.apache.stanbol.entityhub.servicesapi.model.UnsupportedTypeException;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.TreeModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfValueFactory
implements org.apache.stanbol.entityhub.servicesapi.model.ValueFactory {
    protected final Logger log = LoggerFactory.getLogger(RdfValueFactory.class);
    static final Map<Object, Set<URI>> JAVA_TO_XML_DATATYPE_MAPPINGS;
    private static RdfValueFactory singleton;
    protected final ValueFactory sesameFactory;
    private Model model;

    public RdfValueFactory(Model model, ValueFactory sesameFactory) {
        this.model = model;
        this.sesameFactory = sesameFactory == null ? ValueFactoryImpl.getInstance() : sesameFactory;
    }

    private RdfValueFactory(ValueFactory sesameFactory) {
        this(null, sesameFactory);
    }

    private RdfValueFactory() {
        this(null);
    }

    public static RdfValueFactory getInstance() {
        if (singleton == null) {
            singleton = new RdfValueFactory();
        }
        return singleton;
    }

    public Reference createReference(Object value) throws UnsupportedTypeException, IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("The parsed value MUST NOT be NULL");
        }
        if (value instanceof URI) {
            return new RdfReference((URI)value);
        }
        return new RdfReference(this.sesameFactory.createURI(value.toString()));
    }

    public Representation createRepresentation(String id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("The parsed id MUST NOT be NULL!");
        }
        if (id.isEmpty()) {
            throw new IllegalArgumentException("The parsed id MUST NOT be empty!");
        }
        return this.createRdfRepresentation(this.sesameFactory.createURI(id));
    }

    public RdfRepresentation createRdfRepresentation(URI subject) {
        TreeModel model = this.model == null ? new TreeModel() : this.model;
        return new RdfRepresentation(subject, (Model)model, this);
    }

    public Text createText(Object value) throws UnsupportedTypeException, IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("The parsed value MUST NOT be NULL");
        }
        if (value instanceof Literal) {
            return new RdfText((Literal)value);
        }
        return this.createText(value.toString(), null);
    }

    public Text createText(String text, String language) throws IllegalArgumentException {
        if (text == null) {
            throw new IllegalArgumentException("The parsed text MUST NOT be NULL");
        }
        if (text.isEmpty()) {
            throw new IllegalArgumentException("Tha parsed Text MUST NOT be empty!");
        }
        if (language != null && language.isEmpty()) {
            language = null;
        }
        return new RdfText(this.sesameFactory.createLiteral(text, language));
    }

    public ValueFactory getSesameFactory() {
        return this.sesameFactory;
    }

    public RdfRepresentation toRdfRepresentation(Representation representation) {
        if (representation instanceof RdfRepresentation) {
            return (RdfRepresentation)representation;
        }
        if (representation != null) {
            RdfRepresentation rdfRep = this.createRdfRepresentation(this.sesameFactory.createURI(representation.getId()));
            Iterator fields = representation.getFieldNames();
            while (fields.hasNext()) {
                String field = (String)fields.next();
                Iterator fieldValues = representation.get(field);
                while (fieldValues.hasNext()) {
                    rdfRep.add(field, fieldValues.next());
                }
            }
            return rdfRep;
        }
        return null;
    }

    static {
        HashMap<Class<String>, Set<URI>> mappings = new HashMap<Class<String>, Set<URI>>();
        mappings.put(Boolean.class, Collections.singleton(XMLSchema.BOOLEAN));
        mappings.put(Byte.class, Collections.singleton(XMLSchema.BYTE));
        mappings.put(Short.class, new HashSet<URI>(Arrays.asList(XMLSchema.SHORT, XMLSchema.UNSIGNED_BYTE)));
        mappings.put(Integer.class, new HashSet<URI>(Arrays.asList(XMLSchema.INT, XMLSchema.UNSIGNED_SHORT)));
        mappings.put(Long.class, new HashSet<URI>(Arrays.asList(XMLSchema.LONG, XMLSchema.UNSIGNED_INT, XMLSchema.NEGATIVE_INTEGER, XMLSchema.POSITIVE_INTEGER, XMLSchema.NON_NEGATIVE_INTEGER, XMLSchema.NON_POSITIVE_INTEGER)));
        mappings.put(BigDecimal.class, new HashSet<URI>(Arrays.asList(XMLSchema.INTEGER, XMLSchema.UNSIGNED_LONG)));
        mappings.put(Float.class, Collections.singleton(XMLSchema.FLOAT));
        mappings.put(Double.class, Collections.singleton(XMLSchema.DOUBLE));
        mappings.put(BigDecimal.class, Collections.singleton(XMLSchema.DECIMAL));
        mappings.put(Date.class, new HashSet<URI>(Arrays.asList(XMLSchema.DATE, XMLSchema.DATETIME, XMLSchema.TIME, XMLSchema.GYEARMONTH, XMLSchema.GMONTHDAY, XMLSchema.GYEAR, XMLSchema.GMONTH, XMLSchema.GDAY)));
        mappings.put(String.class, Collections.singleton(XMLSchema.STRING));
        JAVA_TO_XML_DATATYPE_MAPPINGS = Collections.unmodifiableMap(mappings);
    }
}

