/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.model.sesame;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.Transformer;
import org.apache.stanbol.entityhub.model.sesame.ModelUtils;
import org.apache.stanbol.entityhub.model.sesame.RdfValueFactory;
import org.apache.stanbol.entityhub.model.sesame.RdfWrapper;
import org.apache.stanbol.entityhub.model.sesame.ValueTypeFilter;
import org.apache.stanbol.entityhub.servicesapi.defaults.DataTypeEnum;
import org.apache.stanbol.entityhub.servicesapi.model.Reference;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.Text;
import org.apache.stanbol.entityhub.servicesapi.model.UnsupportedTypeException;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfRepresentation
implements Representation,
RdfWrapper {
    private Logger log = LoggerFactory.getLogger(RdfRepresentation.class);
    private URI subject;
    private final Model model;
    private final RdfValueFactory factory;
    private final ValueFactory sesameFactory;
    protected Transformer objectTransFormer = new Transformer(){

        public Value transform(Object input) {
            return ((Statement)input).getObject();
        }
    };

    protected RdfRepresentation(URI subject, Model model, RdfValueFactory factory) {
        this.subject = subject;
        this.model = model;
        this.factory = factory;
        this.sesameFactory = factory.getSesameFactory();
    }

    public void add(String field, Object value) throws IllegalArgumentException {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("NULL values are not supported by Representations");
        }
        URI property = this.sesameFactory.createURI(field);
        ArrayList values = new ArrayList();
        org.apache.stanbol.entityhub.servicesapi.util.ModelUtils.checkValues((org.apache.stanbol.entityhub.servicesapi.model.ValueFactory)this.factory, (Object)value, values);
        for (Object current : values) {
            if (current instanceof Value) {
                this.addValue(property, (Value)current);
                continue;
            }
            if (current instanceof RdfWrapper) {
                this.addValue(property, ((RdfWrapper)current).getValue());
                continue;
            }
            if (current instanceof Reference) {
                this.addValue(property, (Value)this.sesameFactory.createURI(((Reference)current).getReference()));
                continue;
            }
            if (current instanceof Text) {
                this.addValue(property, (Value)this.sesameFactory.createLiteral(((Text)current).getText(), ((Text)current).getLanguage()));
                continue;
            }
            this.addValue(property, (Value)this.createTypedLiteral(current));
        }
    }

    private Literal createTypedLiteral(Object value) {
        Object literal;
        if (value instanceof Number) {
            Number n = (Number)value;
            literal = value instanceof Integer ? this.sesameFactory.createLiteral(n.intValue()) : (value instanceof Float ? this.sesameFactory.createLiteral(n.floatValue()) : (value instanceof Long ? this.sesameFactory.createLiteral(n.longValue()) : (value instanceof Double ? this.sesameFactory.createLiteral(n.doubleValue()) : (value instanceof Short ? this.sesameFactory.createLiteral(n.shortValue()) : (value instanceof Byte ? this.sesameFactory.createLiteral(n.byteValue()) : null)))));
        } else {
            literal = value instanceof Boolean ? this.sesameFactory.createLiteral(((Boolean)value).booleanValue()) : (value instanceof Date ? this.sesameFactory.createLiteral((Date)value) : (value instanceof BigInteger ? this.sesameFactory.createLiteral(value.toString(), DataTypeEnum.Integer.getUri()) : (value instanceof BigDecimal ? this.sesameFactory.createLiteral(value.toString(), DataTypeEnum.Decimal.getUri()) : (value instanceof XMLGregorianCalendar ? this.sesameFactory.createLiteral((XMLGregorianCalendar)value) : (value instanceof Duration ? this.sesameFactory.createLiteral(value.toString(), XMLSchema.DURATION) : (value instanceof String ? this.sesameFactory.createLiteral(value.toString(), XMLSchema.STRING) : null))))));
        }
        if (literal == null) {
            throw new IllegalArgumentException("Unable to convert value '" + value + "' to a Sesame typed literal because the java type " + value.getClass().getName() + " can not be mapped to an " + "XML DataType.");
        }
        return literal;
    }

    public void addNaturalText(String field, String text, String ... languages) throws IllegalArgumentException {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        if (text == null) {
            throw new IllegalArgumentException("NULL values are not supported by Representations");
        }
        URI property = this.sesameFactory.createURI(field);
        if (languages == null || languages.length == 0) {
            languages = new String[]{null};
        }
        for (String language : languages) {
            Literal value = this.sesameFactory.createLiteral(text, language);
            this.addValue(property, (Value)value);
        }
    }

    public void addReference(String field, String reference) throws IllegalArgumentException {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        if (reference == null) {
            throw new IllegalArgumentException("NULL values are not supported by Representations");
        }
        if (reference.isEmpty()) {
            throw new IllegalArgumentException("References MUST NOT be empty!");
        }
        this.addValue(this.sesameFactory.createURI(field), (Value)this.sesameFactory.createURI(reference));
    }

    private void addValue(URI property, Value value) {
        this.model.add((Resource)this.subject, property, value, new Resource[0]);
    }

    public Iterator<Object> get(String field) throws IllegalArgumentException {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        URI property = this.sesameFactory.createURI(field);
        return IteratorUtils.transformedIterator((Iterator)IteratorUtils.filteredIterator((Iterator)IteratorUtils.transformedIterator((Iterator)this.model.filter((Resource)this.subject, property, null, new Resource[0]).iterator(), (Transformer)this.objectTransFormer), (Predicate)PredicateUtils.notPredicate((Predicate)PredicateUtils.instanceofPredicate(BNode.class))), (Transformer)ModelUtils.VALUE_TRANSFORMER);
    }

    public <T> Iterator<T> get(String field, Class<T> type) throws UnsupportedTypeException {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        URI property = this.sesameFactory.createURI(field);
        Iterator iterator = IteratorUtils.filteredIterator((Iterator)IteratorUtils.transformedIterator((Iterator)this.model.filter((Resource)this.subject, property, null, new Resource[0]).iterator(), (Transformer)this.objectTransFormer), new ValueTypeFilter<T>(type));
        if (!Value.class.isAssignableFrom(type)) {
            iterator = IteratorUtils.transformedIterator((Iterator)iterator, (Transformer)ModelUtils.VALUE_TRANSFORMER);
        }
        return iterator;
    }

    public Iterator<Text> get(String field, String ... languages) {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        URI property = this.sesameFactory.createURI(field);
        return IteratorUtils.transformedIterator((Iterator)IteratorUtils.transformedIterator((Iterator)IteratorUtils.filteredIterator((Iterator)IteratorUtils.transformedIterator((Iterator)this.model.filter((Resource)this.subject, property, null, new Resource[0]).iterator(), (Transformer)this.objectTransFormer), new ValueTypeFilter(languages)), (Transformer)ModelUtils.STRING_LITERAL_TO_TEXT_TRANSFORMER), (Transformer)ModelUtils.VALUE_TRANSFORMER);
    }

    public Iterator<String> getFieldNames() {
        return IteratorUtils.transformedIterator(this.model.predicates().iterator(), (Transformer)ModelUtils.VALUR_TO_STRING_TRANSFORMER);
    }

    public Object getFirst(String field) {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        Iterator<Object> it = this.get(field);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public <T> T getFirst(String field, Class<T> type) throws UnsupportedTypeException {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        Iterator<T> it = this.get(field, type);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public Text getFirst(String field, String ... languages) {
        Iterator<Text> it;
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        if (languages == null) {
            this.log.debug("NULL parsed as languages -> replacing with \"new String []{null}\" -> assuming a missing explicit cast to (String) in the var arg");
            languages = new String[]{null};
        }
        if ((it = this.get(field, languages)).hasNext()) {
            return it.next();
        }
        return null;
    }

    public Reference getFirstReference(String field) {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        Iterator<Reference> it = this.getReferences(field);
        return it.hasNext() ? it.next() : null;
    }

    public String getId() {
        return this.subject.stringValue();
    }

    public Iterator<Reference> getReferences(String field) {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        URI property = this.sesameFactory.createURI(field);
        return IteratorUtils.transformedIterator((Iterator)IteratorUtils.filteredIterator((Iterator)IteratorUtils.transformedIterator((Iterator)this.model.filter((Resource)this.subject, property, null, new Resource[0]).iterator(), (Transformer)this.objectTransFormer), new ValueTypeFilter<Reference>(Reference.class)), (Transformer)ModelUtils.VALUE_TRANSFORMER);
    }

    public Iterator<Text> getText(String field) {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        URI property = this.sesameFactory.createURI(field);
        return IteratorUtils.transformedIterator((Iterator)IteratorUtils.transformedIterator((Iterator)IteratorUtils.filteredIterator((Iterator)IteratorUtils.transformedIterator((Iterator)this.model.filter((Resource)this.subject, property, null, new Resource[0]).iterator(), (Transformer)this.objectTransFormer), new ValueTypeFilter<Text>(Text.class)), (Transformer)ModelUtils.STRING_LITERAL_TO_TEXT_TRANSFORMER), (Transformer)ModelUtils.VALUE_TRANSFORMER);
    }

    public void remove(String field, Object parsedValue) {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        if (parsedValue == null) {
            this.log.warn("NULL parsed as value in remove method for symbol " + this.getId() + " and field " + field + " -> call ignored");
            return;
        }
        URI property = this.sesameFactory.createURI(field);
        ArrayList values = new ArrayList();
        org.apache.stanbol.entityhub.servicesapi.util.ModelUtils.checkValues((org.apache.stanbol.entityhub.servicesapi.model.ValueFactory)this.factory, (Object)parsedValue, values);
        for (Object value : values) {
            if (value instanceof Value) {
                this.removeValue(property, (Value)value);
                continue;
            }
            if (value instanceof RdfWrapper) {
                this.removeValue(property, ((RdfWrapper)value).getValue());
                continue;
            }
            if (value instanceof Reference) {
                this.removeValue(property, (Value)this.sesameFactory.createURI(((Reference)value).getReference()));
                continue;
            }
            if (value instanceof Text) {
                this.removeValue(property, (Value)this.sesameFactory.createLiteral(((Text)value).getText(), ((Text)value).getLanguage()));
                continue;
            }
            this.removeValue(property, (Value)this.createTypedLiteral(value));
        }
    }

    private boolean removeValue(URI property, Value value) {
        if (value != null) {
            return this.model.remove((Resource)this.subject, property, value, new Resource[0]);
        }
        return false;
    }

    public void removeAll(String field) throws IllegalArgumentException {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        this.model.remove((Resource)this.subject, this.sesameFactory.createURI(field), null, new Resource[0]);
    }

    public void removeAllNaturalText(String field, String ... languages) throws IllegalArgumentException {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        ValueTypeFilter vtf = new ValueTypeFilter(languages);
        Iterator statements = this.model.filter((Resource)this.subject, this.sesameFactory.createURI(field), null, new Resource[0]).iterator();
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            if (!vtf.evaluate(statement.getObject())) continue;
            statements.remove();
        }
    }

    public void removeNaturalText(String field, String value, String ... languages) {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        if (value == null) {
            this.log.warn("NULL parsed as value in remove method for symbol " + this.getId() + " and field " + field + " -> call ignored");
        }
        if (languages == null || languages.length == 0) {
            languages = new String[]{null};
        }
        URI property = this.sesameFactory.createURI(field);
        for (String language : languages) {
            this.removeValue(property, (Value)this.sesameFactory.createLiteral(value, language));
            if (language != null) continue;
            this.removeValue(property, (Value)this.sesameFactory.createLiteral(value, XMLSchema.STRING));
        }
    }

    public void removeReference(String field, String reference) {
        if (field == null) {
            throw new IllegalArgumentException("The parsed field MUST NOT be NULL");
        }
        if (field.isEmpty()) {
            throw new IllegalArgumentException("The parsed field MUST NOT be Empty");
        }
        if (reference == null) {
            this.log.warn("NULL parsed as value in remove method for symbol " + this.getId() + " and field " + field + " -> call ignored");
        } else {
            this.removeValue(this.sesameFactory.createURI(field), (Value)this.sesameFactory.createURI(reference));
        }
    }

    public void set(String field, Object value) throws IllegalArgumentException {
        this.removeAll(field);
        if (value != null) {
            this.add(field, value);
        }
    }

    public void setNaturalText(String field, String text, String ... languages) {
        this.removeAllNaturalText(field, languages);
        if (text != null) {
            this.addNaturalText(field, text, languages);
        }
    }

    public void setReference(String field, String reference) {
        this.removeAll(field);
        if (reference != null) {
            this.addReference(field, reference);
        }
    }

    public Model getModel() {
        return this.model;
    }

    public URI getURI() {
        return this.subject;
    }

    @Override
    public Value getValue() {
        return this.subject;
    }

    public int hashCode() {
        return this.subject.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Representation && this.getId().equals(((Representation)obj).getId());
    }

    public String toString() {
        return this.subject.toString();
    }
}

