/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.NoConvertorException;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.stanbol.enhancer.servicesapi.helper.Rdf;
import org.apache.stanbol.enhancer.servicesapi.helper.RdfEntity;
import org.apache.stanbol.enhancer.servicesapi.helper.impl.SimpleRdfEntityFactory;
import org.apache.stanbol.enhancer.servicesapi.rdf.Properties;

public class RdfProxyInvocationHandler
implements InvocationHandler {
    protected static final Method getIDMethod;
    protected static final Method toString;
    protected static final Method equals;
    protected static final Method hashCode;
    protected SimpleRdfEntityFactory factory;
    protected LiteralFactory literalFactory;
    protected NonLiteral rdfNode;
    private final Set<Class<?>> interfaces;

    public RdfProxyInvocationHandler(SimpleRdfEntityFactory factory, NonLiteral rdfNode, Class<?>[] parsedInterfaces, LiteralFactory literalFactory) {
        this.rdfNode = rdfNode;
        this.factory = factory;
        this.literalFactory = literalFactory;
        Collection<UriRef> nodeTypes = this.getValues(Properties.RDF_TYPE, UriRef.class);
        HashSet interfaceSet = new HashSet();
        for (Class<?> clazz : parsedInterfaces) {
            if (!clazz.isInterface()) {
                throw new IllegalStateException("Parsed Class " + clazz + " is not an interface!");
            }
            interfaceSet.add(clazz);
            RdfProxyInvocationHandler.getSuperInterfaces(clazz, interfaceSet);
        }
        this.interfaces = Collections.unmodifiableSet(interfaceSet);
        for (Class<?> clazz : this.interfaces) {
            UriRef typeRef;
            Rdf classAnnotation = clazz.getAnnotation(Rdf.class);
            if (classAnnotation == null || nodeTypes.contains(typeRef = new UriRef(classAnnotation.id()))) continue;
            this.addValue(Properties.RDF_TYPE, typeRef);
        }
    }

    private static void getSuperInterfaces(Class<?> interfaze, Collection<Class<?>> interfaces) {
        for (Class<?> superInterface : interfaze.getInterfaces()) {
            if (superInterface == null) continue;
            interfaces.add(superInterface);
            RdfProxyInvocationHandler.getSuperInterfaces(superInterface, interfaces);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!(proxy instanceof RdfEntity)) {
            throw new IllegalArgumentException("Parsed proxy instance is not of type " + RdfEntity.class + ". This RdfWrapperInvocationHandler implementations only work for proxies implementing this interface!");
        }
        if (method.equals(getIDMethod)) {
            return this.rdfNode;
        }
        if (method.equals(equals)) {
            return args[0] != null && args[0] instanceof RdfEntity && ((RdfEntity)args[0]).getId().equals(this.rdfNode);
        }
        if (method.equals(hashCode)) {
            return this.rdfNode.toString().hashCode();
        }
        if (method.equals(toString)) {
            return "Proxy for Node " + this.rdfNode + " and interfaces " + this.interfaces;
        }
        Rdf rdf = method.getAnnotation(Rdf.class);
        if (rdf == null) {
            throw new IllegalStateException("Invoked Method does not have an Rdf annotation!");
        }
        if (!rdf.id().startsWith("http://") && !rdf.id().startsWith("urn:")) {
            throw new IllegalStateException("The id=\"" + rdf.id() + "\"provided by the rdf annotation is not an valid URI");
        }
        UriRef property = new UriRef(rdf.id());
        if (method.getReturnType().equals(Void.TYPE)) {
            Type[] parameterTypes = method.getGenericParameterTypes();
            if (parameterTypes.length != 1) {
                throw new IllegalStateException("Unsupported parameters for Method " + method.toString() + "! Only setter methodes with a singe parameter are supported.");
            }
            Type parameterType = parameterTypes[0];
            if (args == null) {
                throw new IllegalArgumentException("NULL parsed as \"Object[] args\". An array with a single value is expected when calling " + method.toString() + "!");
            }
            if (args.length < 1) {
                throw new IllegalArgumentException("An empty array was parsed as \"Object[] args\". An array with a single value is expected when calling method " + method.toString() + "!");
            }
            Object value = args[0];
            if (parameterType instanceof Class && ((Class)parameterType).isArray()) {
                throw new IllegalStateException("No support for Arrays right now. Use " + Collection.class + " instead");
            }
            if (value == null) {
                this.removeValues(property);
                return null;
            }
            if (Collection.class.isAssignableFrom(value.getClass())) {
                Type genericType = null;
                if (parameterTypes[0] instanceof ParameterizedType) {
                    for (Type typeArgument : ((ParameterizedType)parameterTypes[0]).getActualTypeArguments()) {
                        if (genericType != null) {
                            throw new IllegalStateException("Multiple generic type definition for method " + method.toString() + " (generic types: " + ((ParameterizedType)parameterTypes[0]).getActualTypeArguments() + ")");
                        }
                        genericType = typeArgument;
                    }
                }
                this.setValues(property, (Collection)value);
                return null;
            }
            this.setValue(property, value);
            return null;
        }
        Class<?> returnType = method.getReturnType();
        if (Collection.class.isAssignableFrom(returnType)) {
            Type genericType = null;
            Type genericReturnType = method.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType) {
                ParameterizedType type = (ParameterizedType)genericReturnType;
                for (Type typeArgument : type.getActualTypeArguments()) {
                    if (genericType != null) {
                        throw new IllegalStateException("Multiple generic type definition for method " + method.toString() + " (generic types: " + type.getActualTypeArguments() + ")");
                    }
                    genericType = typeArgument;
                }
            }
            if (genericType == null) {
                throw new IllegalStateException("Generic Type not defined for Collection in Method " + method.toString() + " (generic type is needed to correctly map rdf values for property " + property);
            }
            return this.getValues(property, (Class)genericType);
        }
        return this.getValue(property, returnType);
    }

    private <T> T getValue(UriRef property, Class<T> type) {
        Iterator results = this.factory.getGraph().filter(this.rdfNode, property, null);
        if (results.hasNext()) {
            Resource result = ((Triple)results.next()).getObject();
            if (result instanceof NonLiteral) {
                if (RdfEntity.class.isAssignableFrom(type)) {
                    return this.factory.getProxy((NonLiteral)result, type, new Class[0]);
                }
                if (result instanceof UriRef) {
                    if (UriRef.class.isAssignableFrom(type)) {
                        return (T)result;
                    }
                    if (URI.class.isAssignableFrom(type)) {
                        try {
                            return (T)new URI(((UriRef)result).getUnicodeString());
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalStateException("Unable to parse " + URI.class + " for " + UriRef.class + " value=" + ((UriRef)result).getUnicodeString());
                        }
                    }
                    if (URL.class.isAssignableFrom(type)) {
                        try {
                            return (T)new URL(((UriRef)result).getUnicodeString());
                        }
                        catch (MalformedURLException e) {
                            throw new IllegalStateException("Unable to parse " + URL.class + " for " + UriRef.class + " value=" + ((UriRef)result).getUnicodeString());
                        }
                    }
                    throw new IllegalArgumentException("Parsed Type " + type + " is not compatible for result type " + result.getClass() + " (value " + result + ") of node " + this.rdfNode + " and property " + property + "! (Subclass of RdfEntity, UriRef, URI or URL is expected for NonLiteral Values)");
                }
                throw new IllegalArgumentException("Parsed Type " + type + " is not compatible for result type " + result.getClass() + " (value " + result + ") of node " + this.rdfNode + " and property " + property + "! (Subclass of RdfEntity expected as type for NonLiteral values that are no instanceof UriRef)");
            }
            return (T)this.literalFactory.createObject(type, (TypedLiteral)result);
        }
        return null;
    }

    private <T> Collection<T> getValues(UriRef property, Class<T> type) {
        return new RdfProxyPropertyCollection(property, type);
    }

    private void setValue(UriRef property, Object value) {
        this.removeValues(property);
        this.addValue(property, value);
    }

    private void setValues(UriRef property, Collection<?> values) {
        this.removeValues(property);
        for (Object value : values) {
            this.addValue(property, value);
        }
    }

    protected Resource getRdfResource(Object value) throws NoConvertorException {
        if (value instanceof Resource) {
            return (Resource)value;
        }
        if (value instanceof RdfEntity) {
            return ((RdfEntity)value).getId();
        }
        if (value instanceof URI) {
            return new UriRef(value.toString());
        }
        if (value instanceof URL) {
            return new UriRef(value.toString());
        }
        return this.literalFactory.createTypedLiteral(value);
    }

    private boolean addValue(UriRef property, Object value) {
        try {
            Resource rdfValue = this.getRdfResource(value);
            return this.factory.getGraph().add((Object)new TripleImpl(this.rdfNode, property, rdfValue));
        }
        catch (NoConvertorException e) {
            throw new IllegalArgumentException("Unable to transform " + value.getClass() + " to an RDF Node. Only " + RdfEntity.class + " and RDF Literal Types are supported");
        }
    }

    private boolean removeValue(UriRef property, Object value) {
        try {
            Resource rdfValue = this.getRdfResource(value);
            return this.factory.getGraph().remove((Object)new TripleImpl(this.rdfNode, property, rdfValue));
        }
        catch (NoConvertorException e) {
            throw new IllegalArgumentException("Unable to transform " + value.getClass() + " to an RDF Node. Only " + RdfEntity.class + " and RDF Literal Types are supported");
        }
    }

    private void removeValues(UriRef proptery) {
        Iterator toRemove = this.factory.getGraph().filter(this.rdfNode, proptery, null);
        while (toRemove.hasNext()) {
            this.factory.getGraph().remove(toRemove.next());
        }
    }

    static {
        try {
            getIDMethod = RdfEntity.class.getMethod("getId", new Class[0]);
            toString = Object.class.getMethod("toString", new Class[0]);
            equals = Object.class.getMethod("equals", Object.class);
            hashCode = Object.class.getMethod("hashCode", new Class[0]);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Unable to access getId Method in the " + RdfEntity.class + " Interface", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to find getId Method in the " + RdfEntity.class + " Interface", e);
        }
    }

    private class RdfProxyPropertyCollection<T>
    extends AbstractCollection<T> {
        private final UriRef property;
        private final Class<T> genericType;
        private final boolean entity;
        private final boolean uri;
        private final boolean url;
        private final boolean uriRef;

        private RdfProxyPropertyCollection(UriRef property, Class<T> genericType) {
            this.property = property;
            this.genericType = genericType;
            this.entity = RdfEntity.class.isAssignableFrom(genericType);
            this.uri = URI.class.isAssignableFrom(genericType);
            this.url = URL.class.isAssignableFrom(genericType);
            this.uriRef = UriRef.class.isAssignableFrom(genericType);
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                Iterator<Triple> results;
                {
                    this.results = RdfProxyInvocationHandler.this.factory.getGraph().filter(RdfProxyInvocationHandler.this.rdfNode, RdfProxyPropertyCollection.this.property, null);
                }

                @Override
                public boolean hasNext() {
                    return this.results.hasNext();
                }

                @Override
                public T next() {
                    Resource value = this.results.next().getObject();
                    if (RdfProxyPropertyCollection.this.entity) {
                        return RdfProxyInvocationHandler.this.factory.getProxy((NonLiteral)value, RdfProxyPropertyCollection.this.genericType, new Class[0]);
                    }
                    if (RdfProxyPropertyCollection.this.uri) {
                        try {
                            return new URI(((UriRef)value).getUnicodeString());
                        }
                        catch (URISyntaxException e) {
                            throw new IllegalStateException("Unable to parse " + URI.class + " for " + UriRef.class + " value=" + ((UriRef)value).getUnicodeString());
                        }
                    }
                    if (RdfProxyPropertyCollection.this.url) {
                        try {
                            return new URL(((UriRef)value).getUnicodeString());
                        }
                        catch (MalformedURLException e) {
                            throw new IllegalStateException("Unable to parse " + URL.class + " for " + UriRef.class + " value=" + ((UriRef)value).getUnicodeString());
                        }
                    }
                    if (RdfProxyPropertyCollection.this.uriRef) {
                        return value;
                    }
                    return RdfProxyInvocationHandler.this.literalFactory.createObject(RdfProxyPropertyCollection.this.genericType, (TypedLiteral)value);
                }

                @Override
                public void remove() {
                    this.results.remove();
                }
            };
        }

        @Override
        public int size() {
            Iterator results = RdfProxyInvocationHandler.this.factory.getGraph().filter(RdfProxyInvocationHandler.this.rdfNode, this.property, null);
            int size = 0;
            while (results.hasNext()) {
                results.next();
                ++size;
            }
            return size;
        }

        @Override
        public boolean add(T value) {
            return RdfProxyInvocationHandler.this.addValue(this.property, value);
        }

        @Override
        public boolean remove(Object value) {
            return RdfProxyInvocationHandler.this.removeValue(this.property, value);
        }

        @Override
        public boolean isEmpty() {
            return !RdfProxyInvocationHandler.this.factory.getGraph().filter(RdfProxyInvocationHandler.this.rdfNode, this.property, null).hasNext();
        }
    }
}

