/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.stanbol.commons.indexedgraph.IndexedMGraph;
import org.apache.stanbol.enhancer.servicesapi.Blob;
import org.apache.stanbol.enhancer.servicesapi.helper.ContentItemImpl;
import org.apache.stanbol.enhancer.servicesapi.helper.InMemoryBlob;

public class WebContentItem
extends ContentItemImpl {
    public WebContentItem(URL url) {
        this(url, null);
    }

    public WebContentItem(URL url, MGraph metadata) {
        super(new UriRef(url.toString()), new UrlBlob(url), (MGraph)(metadata == null ? new IndexedMGraph() : metadata));
    }

    private static class UrlBlob
    implements Blob {
        private Blob dereferenced;
        private final URL url;

        protected UrlBlob(URL url) {
            this.url = url;
        }

        @Override
        public String getMimeType() {
            if (this.dereferenced == null) {
                this.dereference();
            }
            return this.dereferenced.getMimeType();
        }

        @Override
        public InputStream getStream() {
            if (this.dereferenced == null) {
                this.dereference();
            }
            return this.dereferenced.getStream();
        }

        @Override
        public Map<String, String> getParameter() {
            if (this.dereferenced == null) {
                this.dereference();
            }
            return this.dereferenced.getParameter();
        }

        @Override
        public long getContentLength() {
            if (this.dereferenced == null) {
                this.dereference();
            }
            return this.dereferenced.getContentLength();
        }

        private synchronized void dereference() {
            if (this.dereferenced == null) {
                try {
                    URLConnection uc = this.url.openConnection();
                    InputStream in = uc.getInputStream();
                    String mimeType = uc.getContentType();
                    if (mimeType == null) {
                        mimeType = "application/octet-stream";
                    }
                    this.dereferenced = new InMemoryBlob(in, mimeType);
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception derefereing URI " + this.url, e);
                }
            }
        }
    }
}

