/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper;

import java.util.Collections;
import java.util.Set;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.stanbol.commons.indexedgraph.IndexedMGraph;
import org.apache.stanbol.enhancer.servicesapi.Chain;
import org.apache.stanbol.enhancer.servicesapi.ChainException;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.helper.ExecutionPlanHelper;

public class SingleEngineChain
implements Chain {
    private final Graph executionPlan;
    private final EnhancementEngine engine;
    private final String name;

    public SingleEngineChain(EnhancementEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("The parsed EnhancementEngine MUST NOT be NULL!");
        }
        this.engine = engine;
        this.name = engine.getName() + "Chain";
        IndexedMGraph graph = new IndexedMGraph();
        ExecutionPlanHelper.writeExecutionNode((MGraph)graph, ExecutionPlanHelper.createExecutionPlan((MGraph)graph, this.name), engine.getName(), false, null);
        this.executionPlan = graph.getGraph();
    }

    @Override
    public Graph getExecutionPlan() throws ChainException {
        return this.executionPlan;
    }

    @Override
    public Set<String> getEngines() throws ChainException {
        return Collections.singleton(this.engine.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }
}

