/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.stanbol.enhancer.servicesapi.Blob;
import org.apache.stanbol.enhancer.servicesapi.helper.ContentItemHelper;

public class InMemoryBlob
implements Blob {
    private static final Charset UTF8 = Charset.forName("utf-8");
    public static final String DEFAULT_TEXT_MIMETYPE = "text/plain";
    public static final String DEFAULT_BINARY_MIMETYPE = "application/octet-stream";
    protected final String mimeType;
    protected final Map<String, String> parameters;
    private byte[] data;

    public InMemoryBlob(String text, String mimeType) {
        this(text.getBytes(UTF8), mimeType != null ? mimeType : DEFAULT_TEXT_MIMETYPE, Collections.singletonMap("charset", UTF8.name()));
    }

    public InMemoryBlob(InputStream in, String mimeType) throws IOException {
        this(IOUtils.toByteArray((InputStream)in), mimeType);
        IOUtils.closeQuietly((InputStream)in);
    }

    public InMemoryBlob(byte[] data, String mimeType) {
        this(data, mimeType, null);
    }

    protected InMemoryBlob(byte[] data, String mimeType, Map<String, String> parsedParameters) {
        Map<String, String> parameters;
        if (data == null) {
            throw new IllegalArgumentException("The parsed content MUST NOT be NULL!");
        }
        this.data = data;
        if (mimeType == null) {
            this.mimeType = DEFAULT_BINARY_MIMETYPE;
            parameters = new HashMap<String, String>();
        } else {
            parameters = ContentItemHelper.parseMimeType(mimeType);
            this.mimeType = parameters.remove(null);
        }
        if (parsedParameters != null) {
            parameters.putAll(parsedParameters);
        }
        this.parameters = Collections.unmodifiableMap(parameters);
    }

    @Override
    public final InputStream getStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public final long getContentLength() {
        return this.data.length;
    }

    @Override
    public final String getMimeType() {
        return this.mimeType;
    }

    @Override
    public final Map<String, String> getParameter() {
        return this.parameters;
    }
}

