/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.impl.PlainLiteralImpl;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.stanbol.commons.indexedgraph.IndexedMGraph;
import org.apache.stanbol.enhancer.servicesapi.ChainException;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngineManager;
import org.apache.stanbol.enhancer.servicesapi.helper.EnhancementEngineHelper;
import org.apache.stanbol.enhancer.servicesapi.rdf.ExecutionPlan;
import org.apache.stanbol.enhancer.servicesapi.rdf.Properties;

public final class ExecutionPlanHelper {
    private static LiteralFactory lf = LiteralFactory.getInstance();

    private ExecutionPlanHelper() {
    }

    public static NonLiteral writeExecutionNode(MGraph graph, NonLiteral epNode, String engineName, boolean optional, Set<NonLiteral> dependsOn) {
        if (graph == null) {
            throw new IllegalArgumentException("The parsed MGraph MUST NOT be NULL!");
        }
        if (engineName == null || engineName.isEmpty()) {
            throw new IllegalArgumentException("The parsed Engine name MUST NOT be NULL nor empty!");
        }
        if (epNode == null) {
            throw new IllegalArgumentException("The ep:ExecutionPlan instance MUST NOT be NULL!");
        }
        BNode node = new BNode();
        graph.add((Object)new TripleImpl(epNode, ExecutionPlan.HAS_EXECUTION_NODE, (Resource)node));
        graph.add((Object)new TripleImpl((NonLiteral)node, Properties.RDF_TYPE, (Resource)ExecutionPlan.EXECUTION_NODE));
        graph.add((Object)new TripleImpl((NonLiteral)node, ExecutionPlan.ENGINE, (Resource)new PlainLiteralImpl(engineName)));
        if (dependsOn != null) {
            for (NonLiteral dependend : dependsOn) {
                if (dependend == null) continue;
                graph.add((Object)new TripleImpl((NonLiteral)node, ExecutionPlan.DEPENDS_ON, (Resource)dependend));
            }
        }
        graph.add((Object)new TripleImpl((NonLiteral)node, ExecutionPlan.OPTIONAL, (Resource)lf.createTypedLiteral((Object)optional)));
        return node;
    }

    public static NonLiteral createExecutionPlan(MGraph graph, String chainName) {
        if (graph == null) {
            throw new IllegalArgumentException("The parsed MGraph MUST NOT be NULL!");
        }
        if (chainName == null || chainName.isEmpty()) {
            throw new IllegalArgumentException("The parsed Chain name MUST NOT be NULL nor empty!");
        }
        BNode node = new BNode();
        graph.add((Object)new TripleImpl((NonLiteral)node, Properties.RDF_TYPE, (Resource)ExecutionPlan.EXECUTION_PLAN));
        graph.add((Object)new TripleImpl((NonLiteral)node, ExecutionPlan.CHAIN, (Resource)new PlainLiteralImpl(chainName)));
        return node;
    }

    public static Set<NonLiteral> getExecutable(TripleCollection executionPlan, Set<NonLiteral> executed) {
        HashSet<NonLiteral> executeable = new HashSet<NonLiteral>();
        Iterator nodes = executionPlan.filter(null, Properties.RDF_TYPE, (Resource)ExecutionPlan.EXECUTION_NODE);
        while (nodes.hasNext()) {
            NonLiteral node = ((Triple)nodes.next()).getSubject();
            if (executed.contains(node)) continue;
            Iterator dependsIt = executionPlan.filter(node, ExecutionPlan.DEPENDS_ON, null);
            boolean dependendExecuted = true;
            while (dependsIt.hasNext() && dependendExecuted) {
                dependendExecuted = executed.contains(((Triple)dependsIt.next()).getObject());
            }
            if (!dependendExecuted) continue;
            executeable.add(node);
        }
        return executeable;
    }

    public static Graph calculateExecutionPlan(String chainName, List<EnhancementEngine> availableEngines, Set<String> optional, Set<String> missing) {
        if (chainName == null || chainName.isEmpty()) {
            throw new IllegalArgumentException("The parsed ChainName MUST NOT be empty!");
        }
        Collections.sort(availableEngines, EnhancementEngineHelper.EXECUTION_ORDER_COMPARATOR);
        IndexedMGraph ep = new IndexedMGraph();
        NonLiteral epNode = ExecutionPlanHelper.createExecutionPlan((MGraph)ep, chainName);
        Integer prevOrder = null;
        HashSet<NonLiteral> prev = null;
        HashSet<NonLiteral> current = new HashSet<NonLiteral>();
        for (String name : missing) {
            boolean optionalMissing = optional.contains(name);
            NonLiteral node = ExecutionPlanHelper.writeExecutionNode((MGraph)ep, epNode, name, optionalMissing, null);
            if (optionalMissing) continue;
            current.add(node);
        }
        for (EnhancementEngine engine : availableEngines) {
            String name = engine.getName();
            Integer order = EnhancementEngineHelper.getEngineOrder(engine);
            if (prevOrder == null || !prevOrder.equals(order)) {
                prev = current;
                current = new HashSet();
                prevOrder = order;
            }
            current.add(ExecutionPlanHelper.writeExecutionNode((MGraph)ep, epNode, name, optional.contains(name), prev));
        }
        return ep.getGraph();
    }

    public static Set<String> validateExecutionPlan(TripleCollection executionPlan) throws ChainException {
        Iterator executionNodeIt = executionPlan.filter(null, Properties.RDF_TYPE, (Resource)ExecutionPlan.EXECUTION_NODE);
        HashSet<String> engineNames = new HashSet<String>();
        HashMap nodeDependencies = new HashMap();
        while (executionNodeIt.hasNext()) {
            NonLiteral node = ((Triple)executionNodeIt.next()).getSubject();
            Iterator<String> engines = EnhancementEngineHelper.getStrings(executionPlan, node, ExecutionPlan.ENGINE);
            if (!engines.hasNext()) {
                throw new ChainException("Execution Node " + node + " does not define " + "the required property " + ExecutionPlan.ENGINE + "!");
            }
            String engine = engines.next();
            if (engines.hasNext()) {
                throw new ChainException("Execution Node " + node + " does not define " + "multiple values for the property " + ExecutionPlan.ENGINE + "!");
            }
            if (engine.isEmpty()) {
                throw new ChainException("Execution Node " + node + " does not define " + "an empty String as engine name (property " + ExecutionPlan.ENGINE + ")!");
            }
            engineNames.add(engine);
            HashSet<NonLiteral> dependsOn = new HashSet<NonLiteral>();
            Iterator t = executionPlan.filter(node, ExecutionPlan.DEPENDS_ON, null);
            while (t.hasNext()) {
                Resource o = ((Triple)t.next()).getObject();
                if (o instanceof NonLiteral) {
                    dependsOn.add((NonLiteral)o);
                    continue;
                }
                throw new ChainException("Execution Node " + node + " defines the literal '" + o + "' as value for the " + ExecutionPlan.DEPENDS_ON + " property. However this" + "property requires values to be bNodes or URIs.");
            }
            nodeDependencies.put(node, dependsOn);
        }
        for (Map.Entry entry : nodeDependencies.entrySet()) {
            if (entry.getValue() == null) continue;
            for (NonLiteral dependent : (Collection)entry.getValue()) {
                if (nodeDependencies.containsKey(dependent)) continue;
                throw new ChainException("Execution Node " + entry.getKey() + " defines a dependency to an non existent ex:ExectutionNode " + dependent + "!");
            }
        }
        return engineNames;
    }

    public static Set<NonLiteral> getDependend(TripleCollection executionPlan, NonLiteral executionNode) {
        HashSet<NonLiteral> dependend = new HashSet<NonLiteral>();
        ExecutionPlanHelper.addDependend(dependend, executionPlan, executionNode);
        return dependend;
    }

    public static void addDependend(Collection<NonLiteral> collection, TripleCollection executionPlan, NonLiteral executionNode) {
        Iterator it = executionPlan.filter(executionNode, ExecutionPlan.DEPENDS_ON, null);
        while (it.hasNext()) {
            collection.add((NonLiteral)((Triple)it.next()).getObject());
        }
    }

    public static boolean isOptional(TripleCollection executionPlan, NonLiteral executionNode) {
        Boolean optional = EnhancementEngineHelper.get(executionPlan, executionNode, ExecutionPlan.OPTIONAL, Boolean.class, lf);
        return optional == null ? false : optional;
    }

    public static String getEngine(TripleCollection executionPlan, NonLiteral executionNode) {
        return EnhancementEngineHelper.getString(executionPlan, executionNode, ExecutionPlan.ENGINE);
    }

    public static List<EnhancementEngine> getActiveEngines(EnhancementEngineManager engineManager, TripleCollection ep) {
        Set<NonLiteral> executeable;
        ArrayList<EnhancementEngine> engines = new ArrayList<EnhancementEngine>();
        HashSet<NonLiteral> visited = new HashSet<NonLiteral>();
        do {
            executeable = ExecutionPlanHelper.getExecutable(ep, visited);
            for (NonLiteral node : executeable) {
                String engineName = EnhancementEngineHelper.getString(ep, node, ExecutionPlan.ENGINE);
                EnhancementEngine engine = engineManager.getEngine(engineName);
                if (engine != null) {
                    engines.add(engine);
                }
                visited.add(node);
            }
        } while (!executeable.isEmpty());
        return engines;
    }

    public static NonLiteral getExecutionPlan(TripleCollection graph, String chainName) {
        if (graph == null) {
            throw new IllegalArgumentException("The parsed graph MUST NOT be NULL!");
        }
        if (chainName == null || chainName.isEmpty()) {
            throw new IllegalArgumentException("The parsed chain name MUST NOT be NULL nor empty!");
        }
        Iterator it = graph.filter(null, ExecutionPlan.CHAIN, (Resource)new PlainLiteralImpl(chainName));
        if (it.hasNext()) {
            return ((Triple)it.next()).getSubject();
        }
        return null;
    }

    public static Set<NonLiteral> getExecutionNodes(TripleCollection ep, NonLiteral executionPlanNode) {
        if (ep == null) {
            throw new IllegalArgumentException("The parsed graph with the Executionplan MUST NOT be NULL!");
        }
        if (executionPlanNode == null) {
            throw new IllegalArgumentException("The parsed execution plan node MUST NOT be NULL!");
        }
        HashSet<NonLiteral> executionNodes = new HashSet<NonLiteral>();
        Iterator it = ep.filter(executionPlanNode, ExecutionPlan.HAS_EXECUTION_NODE, null);
        while (it.hasNext()) {
            Triple t = (Triple)it.next();
            Resource node = t.getObject();
            if (node instanceof NonLiteral) {
                executionNodes.add((NonLiteral)node);
                continue;
            }
            throw new IllegalStateException("The value of the " + ExecutionPlan.HAS_EXECUTION_NODE + " property MUST BE a NonLiteral (triple: " + t + ")!");
        }
        return executionNodes;
    }
}

