/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.PlainLiteralImpl;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.stanbol.commons.indexedgraph.IndexedMGraph;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.NoSuchPartException;
import org.apache.stanbol.enhancer.servicesapi.helper.EnhancementEngineHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.ExecutionPlanHelper;
import org.apache.stanbol.enhancer.servicesapi.rdf.ExecutionMetadata;
import org.apache.stanbol.enhancer.servicesapi.rdf.ExecutionPlan;
import org.apache.stanbol.enhancer.servicesapi.rdf.Properties;

public class ExecutionMetadataHelper {
    private static final LiteralFactory lf = LiteralFactory.getInstance();

    public static NonLiteral createChainExecutionNode(MGraph graph, NonLiteral executionPlan, UriRef ciUri, boolean defaultChain) {
        BNode node = new BNode();
        graph.add((Object)new TripleImpl((NonLiteral)node, Properties.RDF_TYPE, (Resource)ExecutionMetadata.EXECUTION));
        graph.add((Object)new TripleImpl((NonLiteral)node, Properties.RDF_TYPE, (Resource)ExecutionMetadata.CHAIN_EXECUTION));
        graph.add((Object)new TripleImpl((NonLiteral)node, ExecutionMetadata.ENHANCES, (Resource)ciUri));
        graph.add((Object)new TripleImpl((NonLiteral)ciUri, ExecutionMetadata.ENHANCED_BY, (Resource)node));
        graph.add((Object)new TripleImpl((NonLiteral)node, ExecutionMetadata.STATUS, (Resource)ExecutionMetadata.STATUS_SCHEDULED));
        graph.add((Object)new TripleImpl((NonLiteral)node, ExecutionMetadata.EXECUTION_PLAN, (Resource)executionPlan));
        graph.add((Object)new TripleImpl((NonLiteral)node, ExecutionMetadata.IS_DEFAULT_CHAIN, (Resource)lf.createTypedLiteral((Object)defaultChain)));
        return node;
    }

    public static NonLiteral createEngineExecution(MGraph graph, NonLiteral chainExecution, NonLiteral executionNode) {
        BNode node = new BNode();
        graph.add((Object)new TripleImpl((NonLiteral)node, Properties.RDF_TYPE, (Resource)ExecutionMetadata.EXECUTION));
        graph.add((Object)new TripleImpl((NonLiteral)node, Properties.RDF_TYPE, (Resource)ExecutionMetadata.ENGINE_EXECUTION));
        graph.add((Object)new TripleImpl((NonLiteral)node, ExecutionMetadata.EXECUTION_PART, (Resource)chainExecution));
        graph.add((Object)new TripleImpl((NonLiteral)node, ExecutionMetadata.EXECUTION_NODE, (Resource)executionNode));
        graph.add((Object)new TripleImpl((NonLiteral)node, ExecutionMetadata.STATUS, (Resource)ExecutionMetadata.STATUS_SCHEDULED));
        return node;
    }

    public static void setExecutionCompleted(MGraph graph, NonLiteral execution, String message) {
        TypedLiteral dateTime = lf.createTypedLiteral((Object)new Date());
        ExecutionMetadataHelper.setStatus(graph, execution, ExecutionMetadata.STATUS_COMPLETED);
        graph.add((Object)new TripleImpl(execution, ExecutionMetadata.COMPLETED, (Resource)dateTime));
        if (message != null) {
            graph.add((Object)new TripleImpl(execution, ExecutionMetadata.STATUS_MESSAGE, (Resource)new PlainLiteralImpl(message)));
        }
    }

    public static void setExecutionScheduled(MGraph graph, NonLiteral execution) {
        ExecutionMetadataHelper.setStatus(graph, execution, ExecutionMetadata.STATUS_SCHEDULED);
        Iterator it = graph.filter(execution, ExecutionMetadata.STARTED, null);
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        it = graph.filter(execution, ExecutionMetadata.COMPLETED, null);
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    public static void setExecutionFaild(MGraph graph, NonLiteral execution, String message) {
        TypedLiteral dateTime = lf.createTypedLiteral((Object)new Date());
        ExecutionMetadataHelper.setStatus(graph, execution, ExecutionMetadata.STATUS_FAILED);
        graph.add((Object)new TripleImpl(execution, ExecutionMetadata.COMPLETED, (Resource)dateTime));
        if (message == null) {
            throw new IllegalArgumentException("For faild Execution a STATUS message is required!");
        }
        graph.add((Object)new TripleImpl(execution, ExecutionMetadata.STATUS_MESSAGE, (Resource)new PlainLiteralImpl(message)));
    }

    public static void setExecutionSkipped(MGraph graph, NonLiteral execution, String message) {
        TypedLiteral dateTime = lf.createTypedLiteral((Object)new Date());
        ExecutionMetadataHelper.setStatus(graph, execution, ExecutionMetadata.STATUS_SKIPPED);
        graph.add((Object)new TripleImpl(execution, ExecutionMetadata.STARTED, (Resource)dateTime));
        graph.add((Object)new TripleImpl(execution, ExecutionMetadata.COMPLETED, (Resource)dateTime));
        if (message != null) {
            graph.add((Object)new TripleImpl(execution, ExecutionMetadata.STATUS_MESSAGE, (Resource)new PlainLiteralImpl(message)));
        }
    }

    public static void setExecutionInProgress(MGraph graph, NonLiteral execution) {
        TypedLiteral dateTime = lf.createTypedLiteral((Object)new Date());
        ExecutionMetadataHelper.setStatus(graph, execution, ExecutionMetadata.STATUS_IN_PROGRESS);
        graph.add((Object)new TripleImpl(execution, ExecutionMetadata.STARTED, (Resource)dateTime));
    }

    private static void setStatus(MGraph graph, NonLiteral execution, UriRef status) {
        Iterator it = graph.filter(execution, ExecutionMetadata.STATUS, null);
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        if (status != null) {
            graph.add((Object)new TripleImpl(execution, ExecutionMetadata.STATUS, (Resource)status));
        }
    }

    public static final NonLiteral getChainExecutionForChainName(TripleCollection em, TripleCollection ep, String chainName) {
        NonLiteral executionPlanNode = ExecutionPlanHelper.getExecutionPlan(ep, chainName);
        if (executionPlanNode == null) {
            return null;
        }
        return ExecutionMetadataHelper.getChainExecutionForExecutionPlan(em, executionPlanNode);
    }

    public static NonLiteral getChainExecutionForExecutionPlan(TripleCollection graph, NonLiteral executionPlanNode) {
        if (graph == null) {
            throw new IllegalArgumentException("The parsed graph with the execution metadata MUST NOT be NULL!");
        }
        if (executionPlanNode == null) {
            throw new IllegalArgumentException("The parsed execution plan node MUST NOT be NULL!");
        }
        Iterator it = graph.filter(null, ExecutionMetadata.EXECUTION_PLAN, (Resource)executionPlanNode);
        if (it.hasNext()) {
            return ((Triple)it.next()).getSubject();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MGraph initExecutionMetadataContentPart(ContentItem contentItem) {
        MGraph executionMetadata;
        if (contentItem == null) {
            throw new IllegalArgumentException("The parsed ContentItme MUST NOT be NULL!");
        }
        contentItem.getLock().writeLock().lock();
        try {
            try {
                executionMetadata = contentItem.getPart(ExecutionMetadata.CHAIN_EXECUTION, MGraph.class);
            }
            catch (NoSuchPartException e) {
                executionMetadata = new IndexedMGraph();
                contentItem.addPart(ExecutionMetadata.CHAIN_EXECUTION, executionMetadata);
            }
        }
        finally {
            contentItem.getLock().writeLock().unlock();
        }
        return executionMetadata;
    }

    public static final Map<NonLiteral, NonLiteral> initExecutionMetadata(MGraph em, TripleCollection ep, UriRef ciUri, String chainName, Boolean isDefaultChain) {
        NonLiteral executionPlanNode;
        if (em == null) {
            throw new IllegalArgumentException("The parsed ExecutionMetadata graph MUST NOT be NULL!");
        }
        if (ciUri == null) {
            throw new IllegalArgumentException("The parsed URI of the contentItem MUST NOT be NULL!");
        }
        NonLiteral chainExecutionNode = ExecutionMetadataHelper.getChainExecutionForExecutionPlan((TripleCollection)em, (NonLiteral)ciUri);
        if (chainExecutionNode != null) {
            executionPlanNode = ExecutionMetadataHelper.getExecutionPlanNode((TripleCollection)em, chainExecutionNode);
            if (executionPlanNode == null) {
                throw new IllegalArgumentException("The em:ChainExecution '" + chainExecutionNode + "'that enhances ContentItem '" + ciUri + "' does not define a link to an valid ExecutionPlan");
            }
            isDefaultChain = EnhancementEngineHelper.get((TripleCollection)em, chainExecutionNode, ExecutionMetadata.IS_DEFAULT_CHAIN, Boolean.class, lf);
            String extractedChainName = EnhancementEngineHelper.getString(ep, executionPlanNode, ExecutionPlan.CHAIN);
            if (extractedChainName == null) {
                throw new IllegalArgumentException("The em:ChainExecution '" + chainExecutionNode + "'that enhances ContentItem '" + ciUri + "' links to the ep:ExecutionPlan '" + executionPlanNode + "' that does not define a ChainName (property: " + ExecutionPlan.CHAIN + ")!");
            }
            if (chainName == null) {
                chainName = extractedChainName;
            } else if (!chainName.equals(extractedChainName)) {
                throw new IllegalArgumentException("The em:ChainExecution '" + chainExecutionNode + "'that enhances ContentItem '" + ciUri + "' links to the ep:ExecutionPlan '" + executionPlanNode + "' with the chain name '" + extractedChainName + "' but '" + chainName + "' was parsed " + "as expected chain name!");
            }
        } else {
            executionPlanNode = ExecutionPlanHelper.getExecutionPlan(ep, chainName);
            if (executionPlanNode == null) {
                throw new IllegalArgumentException("The parsed ExectuonPlan graph does not contain anExecutionPlan for a Chain with the name '" + chainName + "'!");
            }
            if (isDefaultChain == null) {
                throw new IllegalArgumentException("The isDefaultChain parameter MUST NOTbe NULL if initialising from empty ExecutionMetadata!");
            }
            chainExecutionNode = ExecutionMetadataHelper.createChainExecutionNode(em, executionPlanNode, ciUri, isDefaultChain);
        }
        HashMap<NonLiteral, NonLiteral> executionsMap = new HashMap<NonLiteral, NonLiteral>();
        Set<NonLiteral> executionNodes = ExecutionPlanHelper.getExecutionNodes(ep, executionPlanNode);
        Set<NonLiteral> executions = ExecutionMetadataHelper.getExecutions((TripleCollection)em, chainExecutionNode);
        for (NonLiteral en : executionNodes) {
            NonLiteral execution;
            Iterator it = em.filter(null, ExecutionMetadata.EXECUTION_NODE, (Resource)en);
            if (it.hasNext()) {
                execution = ((Triple)it.next()).getSubject();
                if (!executions.contains(execution)) {
                    throw new IllegalStateException("Execution '" + execution + "' for ExecutionNode '" + en + "' (engine: '" + ExecutionPlanHelper.getEngine(ep, en) + "') is not part of ChainExecution '" + chainExecutionNode + "' (chain: '" + chainName + ")!");
                }
            } else {
                execution = ExecutionMetadataHelper.createEngineExecution(em, chainExecutionNode, en);
                executions.add(execution);
            }
            executionsMap.put(execution, en);
        }
        for (NonLiteral e : executions) {
            if (executionsMap.containsKey(e)) continue;
            NonLiteral en = ExecutionMetadataHelper.getExecutionNode((TripleCollection)em, e);
            throw new IllegalStateException("ChainExecution '" + chainExecutionNode + "' (chain: '" + chainName + ") contains" + "Execution '" + e + "' for ExecutionNode '" + en + "' (engine: '" + ExecutionPlanHelper.getEngine(ep, en) + "') that is not part of the pased ExecutionPlan '" + executionPlanNode + "'(chain; '" + chainName + "')!");
        }
        return executionsMap;
    }

    public static NonLiteral getExecutionNode(TripleCollection graph, NonLiteral execution) {
        Iterator it = graph.filter(execution, ExecutionMetadata.EXECUTION_NODE, null);
        if (it.hasNext()) {
            Triple t = (Triple)it.next();
            Resource o = t.getObject();
            if (o instanceof NonLiteral) {
                return (NonLiteral)o;
            }
            throw new IllegalStateException("Value of property " + ExecutionMetadata.EXECUTION_NODE + "MUST BE of type NonLiteral (triple: '" + t + "')!");
        }
        return null;
    }

    public static Set<NonLiteral> getExecutions(TripleCollection em, NonLiteral chainExecutionNode) {
        if (em == null) {
            throw new IllegalArgumentException("The parsed graph with the Execution metadata MUST NOT be NULL!");
        }
        if (chainExecutionNode == null) {
            throw new IllegalArgumentException("The parsed chain execution plan node MUST NOT be NULL!");
        }
        HashSet<NonLiteral> executionNodes = new HashSet<NonLiteral>();
        Iterator it = em.filter(null, ExecutionMetadata.EXECUTION_PART, (Resource)chainExecutionNode);
        while (it.hasNext()) {
            executionNodes.add(((Triple)it.next()).getSubject());
        }
        return executionNodes;
    }

    public static NonLiteral getExecutionPlanNode(TripleCollection em, NonLiteral chainExecutionNode) {
        Iterator it = em.filter(chainExecutionNode, ExecutionMetadata.EXECUTION_PLAN, null);
        if (it.hasNext()) {
            Triple t = (Triple)it.next();
            Resource r = t.getObject();
            if (r instanceof NonLiteral) {
                return (NonLiteral)r;
            }
            throw new IllegalStateException("Value of the property " + ExecutionMetadata.EXECUTION_PLAN + " MUST BE a NonLiteral (triple: '" + t + "')!");
        }
        return null;
    }

    public static NonLiteral getChainExecution(TripleCollection em, UriRef ciUri) {
        Iterator it = em.filter(null, ExecutionMetadata.ENHANCES, (Resource)ciUri);
        if (it.hasNext()) {
            return ((Triple)it.next()).getSubject();
        }
        return null;
    }

    public static boolean isExecutionFailed(TripleCollection graph, NonLiteral execution) {
        return ExecutionMetadata.STATUS_FAILED.equals((Object)EnhancementEngineHelper.getReference(graph, execution, ExecutionMetadata.STATUS));
    }

    public static boolean isExecutionFinished(TripleCollection graph, NonLiteral execution) {
        UriRef status = EnhancementEngineHelper.getReference(graph, execution, ExecutionMetadata.STATUS);
        return ExecutionMetadata.STATUS_FAILED.equals((Object)status) || ExecutionMetadata.STATUS_COMPLETED.equals((Object)status);
    }

    public static Date getStarted(TripleCollection graph, NonLiteral execution) {
        return EnhancementEngineHelper.get(graph, execution, ExecutionMetadata.STARTED, Date.class, lf);
    }

    public static Date getCompleted(TripleCollection graph, NonLiteral execution) {
        return EnhancementEngineHelper.get(graph, execution, ExecutionMetadata.COMPLETED, Date.class, lf);
    }
}

