/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper;

import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import org.apache.clerezza.rdf.core.Literal;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.ServiceProperties;
import org.apache.stanbol.enhancer.servicesapi.rdf.Properties;
import org.apache.stanbol.enhancer.servicesapi.rdf.TechnicalClasses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancementEngineHelper {
    protected static Random rng = new Random();
    private static final Logger log = LoggerFactory.getLogger(EnhancementEngineHelper.class);
    public static final Comparator<EnhancementEngine> EXECUTION_ORDER_COMPARATOR = new Comparator<EnhancementEngine>(){

        @Override
        public int compare(EnhancementEngine engine1, EnhancementEngine engine2) {
            Integer order2;
            Integer order1 = EnhancementEngineHelper.getEngineOrder(engine1);
            return order1 == (order2 = EnhancementEngineHelper.getEngineOrder(engine2)) ? 0 : (order1 < order2 ? 1 : -1);
        }
    };

    public static void setSeed(long seed) {
        rng.setSeed(seed);
    }

    public static UriRef createTextEnhancement(ContentItem ci, EnhancementEngine engine) {
        return EnhancementEngineHelper.createTextEnhancement((MGraph)ci.getMetadata(), engine, new UriRef(ci.getUri().getUnicodeString()));
    }

    public static UriRef createTextEnhancement(MGraph metadata, EnhancementEngine engine, UriRef contentItemId) {
        UriRef enhancement = EnhancementEngineHelper.createEnhancement(metadata, engine, contentItemId);
        metadata.add((Object)new TripleImpl((NonLiteral)enhancement, Properties.RDF_TYPE, (Resource)TechnicalClasses.ENHANCER_TEXTANNOTATION));
        return enhancement;
    }

    public static UriRef createEntityEnhancement(ContentItem ci, EnhancementEngine engine) {
        return EnhancementEngineHelper.createEntityEnhancement((MGraph)ci.getMetadata(), engine, new UriRef(ci.getUri().getUnicodeString()));
    }

    public static UriRef createEntityEnhancement(MGraph metadata, EnhancementEngine engine, UriRef contentItemId) {
        UriRef enhancement = EnhancementEngineHelper.createEnhancement(metadata, engine, contentItemId);
        metadata.add((Object)new TripleImpl((NonLiteral)enhancement, Properties.RDF_TYPE, (Resource)TechnicalClasses.ENHANCER_ENTITYANNOTATION));
        return enhancement;
    }

    protected static UriRef createEnhancement(MGraph metadata, EnhancementEngine engine, UriRef contentItemId) {
        LiteralFactory literalFactory = LiteralFactory.getInstance();
        UriRef enhancement = new UriRef("urn:enhancement-" + EnhancementEngineHelper.randomUUID());
        metadata.add((Object)new TripleImpl((NonLiteral)enhancement, Properties.RDF_TYPE, (Resource)TechnicalClasses.ENHANCER_ENHANCEMENT));
        metadata.add((Object)new TripleImpl((NonLiteral)enhancement, Properties.ENHANCER_EXTRACTED_FROM, (Resource)contentItemId));
        metadata.add((Object)new TripleImpl((NonLiteral)enhancement, Properties.DC_CREATED, (Resource)literalFactory.createTypedLiteral((Object)new Date())));
        metadata.add((Object)new TripleImpl((NonLiteral)enhancement, Properties.DC_CREATOR, (Resource)literalFactory.createTypedLiteral((Object)engine.getClass().getName())));
        return enhancement;
    }

    @Deprecated
    public static UriRef createNewExtraction(ContentItem ci, EnhancementEngine engine) {
        LiteralFactory literalFactory = LiteralFactory.getInstance();
        LockableMGraph metadata = ci.getMetadata();
        UriRef extraction = new UriRef("urn:extraction-" + EnhancementEngineHelper.randomUUID());
        metadata.add((Object)new TripleImpl((NonLiteral)extraction, Properties.RDF_TYPE, (Resource)TechnicalClasses.ENHANCER_EXTRACTION));
        metadata.add((Object)new TripleImpl((NonLiteral)extraction, Properties.ENHANCER_RELATED_CONTENT_ITEM, (Resource)new UriRef(ci.getUri().getUnicodeString())));
        metadata.add((Object)new TripleImpl((NonLiteral)extraction, Properties.DC_CREATED, (Resource)literalFactory.createTypedLiteral((Object)new Date())));
        metadata.add((Object)new TripleImpl((NonLiteral)extraction, Properties.DC_CREATOR, (Resource)literalFactory.createTypedLiteral((Object)engine.getClass().getName())));
        return extraction;
    }

    public static UUID randomUUID() {
        return new UUID(rng.nextLong(), rng.nextLong());
    }

    public static <T> T get(TripleCollection graph, NonLiteral resource, UriRef property, Class<T> type, LiteralFactory literalFactory) {
        Iterator results = graph.filter(resource, property, null);
        if (results.hasNext()) {
            while (results.hasNext()) {
                Triple result = (Triple)results.next();
                if (result.getObject() instanceof TypedLiteral) {
                    return (T)literalFactory.createObject(type, (TypedLiteral)result.getObject());
                }
                log.debug("Triple {} does not have a TypedLiteral as object! -> ignore", (Object)result);
            }
            log.info("No value for {} and property {} had the requested Type {} -> return null", new Object[]{resource, property, type});
            return null;
        }
        log.debug("No Triple found for {} and property {}! -> return null", (Object)resource, (Object)property);
        return null;
    }

    public static <T> Iterator<T> getValues(TripleCollection graph, NonLiteral resource, UriRef property, final Class<T> type, final LiteralFactory literalFactory) {
        final Iterator results = graph.filter(resource, property, null);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return results.hasNext();
            }

            @Override
            public T next() {
                return literalFactory.createObject(type, (TypedLiteral)((Triple)results.next()).getObject());
            }

            @Override
            public void remove() {
                results.remove();
            }
        };
    }

    public static String getString(TripleCollection graph, NonLiteral resource, UriRef property) {
        Iterator results = graph.filter(resource, property, null);
        if (results.hasNext()) {
            while (results.hasNext()) {
                Triple result = (Triple)results.next();
                if (result.getObject() instanceof Literal) {
                    return ((Literal)result.getObject()).getLexicalForm();
                }
                log.debug("Triple {} does not have a literal as object! -> ignore", (Object)result);
            }
            log.info("No Literal value for {} and property {} -> return null", (Object)resource, (Object)property);
            return null;
        }
        log.debug("No Triple found for " + resource + " and property " + property + "! -> return null");
        return null;
    }

    public static Iterator<String> getStrings(TripleCollection graph, NonLiteral resource, UriRef property) {
        final Iterator results = graph.filter(resource, property, null);
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return results.hasNext();
            }

            @Override
            public String next() {
                return ((Literal)((Triple)results.next()).getObject()).getLexicalForm();
            }

            @Override
            public void remove() {
                results.remove();
            }
        };
    }

    public static UriRef getReference(TripleCollection graph, NonLiteral resource, UriRef property) {
        Iterator results = graph.filter(resource, property, null);
        if (results.hasNext()) {
            while (results.hasNext()) {
                Triple result = (Triple)results.next();
                if (result.getObject() instanceof UriRef) {
                    return (UriRef)result.getObject();
                }
                log.debug("Triple " + result + " does not have a UriRef as object! -> ignore");
            }
            log.info("No UriRef value for {} and property {} -> return null", (Object)resource, (Object)property);
            return null;
        }
        log.debug("No Triple found for {} and property {}! -> return null", (Object)resource, (Object)property);
        return null;
    }

    public static Iterator<UriRef> getReferences(TripleCollection graph, NonLiteral resource, UriRef property) {
        final Iterator results = graph.filter(resource, property, null);
        return new Iterator<UriRef>(){

            @Override
            public boolean hasNext() {
                return results.hasNext();
            }

            @Override
            public UriRef next() {
                return (UriRef)((Triple)results.next()).getObject();
            }

            @Override
            public void remove() {
                results.remove();
            }
        };
    }

    public static Integer getEngineOrder(EnhancementEngine engine) {
        log.debug("getOrder " + engine);
        if (engine instanceof ServiceProperties) {
            log.debug(" ... implements ServiceProperties");
            Object value = ((ServiceProperties)((Object)engine)).getServiceProperties().get("org.apache.stanbol.enhancer.engine.order");
            log.debug("   > value = " + value + " " + value.getClass());
            if (value != null && value instanceof Integer) {
                return (Integer)value;
            }
        }
        return ServiceProperties.ORDERING_DEFAULT;
    }
}

