/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.access.LockableMGraphWrapper;
import org.apache.stanbol.enhancer.servicesapi.Blob;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.NoSuchPartException;

public abstract class ContentItemImpl
implements ContentItem {
    protected static final String MAIN_BLOB_SUFFIX = "_main";
    private final LinkedHashMap<UriRef, Object> parts = new LinkedHashMap();
    private final UriRef uri;
    private final UriRef mainBlobUri;
    private final LockableMGraph metadata;
    protected final Lock readLock;
    protected final Lock writeLock;

    protected ContentItemImpl(UriRef uri, Blob main, MGraph metadata) {
        if (uri == null) {
            throw new IllegalArgumentException("The URI for the ContentItem MUST NOT be NULL!");
        }
        if (main == null) {
            throw new IllegalArgumentException("The main Blob MUST NOT be NULL!");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Tha parsed graph MUST NOT be NULL!");
        }
        this.uri = uri;
        this.mainBlobUri = new UriRef(uri.getUnicodeString() + MAIN_BLOB_SUFFIX);
        this.parts.put(this.mainBlobUri, main);
        this.metadata = metadata instanceof LockableMGraph ? (LockableMGraph)metadata : new LockableMGraphWrapper(metadata);
        this.readLock = this.metadata.getLock().readLock();
        this.writeLock = this.metadata.getLock().writeLock();
    }

    @Override
    public final ReadWriteLock getLock() {
        return this.metadata.getLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Blob getBlob() {
        this.readLock.lock();
        try {
            Blob blob = (Blob)this.parts.get(this.mainBlobUri);
            return blob;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final InputStream getStream() {
        return this.getBlob().getStream();
    }

    @Override
    public final String getMimeType() {
        return this.getBlob().getMimeType();
    }

    @Override
    public <T> T getPart(UriRef uri, Class<T> clazz) throws NoSuchPartException {
        this.readLock.lock();
        try {
            Object part = this.parts.get(uri);
            if (part == null) {
                throw new NoSuchPartException(uri);
            }
            if (clazz.isAssignableFrom(part.getClass())) {
                Object object = part;
                return (T)object;
            }
            throw new ClassCastException("The part '" + part + "'(class: " + part.getClass() + ") is not compatiple to the requested" + "type " + clazz);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UriRef getPartUri(int index) throws NoSuchPartException {
        this.readLock.lock();
        try {
            int count = 0;
            for (Map.Entry<UriRef, Object> entry : this.parts.entrySet()) {
                if (count == index) {
                    UriRef uriRef = entry.getKey();
                    return uriRef;
                }
                ++count;
            }
        }
        finally {
            this.readLock.unlock();
        }
        throw new NoSuchPartException(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getPart(int index, Class<T> clazz) throws NoSuchPartException {
        this.readLock.lock();
        try {
            Object result = null;
            int count = 0;
            for (Map.Entry<UriRef, Object> entry : this.parts.entrySet()) {
                if (count == index) {
                    result = entry.getValue();
                    if (!result.getClass().isAssignableFrom(clazz)) {
                        throw new NoSuchPartException("The body part 0 is of type " + result.getClass().getName() + " which cannot be converted to " + clazz.getName());
                    }
                    Object object = result;
                    return (T)object;
                }
                ++count;
            }
        }
        finally {
            this.readLock.unlock();
        }
        throw new NoSuchPartException(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object addPart(UriRef uriRef, Object object) {
        this.writeLock.lock();
        try {
            if (uriRef == null || object == null) {
                throw new IllegalArgumentException("The parsed content part ID and object MUST NOT be NULL!");
            }
            if (uriRef.equals((Object)this.mainBlobUri)) {
                throw new IllegalArgumentException("The parsed content part ID MUST NOT be equals to the ID used by the main Content Part ( ContentItem.getUri()+\"_main\")");
            }
            Object object2 = this.parts.put(uriRef, object);
            return object2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePart(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("The parsed index MUST NOT be < 0");
        }
        if (index == 0) {
            throw new IllegalStateException("The main ContentPart (index == 0) CAN NOT be removed!");
        }
        this.writeLock.lock();
        try {
            UriRef partUri = this.getPartUri(index);
            this.parts.remove(partUri);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePart(UriRef uriRef) {
        if (uriRef == null) {
            throw new IllegalArgumentException("The parsed uriRef MUST NOT be NULL!");
        }
        this.writeLock.lock();
        try {
            UriRef mainContentPartUri = this.parts.keySet().iterator().next();
            if (uriRef.equals((Object)mainContentPartUri)) {
                throw new IllegalStateException("The main ContentPart (uri '" + uriRef + "') CAN NOT be removed!");
            }
            if (this.parts.remove(uriRef) == null) {
                throw new NoSuchPartException(uriRef);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public UriRef getUri() {
        return this.uri;
    }

    @Override
    public LockableMGraph getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof ContentItem && ((ContentItem)o).getUri().equals((Object)this.uri);
    }

    public String toString() {
        return String.format("%s uri=[%s], content=[%s;mime-type:%s%s], metadata=[%s triples], parts=%s", this.getClass().getSimpleName(), this.getUri().getUnicodeString(), this.getBlob().getContentLength() >= 0L ? "size:" + this.getBlob().getContentLength() + " bytes;" : "", this.getBlob().getMimeType(), this.getBlob().getParameter().isEmpty() ? "" : ";parameter:" + this.getBlob().getParameter(), this.getMetadata().size(), this.parts.keySet());
    }
}

