/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.servicesapi.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigUtils {
    private static Map<String, String> rdfExt2Formats;
    private static final Logger log;

    private ConfigUtils() {
    }

    public static String guessRdfFormat(String extension) {
        return rdfExt2Formats.get(extension);
    }

    public static Map<String, Map<String, List<String>>> parseConfig(Iterable<String> configuration) {
        HashMap<String, Map<String, List<String>>> config = new HashMap<String, Map<String, List<String>>>();
        for (String line : configuration) {
            ConfigUtils.parseLine(config, line);
        }
        return config;
    }

    public static Map<String, Map<String, List<String>>> parseConfig(Iterator<String> confIterator) {
        HashMap<String, Map<String, List<String>>> config = new HashMap<String, Map<String, List<String>>>();
        while (confIterator.hasNext()) {
            ConfigUtils.parseLine(config, confIterator.next());
        }
        return config;
    }

    public static Map.Entry<String, Map<String, List<String>>> parseConfigEntry(String line) {
        String[] elements = line.split(";");
        return Collections.singletonMap(elements[0].trim(), ConfigUtils.getParameters(elements, 1)).entrySet().iterator().next();
    }

    private static void parseLine(Map<String, Map<String, List<String>>> config, String line) {
        String[] elements;
        String key;
        if (line == null || line.isEmpty() || line.charAt(0) == ';') {
            log.warn("Configuration entry ignored because of empty Engine name (entry: '" + line + "')!");
        }
        if (config.containsKey(key = (elements = line.split(";"))[0].trim())) {
            throw new IllegalArgumentException("The configuration MUST NOT contain the same key '" + elements[0] + "' multiple times!");
        }
        config.put(key, ConfigUtils.getParameters(elements, 1));
    }

    public static boolean getState(Map<String, List<String>> parameters, String key) {
        List<String> value = parameters.get(key);
        return value != null && (value.isEmpty() || Boolean.parseBoolean(value.get(0)));
    }

    public static String getValue(Map<String, List<String>> parameters, String key) {
        List<String> values = parameters.get(key);
        return values == null || values.isEmpty() ? null : values.get(1);
    }

    public static Map<String, List<String>> getParameters(String[] elements, int start) {
        Map<String, List<String>> parameters;
        if (elements.length > start) {
            parameters = new HashMap<String, List<String>>(elements.length - start);
            for (int i = start; i < elements.length; ++i) {
                if (elements[i] == null || elements[i].isEmpty()) continue;
                if (elements[i].charAt(0) == '=') {
                    throw new IllegalArgumentException("Unable to parse parameters because element at index " + i + " MUST NOT start with '=' (element: '" + elements[i] + "')!");
                }
                int sepIndex = elements[i].indexOf(61);
                String param = sepIndex > 0 ? elements[i].substring(0, sepIndex).trim() : elements[i].trim();
                String value = sepIndex > 0 && elements[i].length() > sepIndex + 1 ? elements[i].substring(sepIndex + 1).trim() : null;
                List<String> paramValues = parameters.get(param);
                if (paramValues == null) {
                    paramValues = new ArrayList<String>(3);
                    parameters.put(param, paramValues);
                }
                if (value == null) continue;
                for (String v : value.split(",")) {
                    if (v == null) continue;
                    paramValues.add(v);
                }
            }
        } else {
            parameters = Collections.emptyMap();
        }
        return parameters;
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(null, "application/rdf+xml");
        m.put("", "application/rdf+xml");
        m.put("rdf", "application/rdf+xml");
        m.put("xml", "application/rdf+xml");
        m.put("owl", "application/rdf+xml");
        m.put("rdfs", "application/rdf+xml");
        m.put("json", "application/rdf+json");
        m.put("nt", "text/rdf+nt");
        m.put("n3", "text/rdf+n3");
        m.put("ttl", "text/turtle");
        rdfExt2Formats = Collections.unmodifiableMap(m);
        log = LoggerFactory.getLogger(ConfigUtils.class);
    }
}

