/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.tika.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.stanbol.enhancer.engines.tika.metadata.Mapping;
import org.apache.tika.metadata.Metadata;

public final class ResourceMapping
extends Mapping {
    private static final Mapping[] EMPTY = new Mapping[0];
    Collection<Mapping> required;
    Collection<Mapping> optional;
    Collection<Mapping> additional;
    Set<String> mappedTikaProperties;

    public ResourceMapping(String ontProperty, Mapping ... required) {
        this(new UriRef(ontProperty), required);
    }

    public ResourceMapping(String ontProperty, Mapping[] required, Mapping[] optional, Mapping[] additional) {
        this(new UriRef(ontProperty), required, optional, additional);
    }

    public ResourceMapping(UriRef ontProperty, Mapping ... requried) {
        this(ontProperty, requried, (Mapping[])null, (Mapping[])null);
    }

    public ResourceMapping(UriRef ontProperty, Mapping[] required, Mapping[] optional, Mapping[] additional) {
        super(ontProperty, null);
        required = required == null ? EMPTY : required;
        optional = optional == null ? EMPTY : optional;
        Mapping[] mappingArray = additional = additional == null ? EMPTY : additional;
        if (required.length < 1 && optional.length < 1) {
            throw new IllegalArgumentException("Neighter optional nor required subMappings where parsed!");
        }
        HashSet<String> mapped = new HashSet<String>();
        this.required = Arrays.asList(required);
        if (this.required.contains(null)) {
            throw new IllegalArgumentException("Tha parsed Array of required sub mappings MUST NOT contain a NULL element(parsed: " + this.required + ")");
        }
        for (Mapping m : this.required) {
            mapped.addAll(m.getMappedTikaProperties());
        }
        this.optional = Arrays.asList(optional);
        if (this.optional.contains(null)) {
            throw new IllegalArgumentException("Tha parsed Array of optional sub mappings MUST NOT contain a NULL element(parsed: " + this.optional + ")");
        }
        for (Mapping m : this.optional) {
            mapped.addAll(m.getMappedTikaProperties());
        }
        mapped.remove(null);
        this.mappedTikaProperties = Collections.unmodifiableSet(mapped);
        this.additional = additional != null ? Arrays.asList(additional) : Collections.emptySet();
        if (this.additional.contains(null)) {
            throw new IllegalArgumentException("Tha parsed Array of additional sub mappings MUST NOT contain a NULL element(parsed: " + this.additional + ")");
        }
    }

    @Override
    public boolean apply(MGraph graph, NonLiteral subject, Metadata metadata) {
        boolean added = false;
        BNode s = new BNode();
        mappingLogger.log(subject, this.ontProperty, null, (Resource)s);
        if (!this.required.isEmpty()) {
            SimpleMGraph g = new SimpleMGraph();
            for (Mapping m : this.required) {
                if (m.apply((MGraph)g, (NonLiteral)s, metadata)) continue;
                return false;
            }
            graph.addAll((Collection)g);
            added = true;
        }
        for (Mapping m : this.optional) {
            if (!m.apply(graph, (NonLiteral)s, metadata)) continue;
            added = true;
        }
        if (added) {
            for (Mapping m : this.additional) {
                m.apply(graph, (NonLiteral)s, metadata);
            }
            graph.add((Object)new TripleImpl(subject, this.ontProperty, (Resource)s));
        }
        return added;
    }

    @Override
    public Set<String> getMappedTikaProperties() {
        return this.mappedTikaProperties;
    }
}

