/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.tika.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.stanbol.enhancer.engines.tika.metadata.Mapping;
import org.apache.tika.metadata.Metadata;

public final class PropertyMapping
extends Mapping {
    protected final Set<String> tikaProperties;

    public PropertyMapping(String ontProperty, UriRef ontType, String ... tikaProperties) {
        this(ontProperty == null ? null : new UriRef(ontProperty), ontType, tikaProperties);
    }

    public PropertyMapping(String ontProperty, UriRef ontType, Mapping.Converter converter, String ... tikaProperties) {
        this(ontProperty == null ? null : new UriRef(ontProperty), ontType, converter, tikaProperties);
    }

    public PropertyMapping(String ontProperty, String ... tikaProperties) {
        this(ontProperty == null ? null : new UriRef(ontProperty), (UriRef)null, tikaProperties);
    }

    public PropertyMapping(UriRef ontProperty, String ... tikaProperties) {
        this(ontProperty, (UriRef)null, tikaProperties);
    }

    public PropertyMapping(UriRef ontProperty, UriRef ontType, String ... tikaProperties) {
        this(ontProperty, ontType, (Mapping.Converter)null, tikaProperties);
    }

    public PropertyMapping(UriRef ontProperty, UriRef ontType, Mapping.Converter converter, String ... tikaProperties) {
        super(ontProperty, ontType, converter);
        if (tikaProperties == null || tikaProperties.length < 1) {
            throw new IllegalArgumentException("The list of parsed Tika properties MUST NOT be NULL nor empty!");
        }
        this.tikaProperties = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(tikaProperties)));
        if (this.tikaProperties.contains(null) || this.tikaProperties.contains("")) {
            throw new IllegalArgumentException("Teh parsed list of Tika properties MUST NOT contain NULL or empty members (parsed: " + Arrays.toString(tikaProperties) + ")!");
        }
    }

    @Override
    public boolean apply(MGraph graph, NonLiteral subject, Metadata metadata) {
        HashSet<Resource> values = new HashSet<Resource>();
        for (String tikaProperty : this.tikaProperties) {
            String[] tikaPropValues = metadata.getValues(tikaProperty);
            if (tikaPropValues == null || tikaPropValues.length <= 0) continue;
            for (String tikaPropValue : tikaPropValues) {
                Resource resource = this.toResource(tikaPropValue, true);
                if (resource == null) continue;
                values.add(resource);
                mappingLogger.log(subject, this.ontProperty, tikaProperty, resource);
            }
        }
        values.remove(null);
        values.remove("");
        if (values.isEmpty()) {
            return false;
        }
        for (Resource resource : values) {
            graph.add((Object)new TripleImpl(subject, this.ontProperty, resource));
        }
        return true;
    }

    @Override
    public Set<String> getMappedTikaProperties() {
        return this.tikaProperties;
    }
}

