/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.tika.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.ontologies.OWL;
import org.apache.clerezza.rdf.ontologies.RDFS;
import org.apache.clerezza.rdf.ontologies.SKOS;
import org.apache.clerezza.rdf.ontologies.XSD;
import org.apache.stanbol.enhancer.engines.tika.metadata.Mapping;
import org.apache.stanbol.enhancer.engines.tika.metadata.PropertyMapping;
import org.apache.stanbol.enhancer.engines.tika.metadata.ResourceMapping;
import org.apache.stanbol.enhancer.engines.tika.metadata.TypeMapping;
import org.apache.stanbol.enhancer.servicesapi.rdf.NamespaceEnum;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Geographic;
import org.apache.tika.metadata.MSOffice;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.metadata.XMPDM;

public class OntologyMappings
implements Iterable<Mapping> {
    private static OntologyMappings defaultMappings;
    private final Map<UriRef, Collection<Mapping>> mappings = new HashMap<UriRef, Collection<Mapping>>();
    private boolean readonly = false;
    private static String ma;

    public static OntologyMappings getDefaultMappings() {
        if (defaultMappings == null) {
            defaultMappings = new OntologyMappings();
            OntologyMappings.addMediaResourceOntologyMappings(defaultMappings);
            OntologyMappings.addNepomukMessageMappings(defaultMappings);
            OntologyMappings.addRdfsMappings(defaultMappings);
        }
        return defaultMappings;
    }

    public static void addNepomukMessageMappings(OntologyMappings mappings) {
        String nmo = "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#";
        mappings.addMappings(new PropertyMapping(nmo + "bbc", "Message-Bcc"));
        mappings.addMappings(new PropertyMapping(nmo + "cc", "Message-Cc"));
        mappings.addMappings(new PropertyMapping(nmo + "from", "Message-From"));
        mappings.addMappings(new PropertyMapping(nmo + "to", "Message-To"));
    }

    public static void addGeoMappings(OntologyMappings mappings) {
        mappings.addMappings(new PropertyMapping(NamespaceEnum.geo + "alt", XSD.double_, Geographic.ALTITUDE.getName()));
        mappings.addMappings(new PropertyMapping(NamespaceEnum.geo + "lat", XSD.double_, Geographic.LATITUDE.getName()));
        mappings.addMappings(new PropertyMapping(NamespaceEnum.geo + "long", XSD.double_, Geographic.LONGITUDE.getName()));
    }

    public static void addNepomukExifMappings(OntologyMappings mappings) {
        String exif = "http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#";
        mappings.addMappings(new PropertyMapping(exif + "bitsPerSample", XSD.int_, TIFF.BITS_PER_SAMPLE.getName()));
        mappings.addMappings(new PropertyMapping(exif + "make", TIFF.EQUIPMENT_MAKE.getName()));
        mappings.addMappings(new PropertyMapping(exif + "model", TIFF.EQUIPMENT_MODEL.getName()));
        mappings.addMappings(new PropertyMapping(exif + "exposureTime", XSD.double_, TIFF.EXPOSURE_TIME.getName()));
        mappings.addMappings(new PropertyMapping(exif + "fNumber", XSD.double_, TIFF.F_NUMBER.getName()));
        mappings.addMappings(new PropertyMapping(exif + "flash", XSD.boolean_, TIFF.FLASH_FIRED.getName()));
        mappings.addMappings(new PropertyMapping(exif + "focalLength", XSD.double_, TIFF.FOCAL_LENGTH.getName()));
        mappings.addMappings(new PropertyMapping(exif + "relatedImageLength", XSD.int_, TIFF.IMAGE_LENGTH.getName()));
        mappings.addMappings(new PropertyMapping(exif + "relatedImageWidth", XSD.int_, TIFF.IMAGE_WIDTH.getName()));
        mappings.addMappings(new PropertyMapping(exif + "isoSpeedRatings", XSD.int_, TIFF.ISO_SPEED_RATINGS.getName()));
        mappings.addMappings(new PropertyMapping(exif + "orientation", XSD.string, TIFF.ORIENTATION.getName()));
        mappings.addMappings(new PropertyMapping(exif + "dateTimeOriginal", XSD.dateTime, TIFF.ORIGINAL_DATE.getName()));
        mappings.addMappings(new PropertyMapping(exif + "xResolution", XSD.double_, TIFF.RESOLUTION_HORIZONTAL.getName()));
        mappings.addMappings(new PropertyMapping(exif + "resolutionUnit", XSD.string, TIFF.RESOLUTION_UNIT.getName()));
        mappings.addMappings(new PropertyMapping(exif + "yResolution", XSD.double_, TIFF.RESOLUTION_VERTICAL.getName()));
        mappings.addMappings(new PropertyMapping(exif + "samplesPerPixel", XSD.int_, TIFF.SAMPLES_PER_PIXEL.getName()));
        mappings.addMappings(new PropertyMapping(exif + "software", TIFF.SOFTWARE.getName()));
    }

    public static void addDcMappings(OntologyMappings mappings) {
        String dc = NamespaceEnum.dc.getNamespace();
        mappings.addMapping(new PropertyMapping(dc + "contributor", DublinCore.CONTRIBUTOR.getName(), "Last-Author"));
        mappings.addMapping(new PropertyMapping(dc + "coverage", DublinCore.COVERAGE.getName()));
        mappings.addMappings(new PropertyMapping(dc + "creator", DublinCore.CREATOR.getName(), "Author", "initial-creator"));
        mappings.addMappings(new PropertyMapping(dc + "description", DublinCore.DESCRIPTION.getName()));
        mappings.addMappings(new PropertyMapping(dc + "format", DublinCore.FORMAT.getName(), "Content-Type"));
        mappings.addMappings(new PropertyMapping(dc + "identifier", DublinCore.IDENTIFIER.getName()));
        mappings.addMappings(new PropertyMapping(dc + "language", DublinCore.LANGUAGE.getName(), "Content-Language"));
        mappings.addMappings(new PropertyMapping(dc + "modified", XSD.dateTime, DublinCore.MODIFIED.getName(), "Last-Modified"));
        mappings.addMappings(new PropertyMapping(dc + "publisher", DublinCore.PUBLISHER.getName(), "Company"));
        mappings.addMappings(new PropertyMapping(dc + "relation", DublinCore.RELATION.getName()));
        mappings.addMappings(new PropertyMapping(dc + "rights", DublinCore.RIGHTS.getName()));
        mappings.addMappings(new PropertyMapping(dc + "source", DublinCore.SOURCE.getName()));
        mappings.addMappings(new PropertyMapping(dc + "subject", DublinCore.SUBJECT.getName(), "Keywords"));
        mappings.addMappings(new PropertyMapping(dc + "title", DublinCore.TITLE.getName()));
        mappings.addMappings(new PropertyMapping(dc + "type", DublinCore.TYPE.getName()));
        mappings.addMappings(new PropertyMapping(dc + "date", XSD.dateTime, DublinCore.DATE.getName()));
        mappings.addMappings(new PropertyMapping(NamespaceEnum.dc + "created", XSD.dateTime, MSOffice.CREATION_DATE.getName(), "created"));
    }

    public static void addMediaResourceOntologyMappings(OntologyMappings mappings) {
        mappings.addMappings(new PropertyMapping(ma + "hasContributor", DublinCore.CONTRIBUTOR.getName(), XMPDM.ARTIST.getName(), XMPDM.COMPOSER.getName()));
        mappings.addMapping(new ResourceMapping(ma + "hasLocation", new TypeMapping(ma + "Location"), new PropertyMapping(ma + "locationName", DublinCore.COVERAGE.getName())));
        mappings.addMappings(new PropertyMapping(ma + "hasCreator", DublinCore.CREATOR.getName(), "Author", "initial-creator"));
        mappings.addMappings(new PropertyMapping(ma + "description", DublinCore.DESCRIPTION.getName()));
        mappings.addMappings(new PropertyMapping(ma + "hasFormat", DublinCore.FORMAT.getName(), "Content-Type"));
        mappings.addMappings(new PropertyMapping(OWL.sameAs, RDFS.Resource, DublinCore.IDENTIFIER.getName()));
        mappings.addMappings(new PropertyMapping(ma + "hasLanguage", DublinCore.LANGUAGE.getName(), "Content-Language"));
        mappings.addMappings(new PropertyMapping(ma + "editDate", XSD.dateTime, DublinCore.MODIFIED.getName(), MSOffice.LAST_SAVED.getName()));
        mappings.addMappings(new PropertyMapping(ma + "hasPublisher", DublinCore.PUBLISHER.getName()));
        mappings.addMappings(new PropertyMapping(ma + "hasRelatedResource", DublinCore.RELATION.getName()));
        mappings.addMappings(new PropertyMapping(ma + "copyright", RDFS.Resource, DublinCore.RIGHTS.getName(), "License-Location", "License-Url", XMPDM.COPYRIGHT.getName()));
        mappings.addMappings(new PropertyMapping(ma + "isMemberOf", DublinCore.SOURCE.getName()));
        mappings.addMappings(new PropertyMapping(ma + "hasKeyword", DublinCore.SUBJECT.getName(), "Keywords"));
        mappings.addMappings(new PropertyMapping(ma + "title", DublinCore.TITLE.getName(), XMPDM.SCENE.getName(), XMPDM.TAPE_NAME.getName(), XMPDM.SHOT_NAME.getName()));
        mappings.addMapping(new PropertyMapping(ma + "alternativeTitle", XMPDM.ALT_TAPE_NAME.getName()));
        mappings.addMapping(new PropertyMapping(ma + "mainOriginalTitle", XMPDM.ALBUM.getName()));
        mappings.addMappings(new PropertyMapping(ma + "hasGenre", DublinCore.TYPE.getName(), XMPDM.GENRE.getName()));
        mappings.addMappings(new PropertyMapping(ma + "creationDate", XSD.dateTime, DublinCore.DATE.getName(), MSOffice.CREATION_DATE.getName(), "created"));
        mappings.addMapping(new PropertyMapping(ma + "description", DublinCore.DESCRIPTION.getName(), "Comments"));
        mappings.addMappings(new PropertyMapping(ma + "hasContributor", "Last-Author", "Author", XMPDM.ENGINEER.getName()));
        mappings.addMappings(new PropertyMapping(ma + "hasCreator", "producer", "initial-creator"));
        mappings.addMappings(new PropertyMapping(ma + "frameHeight", XSD.int_, TIFF.IMAGE_LENGTH.getName()));
        mappings.addMappings(new PropertyMapping(ma + "frameWidth", XSD.int_, TIFF.IMAGE_WIDTH.getName()));
        mappings.addMappings(new PropertyMapping(ma + "creationDate", XSD.dateTime, TIFF.ORIGINAL_DATE.getName(), XMPDM.SHOT_DATE.getName()));
        mappings.addMapping(new PropertyMapping(ma + "releaseDate", XSD.dateTime, XMPDM.RELEASE_DATE.getName()));
        mappings.addMapping(new ResourceMapping(ma + "hasTrack", new Mapping[0], new Mapping[]{new PropertyMapping(ma + "hasFormat", XSD.string, XMPDM.AUDIO_CHANNEL_TYPE.getName()), new PropertyMapping(ma + "hasCompression", XSD.string, XMPDM.AUDIO_COMPRESSOR.getName()), new PropertyMapping(ma + "editDate", XMPDM.AUDIO_MOD_DATE.getName()), new PropertyMapping(ma + "samplingRate", XSD.int_, XMPDM.AUDIO_SAMPLE_RATE.getName())}, new Mapping[]{new TypeMapping(ma + "MediaFragment"), new TypeMapping(ma + "Track"), new TypeMapping(ma + "AudioTrack")}));
        mappings.addMapping(new ResourceMapping(ma + "hasTrack", new Mapping[0], new Mapping[]{new PropertyMapping(ma + "hasCompression", XSD.string, XMPDM.VIDEO_COMPRESSOR.getName()), new PropertyMapping(ma + "editDate", XMPDM.VIDEO_MOD_DATE.getName()), new PropertyMapping(ma + "frameRate", XSD.double_, XMPDM.VIDEO_FRAME_RATE.getName())}, new Mapping[]{new TypeMapping(ma + "MediaFragment"), new TypeMapping(ma + "Track"), new TypeMapping(ma + "VideoTrack"), new PropertyMapping(ma + "frameHeight", XSD.int_, TIFF.IMAGE_LENGTH.getName()), new PropertyMapping(ma + "frameWidth", XSD.int_, TIFF.IMAGE_WIDTH.getName())}));
        mappings.addMapping(new PropertyMapping(ma + "numberOfTracks", XSD.int_, XMPDM.TRACK_NUMBER.getName()));
        mappings.addMapping(new PropertyMapping(ma + "averageBitRate", XSD.double_, new Mapping.Converter(){

            @Override
            public Resource convert(Resource value) {
                if (value instanceof TypedLiteral && XSD.double_.equals((Object)((TypedLiteral)value).getDataType())) {
                    LiteralFactory lf = LiteralFactory.getInstance();
                    double mm = (Double)lf.createObject(Double.class, (TypedLiteral)value);
                    return lf.createTypedLiteral((Object)(mm * 1024.0 / 60.0));
                }
                return value;
            }
        }, XMPDM.FILE_DATA_RATE.getName()));
        mappings.addMapping(new ResourceMapping(ma + "hasLocation", new Mapping[]{new PropertyMapping(ma + "locationLatitude", XSD.double_, Geographic.LATITUDE.getName()), new PropertyMapping(ma + "locationLongitude", XSD.double_, Geographic.LONGITUDE.getName())}, new Mapping[]{new PropertyMapping(ma + "locationAltitude", XSD.double_, Geographic.ALTITUDE.getName())}, new Mapping[]{new TypeMapping(ma + "Location")}));
    }

    public static void addSkosMappings(OntologyMappings mappings) {
        mappings.addMappings(new PropertyMapping(SKOS.prefLabel, DublinCore.TITLE.getName()));
        mappings.addMappings(new PropertyMapping(SKOS.definition, DublinCore.DESCRIPTION.getName()));
        mappings.addMappings(new PropertyMapping(SKOS.notation, DublinCore.IDENTIFIER.getName()));
        mappings.addMappings(new PropertyMapping(SKOS.note, "Comments"));
        mappings.addMappings(new PropertyMapping(SKOS.editorialNote, "Notes", XMPDM.LOG_COMMENT.getName()));
    }

    public static void addRdfsMappings(OntologyMappings mappings) {
        mappings.addMappings(new PropertyMapping(RDFS.label, DublinCore.TITLE.getName()));
        mappings.addMappings(new PropertyMapping(RDFS.comment, DublinCore.DESCRIPTION.getName(), "Comments"));
    }

    public static void addCreativeCommonsMappings(OntologyMappings mappings) {
        mappings.addMapping(new PropertyMapping("http://creativecommons.org/ns#license", RDFS.Resource, "License-Url", "License-Location"));
    }

    public void addMappings(Mapping ... mappings) {
        if (mappings == null || mappings.length > 1) {
            return;
        }
        for (Mapping m : mappings) {
            this.addMapping(m);
        }
    }

    public void addMapping(Mapping mapping) {
        if (this.readonly) {
            throw new IllegalStateException("This " + this.getClass().getSimpleName() + " instance is read only!");
        }
        if (mapping == null) {
            return;
        }
        Collection<Mapping> propMappings = this.mappings.get(mapping.getOntologyProperty());
        if (propMappings == null) {
            propMappings = new HashSet<Mapping>();
            this.mappings.put(mapping.getOntologyProperty(), propMappings);
        }
        propMappings.add(mapping);
    }

    public void removePropertyMappings(UriRef property) {
        if (this.readonly) {
            throw new IllegalStateException("This " + this.getClass().getSimpleName() + " instance is read only!");
        }
        this.mappings.remove(property);
    }

    public void apply(MGraph graph, UriRef context, Metadata metadata) {
        HashSet<String> keys = new HashSet<String>(Arrays.asList(metadata.names()));
        for (Mapping mapping : this) {
            if (!mapping.getMappedTikaProperties().isEmpty() && Collections.disjoint(keys, mapping.getMappedTikaProperties())) continue;
            mapping.apply(graph, (NonLiteral)context, metadata);
        }
    }

    @Override
    public Iterator<Mapping> iterator() {
        return new Iterator<Mapping>(){
            Iterator<Collection<Mapping>> mappingsIt;
            Iterator<Mapping> mappingIt;
            {
                this.mappingsIt = OntologyMappings.this.mappings.values().iterator();
                this.mappingIt = Collections.EMPTY_LIST.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mappingIt.hasNext() || this.mappingsIt.hasNext();
            }

            @Override
            public Mapping next() {
                if (!this.mappingIt.hasNext()) {
                    this.mappingIt = this.mappingsIt.next().iterator();
                }
                return this.mappingIt.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal not Supported!");
            }
        };
    }

    static {
        ma = "http://www.w3.org/ns/ma-ont#";
    }
}

