/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.tika.metadata;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.rdf.core.InvalidLiteralTypeException;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NoConvertorException;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.PlainLiteralImpl;
import org.apache.clerezza.rdf.core.impl.TypedLiteralImpl;
import org.apache.clerezza.rdf.ontologies.RDFS;
import org.apache.clerezza.rdf.ontologies.XSD;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Mapping {
    private static final Logger log = LoggerFactory.getLogger(Mapping.class);
    private static final LiteralFactory lf = LiteralFactory.getInstance();
    public static final Set<UriRef> ONT_TYPES;
    protected static final Map<UriRef, Class<?>> ONT_TYPE_MAP;
    protected final UriRef ontProperty;
    protected final Converter converter;
    protected final UriRef ontType;
    protected static final MappingLogger mappingLogger;

    public final UriRef getOntologyProperty() {
        return this.ontProperty;
    }

    public abstract Set<String> getMappedTikaProperties();

    protected Mapping(UriRef ontProperty, UriRef ontType) {
        this(ontProperty, ontType, null);
    }

    protected Mapping(UriRef ontProperty, UriRef ontType, Converter converter) {
        if (ontProperty == null) {
            throw new IllegalArgumentException("The parsed ontology property MUST NOT be NULL!");
        }
        this.ontProperty = ontProperty;
        if (!ONT_TYPES.contains(ontType)) {
            throw new IllegalArgumentException("The ontology type '" + ontType + "' is not supported. (supported: " + ONT_TYPES + ")");
        }
        this.ontType = ontType;
        this.converter = converter;
    }

    public abstract boolean apply(MGraph var1, NonLiteral var2, Metadata var3);

    protected Resource toResource(String value, boolean validate) {
        Object object;
        Metadata dummy = null;
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (this.ontType == null) {
            object = new PlainLiteralImpl(value);
        } else if (this.ontType == RDFS.Resource) {
            try {
                if (validate) {
                    new URI(value);
                }
                object = new UriRef(value);
            }
            catch (URISyntaxException e) {
                log.warn("Unable to create Reference for value {} (not a valid URI) -> create a literal instead", (Object)value);
                object = new PlainLiteralImpl(value);
            }
        } else {
            Class<?> clazz = ONT_TYPE_MAP.get(this.ontType);
            if (clazz.equals(Date.class)) {
                if (dummy == null) {
                    dummy = new Metadata();
                }
                dummy.add(DublinCore.DATE.getName(), value);
                Date date = dummy.getDate(DublinCore.DATE);
                object = date != null ? lf.createTypedLiteral((Object)date) : new TypedLiteralImpl(value, XSD.string);
            } else {
                object = new TypedLiteralImpl(value, this.ontType);
            }
            if (validate && clazz != null && !clazz.equals(Date.class)) {
                try {
                    lf.createObject(clazz, (TypedLiteral)object);
                }
                catch (NoConvertorException e) {
                    log.info("Unable to validate typed literals of type {} becausethere is no converter for Class {} registered with Clerezza", (Object)this.ontType, clazz);
                }
                catch (InvalidLiteralTypeException e) {
                    log.info("The value '{}' is not valid for dataType {}!create literal with type 'xsd:string' instead", (Object)value, (Object)this.ontType);
                    object = new TypedLiteralImpl(value, XSD.string);
                }
            }
        }
        if (this.converter != null) {
            object = this.converter.convert((Resource)object);
        }
        return object;
    }

    static {
        LinkedHashMap map = new LinkedHashMap();
        map.put(null, null);
        map.put(XSD.anyURI, URI.class);
        map.put(XSD.base64Binary, new byte[0].getClass());
        map.put(XSD.boolean_, Boolean.class);
        map.put(XSD.byte_, Byte.class);
        map.put(XSD.date, Date.class);
        map.put(XSD.dateTime, Date.class);
        map.put(XSD.decimal, BigDecimal.class);
        map.put(XSD.double_, Double.class);
        map.put(XSD.float_, Float.class);
        map.put(XSD.int_, Integer.class);
        map.put(XSD.integer, BigInteger.class);
        map.put(XSD.long_, Long.class);
        map.put(XSD.short_, Short.class);
        map.put(XSD.string, String.class);
        map.put(XSD.time, Date.class);
        map.put(RDFS.Resource, URI.class);
        ONT_TYPE_MAP = Collections.unmodifiableMap(map);
        ONT_TYPES = ONT_TYPE_MAP.keySet();
        mappingLogger = new MappingLogger();
    }

    public static interface Converter {
        public Resource convert(Resource var1);
    }

    protected static class MappingLogger {
        private List<NonLiteral> subjects = new ArrayList<NonLiteral>();
        private UriRef predicate;
        private final int intendSize = 2;
        private final char[] intnedArray = new char[10];
        private static final int MAX_INTEND = 5;

        private MappingLogger() {
            Arrays.fill(this.intnedArray, ' ');
        }

        private String getIntend(int intend) {
            return String.copyValueOf(this.intnedArray, 0, Math.min(5, intend) * 2);
        }

        protected void log(NonLiteral subject, UriRef predicate, String prop, Resource object) {
            String intend;
            if (!log.isDebugEnabled()) {
                return;
            }
            int intendCount = this.subjects.indexOf(subject) + 1;
            if (intendCount < 1) {
                this.subjects.add(subject);
                intendCount = this.subjects.size();
                intend = this.getIntend(intendCount);
                log.debug("{}context: {}", (Object)intend, (Object)subject);
            } else if (intendCount < this.subjects.size()) {
                for (int i = intendCount; i < this.subjects.size(); ++i) {
                    this.subjects.remove(i);
                }
                intend = this.getIntend(intendCount);
            } else {
                intend = this.getIntend(intendCount);
            }
            if (!predicate.equals((Object)this.predicate)) {
                log.debug("{}  {}", (Object)intend, (Object)predicate);
            }
            log.debug("{}    {} {}", new Object[]{intend, object, prop != null ? "(from: '" + prop + ')' : ""});
        }
    }
}

