/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.tika.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.stanbol.enhancer.engines.tika.metadata.Mapping;
import org.apache.tika.metadata.Metadata;

public class ConstantMapping
extends Mapping {
    private Collection<Resource> values;

    public ConstantMapping(UriRef ontProperty, Resource ... values) {
        super(ontProperty, null);
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("The parsed values MUST NOT be NULL nor an empty array");
        }
        this.values = Arrays.asList(values);
        if (this.values.contains(null)) {
            throw new IllegalArgumentException("The parsed values MUST NOT contain a NULL element (parsed: " + this.values + ")!");
        }
    }

    @Override
    public boolean apply(MGraph graph, NonLiteral subject, Metadata metadata) {
        for (Resource value : this.values) {
            graph.add((Object)new TripleImpl(subject, this.ontProperty, value));
            mappingLogger.log(subject, this.ontProperty, null, value);
        }
        return true;
    }

    @Override
    public Set<String> getMappedTikaProperties() {
        return Collections.emptySet();
    }
}

