/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engines.tika.handler;

import java.io.Writer;
import org.apache.tika.sax.ToTextContentHandler;
import org.xml.sax.SAXException;

public class PlainTextHandler
extends ToTextContentHandler {
    private static char[] SPACE = new char[]{' '};
    private final boolean skipWhitespaces;
    private final boolean skipLinebreakes;
    boolean addedText = false;

    public PlainTextHandler(Writer writer, boolean skipIgnoreableWhitespaces, boolean skipLinebreaksWithinLiterals) {
        super(writer);
        this.skipWhitespaces = skipIgnoreableWhitespaces;
        this.skipLinebreakes = skipLinebreaksWithinLiterals;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.skipWhitespaces && this.addedText) {
            super.characters(ch, start, length);
            this.addedText = false;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.skipLinebreakes) {
            int end = start + length;
            for (int pos = start; pos < end; ++pos) {
                if (ch[pos] != '\n') continue;
                if (pos > start) {
                    super.characters(ch, start, pos - start);
                    super.characters(SPACE, 0, 1);
                }
                start = pos + 1;
                length -= start;
            }
        }
        if (length > 0) {
            super.characters(ch, start, length);
        }
        this.addedText = true;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
    }
}

