/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.topic.training;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferenceStrategy;
import org.apache.felix.scr.annotations.Service;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.stanbol.commons.solr.managed.ManagedSolrServer;
import org.apache.stanbol.enhancer.topic.ConfiguredSolrCoreTracker;
import org.apache.stanbol.enhancer.topic.UTCTimeStamper;
import org.apache.stanbol.enhancer.topic.api.Batch;
import org.apache.stanbol.enhancer.topic.api.training.Example;
import org.apache.stanbol.enhancer.topic.api.training.TrainingSet;
import org.apache.stanbol.enhancer.topic.api.training.TrainingSetException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service
@Properties(value={@Property(name="org.apache.stanbol.enhancer.topic.trainingset.id"), @Property(name="org.apache.stanbol.enhancer.engine.topic.solrCore"), @Property(name="org.apache.stanbol.enhancer.engine.topic.solrCoreConfig", value={"default-topic-trainingset.solrindex.zip"})})
public class SolrTrainingSet
extends ConfiguredSolrCoreTracker
implements TrainingSet {
    public static final String TRAINING_SET_NAME = "org.apache.stanbol.enhancer.topic.trainingset.id";
    public static final String SOLR_CORE = "org.apache.stanbol.enhancer.engine.topic.solrCore";
    public static final String SOLR_CORE_CONFIG = "org.apache.stanbol.enhancer.engine.topic.solrCoreConfig";
    public static final String DEFAULT_SOLR_CORE_CONFIG = "default-topic-trainingset.solrindex.zip";
    public static final String TOPICS_URI_FIELD = "org.apache.stanbol.enhancer.engine.topic.topicsUriField";
    public static final String DEFAULT_TOPICS_URI_FIELD = "topics";
    public static final String EXAMPLE_ID_FIELD = "org.apache.stanbol.enhancer.engine.topic.exampleIdField";
    public static final String DEFAULT_EXAMPLE_ID_FIELD = "id";
    public static final String EXAMPLE_TEXT_FIELD = "org.apache.stanbol.enhancer.engine.topic.exampleTextField";
    public static final String DEFAULT_EXAMPLE_TEXT_FIELD = "text";
    public static final String MODIFICATION_DATE_FIELD = "org.apache.stanbol.enhancer.engine.topic.modificiationDateField";
    public static final String DEFAULT_MODIFICATION_DATE_FIELD = "modification_dt";
    private static final Logger log = LoggerFactory.getLogger(SolrTrainingSet.class);
    protected String trainingSetId;
    protected String exampleIdField;
    protected String exampleTextField;
    protected String topicUrisField;
    protected String modificationDateField;
    protected int batchSize = 100;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, bind="bindManagedSolrServer", unbind="unbindManagedSolrServer", strategy=ReferenceStrategy.EVENT, policy=ReferencePolicy.DYNAMIC)
    protected ManagedSolrServer managedSolrServer;

    public String getName() {
        return this.trainingSetId;
    }

    @Activate
    protected void activate(ComponentContext context) throws ConfigurationException, InvalidSyntaxException {
        Dictionary config = context.getProperties();
        this.context = context;
        this.configure(config);
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        if (this.indexTracker != null) {
            this.indexTracker.close();
        }
    }

    @Override
    public void configure(Dictionary<String, Object> config) throws ConfigurationException {
        this.trainingSetId = this.getRequiredStringParam(config, TRAINING_SET_NAME);
        this.exampleIdField = this.getRequiredStringParam(config, EXAMPLE_ID_FIELD, DEFAULT_EXAMPLE_ID_FIELD);
        this.exampleTextField = this.getRequiredStringParam(config, EXAMPLE_TEXT_FIELD, DEFAULT_EXAMPLE_TEXT_FIELD);
        this.topicUrisField = this.getRequiredStringParam(config, TOPICS_URI_FIELD, DEFAULT_TOPICS_URI_FIELD);
        this.modificationDateField = this.getRequiredStringParam(config, MODIFICATION_DATE_FIELD, DEFAULT_MODIFICATION_DATE_FIELD);
        this.configureSolrCore(config, SOLR_CORE, this.trainingSetId, SOLR_CORE_CONFIG);
    }

    public static ConfiguredSolrCoreTracker fromParameters(Dictionary<String, Object> config) throws ConfigurationException {
        SolrTrainingSet engine = new SolrTrainingSet();
        ((ConfiguredSolrCoreTracker)engine).configure(config);
        return engine;
    }

    public boolean isUpdatable() {
        return true;
    }

    public String registerExample(String exampleId, String text, List<String> topics) throws TrainingSetException {
        if (text == null) {
            if (exampleId == null) {
                throw new IllegalArgumentException("exampleId and text should not be null simultaneously");
            }
            SolrServer solrServer = this.getActiveSolrServer();
            try {
                solrServer.deleteByQuery(this.exampleIdField + ":" + exampleId);
                solrServer.commit();
                return exampleId;
            }
            catch (Exception e) {
                String msg = String.format("Error deleting example with id '%s' on Solr Core '%s'", exampleId, this.solrCoreId);
                throw new TrainingSetException(msg, (Throwable)e);
            }
        }
        if (exampleId == null || exampleId.isEmpty()) {
            exampleId = UUID.randomUUID().toString();
        }
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField(this.exampleIdField, (Object)exampleId);
        doc.addField(this.exampleTextField, (Object)text);
        if (topics != null) {
            doc.addField(this.topicUrisField, topics);
        }
        doc.addField(this.modificationDateField, (Object)UTCTimeStamper.nowUtcDate());
        SolrServer server = this.getActiveSolrServer();
        try {
            server.add(doc);
            server.commit();
        }
        catch (Exception e) {
            String msg = String.format("Could not register example '%s' with topics: ['%s']", exampleId, StringUtils.join(topics, (String)"', '"));
            throw new TrainingSetException(msg, (Throwable)e);
        }
        return exampleId;
    }

    public boolean hasChangedSince(List<String> topics, Date referenceDate) throws TrainingSetException {
        String utcIsoDate = UTCTimeStamper.utcIsoString(referenceDate);
        StringBuffer sb = new StringBuffer();
        sb.append(this.modificationDateField);
        sb.append(":[");
        sb.append(utcIsoDate);
        sb.append(" TO *]");
        if (topics != null && topics.size() > 0) {
            sb.append(" AND (");
            ArrayList<String> parts = new ArrayList<String>();
            for (String topic : topics) {
                parts.add(this.topicUrisField + ":" + ClientUtils.escapeQueryChars((String)topic));
            }
            sb.append(StringUtils.join(parts, (String)" OR "));
            sb.append(")");
        }
        SolrQuery query = new SolrQuery(sb.toString());
        query.setRows(Integer.valueOf(1));
        query.setFields(new String[]{this.exampleIdField});
        try {
            SolrServer solrServer = this.getActiveSolrServer();
            return solrServer.query((SolrParams)query).getResults().size() > 0;
        }
        catch (SolrServerException e) {
            String msg = String.format("Error while fetching topics for examples modified after '%s' on Solr Core '%s'.", utcIsoDate, this.solrCoreId);
            throw new TrainingSetException(msg, (Throwable)e);
        }
    }

    public Batch<Example> getPositiveExamples(List<String> topics, Object offset) throws TrainingSetException {
        return this.getExamples(topics, offset, true);
    }

    public Batch<Example> getNegativeExamples(List<String> topics, Object offset) throws TrainingSetException {
        return this.getExamples(topics, offset, false);
    }

    protected Batch<Example> getExamples(List<String> topics, Object offset, boolean positive) throws TrainingSetException {
        ArrayList<Example> items = new ArrayList<Example>();
        SolrServer solrServer = this.getActiveSolrServer();
        SolrQuery query = new SolrQuery();
        ArrayList<String> parts = new ArrayList<String>();
        String q = "";
        if (topics.isEmpty()) {
            q = q + "*:*";
        } else if (positive) {
            for (String topic : topics) {
                parts.add(this.topicUrisField + ":" + ClientUtils.escapeQueryChars((String)topic));
            }
            if (offset != null) {
                q = q + "(";
            }
            q = q + StringUtils.join(parts, (String)" OR ");
            if (offset != null) {
                q = q + ")";
            }
        } else {
            for (String topic : topics) {
                parts.add("-" + this.topicUrisField + ":" + ClientUtils.escapeQueryChars((String)topic));
            }
            q = q + StringUtils.join(parts, (String)" AND ");
        }
        if (offset != null) {
            q = q + " AND " + this.exampleIdField + ":[" + offset.toString() + " TO *]";
        }
        query.setQuery(q);
        query.addSortField(this.exampleIdField, SolrQuery.ORDER.asc);
        query.set("rows", this.batchSize + 1);
        String nextExampleId = null;
        try {
            int count = 0;
            QueryResponse response = solrServer.query((SolrParams)query);
            for (SolrDocument result : response.getResults()) {
                if (count == this.batchSize) {
                    nextExampleId = result.getFirstValue(this.exampleIdField).toString();
                    continue;
                }
                ++count;
                String exampleId = result.getFirstValue(this.exampleIdField).toString();
                Collection labelValues = result.getFieldValues(this.topicUrisField);
                Collection textValues = result.getFieldValues(this.exampleTextField);
                if (textValues == null) continue;
                items.add(new Example(exampleId, labelValues, textValues));
            }
        }
        catch (SolrServerException e) {
            String msg = String.format("Error while fetching positive examples for topics ['%s'] on Solr Core '%s'.", StringUtils.join(topics, (String)"', '"), this.solrCoreId);
            throw new TrainingSetException(msg, (Throwable)e);
        }
        return new Batch(items, nextExampleId != null, nextExampleId);
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void optimize() throws TrainingSetException {
        try {
            this.getActiveSolrServer().optimize();
        }
        catch (Exception e) {
            throw new TrainingSetException("Error optimizing training dataset " + this.getName(), (Throwable)e);
        }
    }
}

