/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.topic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.xml.sax.SAXException;

public class EmbeddedSolrHelper {
    public static EmbeddedSolrServer makeEmbeddedSolrServer(File rootFolder, String solrServerId, String coreId, String configName) throws IOException, ParserConfigurationException, SAXException {
        File solrFolder = new File(rootFolder, solrServerId);
        FileUtils.deleteQuietly((File)solrFolder);
        solrFolder.mkdir();
        File solrFile = new File(solrFolder, "solr.xml");
        InputStream is = EmbeddedSolrHelper.class.getResourceAsStream("/solr.xml");
        if (is == null) {
            throw new IllegalArgumentException("missing test solr.xml file");
        }
        IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(solrFile));
        File solrCoreFolder = new File(solrFolder, coreId);
        solrCoreFolder.mkdir();
        File solrConfFolder = new File(solrCoreFolder, "conf");
        solrConfFolder.mkdir();
        File schemaFile = new File(solrConfFolder, "schema.xml");
        is = EmbeddedSolrHelper.class.getResourceAsStream("/" + configName + "/conf/schema.xml");
        if (is == null) {
            throw new IllegalArgumentException("missing test schema.xml file");
        }
        IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(schemaFile));
        File solrConfigFile = new File(solrConfFolder, "solrconfig.xml");
        is = EmbeddedSolrHelper.class.getResourceAsStream("/" + configName + "/conf/solrconfig.xml");
        if (is == null) {
            throw new IllegalArgumentException("missing test solrconfig.xml file");
        }
        IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(solrConfigFile));
        SolrResourceLoader loader = new SolrResourceLoader(solrFolder.getAbsolutePath());
        CoreContainer coreContainer = new CoreContainer(loader);
        coreContainer.load();
        CoreDescriptor coreDescriptor = new CoreDescriptor(coreContainer, coreId, solrCoreFolder.getAbsolutePath());
        SolrCore core = coreContainer.create(coreDescriptor);
        coreContainer.register(coreId, core, true);
        return new EmbeddedSolrServer(coreContainer, coreId);
    }
}

