/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.topic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.stanbol.commons.solr.IndexReference;
import org.apache.stanbol.commons.solr.RegisteredSolrServerTracker;
import org.apache.stanbol.commons.solr.managed.IndexMetadata;
import org.apache.stanbol.commons.solr.managed.ManagedIndexState;
import org.apache.stanbol.commons.solr.managed.ManagedSolrServer;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class ConfiguredSolrCoreTracker {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ManagedSolrServer managedSolrServer;
    protected String solrCoreId;
    protected RegisteredSolrServerTracker indexTracker;
    protected SolrServer solrServer;
    protected ComponentContext context;
    protected String solrCoreConfig;

    public abstract void configure(Dictionary<String, Object> var1) throws ConfigurationException;

    protected String getRequiredStringParam(Dictionary<String, Object> parameters, String paramName) throws ConfigurationException {
        return this.getRequiredStringParam(parameters, paramName, null);
    }

    protected String getRequiredStringParam(Dictionary<String, Object> config, String paramName, String defaultValue) throws ConfigurationException {
        Object paramValue = config.get(paramName);
        if (paramValue == null) {
            if (defaultValue == null) {
                throw new ConfigurationException(paramName, paramName + " is a required parameter.");
            }
            return defaultValue;
        }
        return paramValue.toString();
    }

    protected List<String> getStringListParan(Dictionary<String, Object> config, String paramName) throws ConfigurationException {
        Object paramValue = config.get(paramName);
        if (paramValue == null) {
            return new ArrayList<String>();
        }
        if (paramValue instanceof String) {
            return Arrays.asList(paramValue.toString().split(",\\s*"));
        }
        if (paramValue instanceof String[]) {
            return Arrays.asList((String[])paramValue);
        }
        if (paramValue instanceof List) {
            return (List)paramValue;
        }
        throw new ConfigurationException(paramName, String.format("Unexpected parameter type for '%s': %s", paramName, paramValue));
    }

    public SolrServer getActiveSolrServer() {
        SolrServer result;
        if (this.solrServer != null) {
            result = this.solrServer;
        } else {
            result = this.indexTracker.getService();
            if (result == null) {
                for (int i = 0; i < 5 && result == null; ++i) {
                    try {
                        result = (SolrServer)this.indexTracker.waitForService(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (result == null) {
            if (this.solrCoreId != null) {
                throw new RuntimeException("No Solr Core registered with id: " + this.solrCoreId);
            }
            throw new RuntimeException("No Solr Core registered");
        }
        return result;
    }

    protected void configureSolrCore(Dictionary<String, Object> config, String solrCoreProperty, String defaultCoreId, String solrCoreConfigProperty) throws ConfigurationException {
        Object solrCoreInfo = config.get(solrCoreProperty);
        if (solrCoreInfo instanceof SolrServer) {
            this.solrServer = (SolrServer)config.get(solrCoreProperty);
            this.solrCoreConfig = "default-topic-model.solrindex.zip";
        } else {
            if (this.context == null) {
                throw new ConfigurationException(solrCoreProperty, solrCoreProperty + " should be a SolrServer instance for using" + " the engine without any OSGi context. Got: " + this.solrCoreId);
            }
            this.solrCoreId = solrCoreInfo != null && !solrCoreInfo.toString().trim().isEmpty() ? solrCoreInfo.toString().trim() : defaultCoreId;
            this.solrCoreConfig = this.getRequiredStringParam(config, solrCoreConfigProperty, this.solrCoreId + ".solrindex.zip");
            try {
                IndexReference indexReference = IndexReference.parse((String)this.solrCoreId);
                indexReference = this.checkInitSolrIndex(indexReference, this.solrCoreConfig);
                this.indexTracker = new RegisteredSolrServerTracker(this.context.getBundleContext(), indexReference);
                this.indexTracker.open();
            }
            catch (Exception e) {
                throw new ConfigurationException(solrCoreProperty, e.getMessage(), (Throwable)e);
            }
        }
    }

    protected IndexReference checkInitSolrIndex(IndexReference indexReference, String solrCoreConfig) throws IOException, ConfigurationException, SAXException {
        if (this.managedSolrServer != null && indexReference.checkServer(this.managedSolrServer.getServerName()) && this.context != null && solrCoreConfig != null) {
            IndexMetadata indexMetadata;
            this.log.info(" > check/init index {} on ManagedSolrServer {}", (Object)indexReference, (Object)this.managedSolrServer.getServerName());
            String indexName = indexReference.getIndex();
            ManagedIndexState indexState = this.managedSolrServer.getIndexState(indexName);
            if (indexState == null) {
                if (solrCoreConfig.indexOf(".solrindex.") < 0) {
                    solrCoreConfig = solrCoreConfig + ".solrindex.zip";
                }
                this.log.info("Create SolrCore {} (config: {}) on ManagedSolrServer {} ...", new Object[]{indexName, solrCoreConfig, this.managedSolrServer.getServerName()});
                indexMetadata = this.managedSolrServer.createSolrIndex(indexName, solrCoreConfig, null);
                if (indexMetadata != null) {
                    this.log.info("  ... created {}", (Object)indexMetadata.getIndexReference());
                }
            } else {
                indexMetadata = this.managedSolrServer.getIndexMetadata(indexName);
                if (indexState != ManagedIndexState.ACTIVE) {
                    this.log.info("  ... activate {}", (Object)indexMetadata.getIndexReference());
                    this.managedSolrServer.activateIndex(indexName);
                } else {
                    this.log.info("  ... index {} already active", (Object)indexMetadata.getIndexReference());
                }
            }
            indexReference = indexMetadata.getIndexReference();
        }
        return indexReference;
    }

    protected void bindManagedSolrServer(ManagedSolrServer managedSolrServer) throws IOException, SAXException {
        this.managedSolrServer = managedSolrServer;
    }

    protected void unbindManagedSolrServer(ManagedSolrServer managedSolrServer) {
        if (this.managedSolrServer == managedSolrServer || this.solrCoreId != null) {
            IndexReference indexReference = IndexReference.parse((String)this.solrCoreId);
            if (!indexReference.checkServer(managedSolrServer.getServerName())) {
                return;
            }
            String indexName = indexReference.getIndex();
            IndexMetadata indexMetadata = managedSolrServer.getIndexMetadata(indexName);
            if (indexMetadata != null && indexMetadata.isActive()) {
                managedSolrServer.deactivateIndex(indexName);
            }
            this.managedSolrServer = null;
        }
    }
}

