/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.engine.topic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.ImmutableGraph;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.impl.utils.PlainLiteralImpl;
import org.apache.clerezza.commons.rdf.impl.utils.TripleImpl;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.utils.GraphNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferenceStrategy;
import org.apache.felix.scr.annotations.Service;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.stanbol.commons.solr.managed.ManagedSolrServer;
import org.apache.stanbol.commons.solr.utils.StreamQueryRequest;
import org.apache.stanbol.enhancer.servicesapi.Blob;
import org.apache.stanbol.enhancer.servicesapi.Chain;
import org.apache.stanbol.enhancer.servicesapi.ChainException;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.EngineException;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.InvalidContentException;
import org.apache.stanbol.enhancer.servicesapi.ServiceProperties;
import org.apache.stanbol.enhancer.servicesapi.helper.ContentItemHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.EnhancementEngineHelper;
import org.apache.stanbol.enhancer.servicesapi.rdf.NamespaceEnum;
import org.apache.stanbol.enhancer.servicesapi.rdf.OntologicalClasses;
import org.apache.stanbol.enhancer.servicesapi.rdf.TechnicalClasses;
import org.apache.stanbol.enhancer.topic.ConfiguredSolrCoreTracker;
import org.apache.stanbol.enhancer.topic.EmbeddedSolrHelper;
import org.apache.stanbol.enhancer.topic.UTCTimeStamper;
import org.apache.stanbol.enhancer.topic.api.Batch;
import org.apache.stanbol.enhancer.topic.api.BatchProcessor;
import org.apache.stanbol.enhancer.topic.api.ClassificationReport;
import org.apache.stanbol.enhancer.topic.api.ClassifierException;
import org.apache.stanbol.enhancer.topic.api.TopicClassifier;
import org.apache.stanbol.enhancer.topic.api.TopicSuggestion;
import org.apache.stanbol.enhancer.topic.api.training.Example;
import org.apache.stanbol.enhancer.topic.api.training.TrainingSet;
import org.apache.stanbol.enhancer.topic.api.training.TrainingSetException;
import org.apache.stanbol.entityhub.servicesapi.Entityhub;
import org.apache.stanbol.entityhub.servicesapi.EntityhubException;
import org.apache.stanbol.entityhub.servicesapi.model.Entity;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.Text;
import org.apache.stanbol.entityhub.servicesapi.site.SiteManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service
@Properties(value={@Property(name="stanbol.enhancer.engine.name"), @Property(name="org.apache.stanbol.enhancer.engine.topic.solrCore"), @Property(name="org.apache.stanbol.enhancer.engine.topic.solrCoreConfig", value={"default-topic-model.solrindex.zip"}), @Property(name="org.apache.stanbol.enhancer.engine.topic.languages"), @Property(name="org.apache.stanbol.enhancer.engine.topic.trainingSetId"), @Property(name="service.ranking", intValue={0})})
public class TopicClassificationEngine
extends ConfiguredSolrCoreTracker
implements EnhancementEngine,
ServiceProperties,
TopicClassifier {
    public static final String DEFAULT_SOLR_CORE_CONFIG = "default-topic-model.solrindex.zip";
    public static final String MODEL_ENTRY = "model";
    public static final String METADATA_ENTRY = "metadata";
    public static final String SOLR_CORE = "org.apache.stanbol.enhancer.engine.topic.solrCore";
    public static final String SOLR_CORE_CONFIG = "org.apache.stanbol.enhancer.engine.topic.solrCoreConfig";
    public static final String LANGUAGES = "org.apache.stanbol.enhancer.engine.topic.languages";
    public static final String ORDER = "org.apache.stanbol.enhancer.engine.topic.order";
    public static final Integer DEFAULT_ENGINE_ORDER = ServiceProperties.ORDERING_CONTENT_EXTRACTION;
    public static final String ENTRY_ID_FIELD = "org.apache.stanbol.enhancer.engine.topic.entryIdField";
    public static final String DEFAULT_ENTRY_ID_FIELD = "entry_id";
    public static final String ENTRY_TYPE_FIELD = "org.apache.stanbol.enhancer.engine.topic.entryTypeField";
    public static final String DEFAULT_ENTRY_TYPE_FIELD = "entry_type";
    public static final String SIMILARTITY_FIELD = "org.apache.stanbol.enhancer.engine.topic.similarityField";
    public static final String DEFAULT_SIMILARTITY_FIELD = "classifier_features";
    public static final String CONCEPT_URI_FIELD = "org.apache.stanbol.enhancer.engine.topic.conceptUriField";
    public static final String DEFAULT_CONCEPT_URI_FIELD = "concept";
    public static final String BROADER_FIELD = "org.apache.stanbol.enhancer.engine.topic.broaderField";
    public static final String DEFAULT_BROADER_FIELD = "broader";
    public static final String PRIMARY_TOPIC_URI_FIELD = "org.apache.stanbol.enhancer.engine.topic.primaryTopicField";
    public static final String DEFAULT_PRIMARY_TOPIC_URI_FIELD = "primary_topic";
    public static final String MODEL_UPDATE_DATE_FIELD = "org.apache.stanbol.enhancer.engine.topic.modelUpdateDateField";
    public static final String DEFAULT_MODEL_UPDATE_DATE_FIELD = "last_update_dt";
    public static final String MODEL_EVALUATION_DATE_FIELD = "org.apache.stanbol.enhancer.engine.topic.modelEvaluationDateField";
    public static final String DEFAULT_MODEL_EVALUATION_DATE_FIELD = "last_evaluation_dt";
    public static final String MODEL_ENTRY_ID_FIELD = "org.apache.stanbol.enhancer.engine.topic.modelEntryIdField";
    public static final String DEFAULT_MODEL_ENTRY_ID_FIELD = "model_entry_id";
    public static final String PRECISION_FIELD = "org.apache.stanbol.enhancer.engine.topic.precisionField";
    public static final String DEFAULT_PRECISION_FIELD = "precision";
    public static final String RECALL_FIELD = "org.apache.stanbol.enhancer.engine.topic.recallField";
    public static final String DEFAULT_RECALL_FIELD = "recall";
    public static final String FALSE_POSITIVES_FIELD = "org.apache.stanbol.enhancer.engine.topic.falsePositivesField";
    public static final String DEFAULT_FALSE_POSITIVES_FIELD = "false_positives";
    public static final String FALSE_NEGATIVES_FIELD = "org.apache.stanbol.enhancer.engine.topic.falseNegativesField";
    public static final String DEFAULT_FALSE_NEGATIVES_FIELD = "false_negatives";
    public static final String POSITIVE_SUPPORT_FIELD = "org.apache.stanbol.enhancer.engine.topic.positiveSupportField";
    public static final String DEFAULT_POSITIVE_SUPPORT_FIELD = "positive_support";
    public static final String NEGATIVE_SUPPORT_FIELD = "org.apache.stanbol.enhancer.engine.topic.negativeSupportField";
    public static final String DEFAULT_NEGATIVE_SUPPORT_FIELD = "negative_support";
    public static final String TRAINING_SET_ID = "org.apache.stanbol.enhancer.engine.topic.trainingSetId";
    private static final Logger log = LoggerFactory.getLogger(TopicClassificationEngine.class);
    public static final String PLAIN_TEXT_MIMETYPE = "text/plain";
    public static final Set<String> SUPPORTED_MIMETYPES = Collections.singleton("text/plain");
    public static final String SOLR_NON_EMPTY_FIELD = "[\"\" TO *]";
    @Reference
    protected Entityhub entityhub;
    @Reference
    protected SiteManager referencedSiteManager;
    private int MAX_COLLECTED_EXAMPLES = 1000;
    public int MAX_EVALUATION_SAMPLES = 500;
    public int MIN_EVALUATION_SAMPLES = 10;
    public int MAX_CHARS_PER_TOPIC = 100000;
    public Integer MAX_ROOTS = 1000;
    public int MAX_SUGGESTIONS = 5;
    protected String engineName;
    protected List<String> acceptedLanguages;
    private Set<String> acceptedLanguageSet;
    protected Integer order = ORDERING_EXTRACTION_ENHANCEMENT;
    protected String similarityField;
    protected String conceptUriField;
    protected String broaderField;
    protected String primaryTopicUriField;
    protected String modelUpdateDateField;
    protected String modelEvaluationDateField;
    protected String precisionField;
    protected String recallField;
    protected TrainingSet trainingSet;
    protected ServiceTracker trainingSetTracker;
    protected String trainingSetId;
    protected String entryIdField;
    protected String entryTypeField;
    protected String modelEntryIdField;
    protected String positiveSupportField;
    protected String negativeSupportField;
    protected String falsePositivesField;
    protected String falseNegativesField;
    protected int cvFoldIndex = 0;
    protected int cvFoldCount = 0;
    protected boolean evaluationRunning = false;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, bind="bindManagedSolrServer", unbind="unbindManagedSolrServer", strategy=ReferenceStrategy.EVENT, policy=ReferencePolicy.DYNAMIC)
    protected ManagedSolrServer managedSolrServerDummy;
    private File embeddedSolrServerDir;
    private EmbeddedSolrServer __evaluationServer;
    private File __evaluationServerDir;

    void configureEmbeddedSolrServerDir(File directory) {
        this.embeddedSolrServerDir = directory;
    }

    @Activate
    protected void activate(ComponentContext context) throws ConfigurationException, InvalidSyntaxException {
        Dictionary config = context.getProperties();
        this.activate(context, config);
    }

    protected void activate(ComponentContext context, Dictionary<String, Object> config) throws ConfigurationException, InvalidSyntaxException {
        this.context = context;
        this.configure(config);
        if (this.trainingSetId != null) {
            String filter = String.format("(&(%s=%s)(%s=%s))", "objectClass", TrainingSet.class.getName(), "org.apache.stanbol.enhancer.topic.trainingset.id", this.trainingSetId);
            this.trainingSetTracker = new ServiceTracker(context.getBundleContext(), context.getBundleContext().createFilter(filter), null);
            this.trainingSetTracker.open();
        }
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        if (this.indexTracker != null) {
            this.indexTracker.close();
        }
        if (this.trainingSetTracker != null) {
            this.trainingSetTracker.close();
        }
        if (this.__evaluationServer != null) {
            try {
                this.__evaluationServer.getCoreContainer().shutdown();
            }
            catch (Exception exception) {
            }
            finally {
                FileUtils.deleteQuietly((File)this.__evaluationServerDir);
            }
        }
        context = null;
    }

    @Override
    public void configure(Dictionary<String, Object> config) throws ConfigurationException {
        this.engineName = this.getRequiredStringParam(config, "stanbol.enhancer.engine.name");
        this.entryIdField = this.getRequiredStringParam(config, ENTRY_ID_FIELD, DEFAULT_ENTRY_ID_FIELD);
        this.modelEntryIdField = this.getRequiredStringParam(config, MODEL_ENTRY_ID_FIELD, DEFAULT_MODEL_ENTRY_ID_FIELD);
        this.conceptUriField = this.getRequiredStringParam(config, CONCEPT_URI_FIELD, DEFAULT_CONCEPT_URI_FIELD);
        this.entryTypeField = this.getRequiredStringParam(config, ENTRY_TYPE_FIELD, DEFAULT_ENTRY_TYPE_FIELD);
        this.similarityField = this.getRequiredStringParam(config, SIMILARTITY_FIELD, DEFAULT_SIMILARTITY_FIELD);
        this.acceptedLanguages = this.getStringListParan(config, LANGUAGES);
        this.acceptedLanguageSet = new HashSet<String>(this.acceptedLanguages);
        this.precisionField = this.getRequiredStringParam(config, PRECISION_FIELD, DEFAULT_PRECISION_FIELD);
        this.recallField = this.getRequiredStringParam(config, RECALL_FIELD, DEFAULT_RECALL_FIELD);
        this.modelUpdateDateField = this.getRequiredStringParam(config, MODEL_UPDATE_DATE_FIELD, DEFAULT_MODEL_UPDATE_DATE_FIELD);
        this.modelEvaluationDateField = this.getRequiredStringParam(config, MODEL_EVALUATION_DATE_FIELD, DEFAULT_MODEL_EVALUATION_DATE_FIELD);
        this.falsePositivesField = this.getRequiredStringParam(config, FALSE_POSITIVES_FIELD, DEFAULT_FALSE_POSITIVES_FIELD);
        this.falseNegativesField = this.getRequiredStringParam(config, FALSE_NEGATIVES_FIELD, DEFAULT_FALSE_NEGATIVES_FIELD);
        this.positiveSupportField = this.getRequiredStringParam(config, POSITIVE_SUPPORT_FIELD, DEFAULT_POSITIVE_SUPPORT_FIELD);
        this.negativeSupportField = this.getRequiredStringParam(config, NEGATIVE_SUPPORT_FIELD, DEFAULT_NEGATIVE_SUPPORT_FIELD);
        this.configureSolrCore(config, SOLR_CORE, this.engineName + "-model", SOLR_CORE_CONFIG);
        this.broaderField = this.getRequiredStringParam(config, BROADER_FIELD, DEFAULT_BROADER_FIELD);
        this.primaryTopicUriField = this.getRequiredStringParam(config, PRIMARY_TOPIC_URI_FIELD, DEFAULT_PRIMARY_TOPIC_URI_FIELD);
        this.trainingSetId = (String)config.get(TRAINING_SET_ID);
        Object orderParamValue = config.get(ORDER);
        if (orderParamValue instanceof Number) {
            this.order = ((Number)orderParamValue).intValue();
        } else if (orderParamValue != null) {
            try {
                Integer.parseInt(orderParamValue.toString());
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(ORDER, "The configured EnhancementEngine order MUST BE an Intever value!", (Throwable)e);
            }
        } else {
            this.order = DEFAULT_ENGINE_ORDER;
        }
    }

    public int canEnhance(ContentItem ci) throws EngineException {
        if (ContentItemHelper.getBlob((ContentItem)ci, SUPPORTED_MIMETYPES) != null && this.getActiveSolrServer() != null) {
            String language = EnhancementEngineHelper.getLanguage((ContentItem)ci);
            if (this.acceptedLanguageSet.isEmpty() || this.acceptedLanguageSet.contains(language) || this.acceptedLanguageSet.contains("")) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public void computeEnhancements(ContentItem ci) throws EngineException {
        List<TopicSuggestion> topics;
        String text;
        Map.Entry contentPart = ContentItemHelper.getBlob((ContentItem)ci, SUPPORTED_MIMETYPES);
        if (contentPart == null) {
            throw new IllegalStateException("No ContentPart with a supported Mime Typefound for ContentItem " + ci.getUri() + "(supported: '" + SUPPORTED_MIMETYPES + "') -> this indicates that canEnhance was" + "NOT called and indicates a bug in the used EnhancementJobManager!");
        }
        String language = EnhancementEngineHelper.getLanguage((ContentItem)ci);
        if (!(this.acceptedLanguageSet.isEmpty() || this.acceptedLanguageSet.contains(language) || this.acceptedLanguageSet.contains(""))) {
            throw new IllegalStateException("The language '" + language + "' of the ContentItem is not configured as " + " active for this Engine (active: " + this.acceptedLanguageSet + ").");
        }
        try {
            text = ContentItemHelper.getText((Blob)((Blob)contentPart.getValue()));
        }
        catch (IOException e) {
            throw new InvalidContentException(String.format("Unable to extract  textual content from ContentPart %s of ContentItem %s!", contentPart.getKey(), ci.getUri()), (Throwable)e);
        }
        if (text.trim().isEmpty()) {
            log.warn("ContentPart {} of ContentItem {} does not contain any text to extract topics from", contentPart.getKey(), (Object)ci.getUri());
            return;
        }
        Graph metadata = ci.getMetadata();
        try {
            topics = this.suggestTopics(text);
            if (topics.isEmpty()) {
                return;
            }
        }
        catch (ClassifierException e) {
            throw new EngineException((Throwable)e);
        }
        IRI precision = new IRI(NamespaceEnum.fise + "classifier/precision");
        IRI recall = new IRI(NamespaceEnum.fise + "classifier/recall");
        IRI f1 = new IRI(NamespaceEnum.fise + "classifier/f1");
        LiteralFactory lf = LiteralFactory.getInstance();
        ci.getLock().writeLock().lock();
        try {
            IRI textAnnotation = EnhancementEngineHelper.createTextEnhancement((ContentItem)ci, (EnhancementEngine)this);
            metadata.add((Object)new TripleImpl((BlankNodeOrIRI)textAnnotation, org.apache.stanbol.enhancer.servicesapi.rdf.Properties.DC_TYPE, (RDFTerm)OntologicalClasses.SKOS_CONCEPT));
            for (TopicSuggestion topic : topics) {
                Entity entity;
                IRI enhancement = EnhancementEngineHelper.createEntityEnhancement((ContentItem)ci, (EnhancementEngine)this);
                metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, org.apache.stanbol.enhancer.servicesapi.rdf.Properties.RDF_TYPE, (RDFTerm)TechnicalClasses.ENHANCER_TOPICANNOTATION));
                metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, org.apache.stanbol.enhancer.servicesapi.rdf.Properties.DC_RELATION, (RDFTerm)textAnnotation));
                metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, org.apache.stanbol.enhancer.servicesapi.rdf.Properties.ENHANCER_ENTITY_REFERENCE, (RDFTerm)new IRI(topic.conceptUri)));
                metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, org.apache.stanbol.enhancer.servicesapi.rdf.Properties.ENHANCER_ENTITY_TYPE, (RDFTerm)OntologicalClasses.SKOS_CONCEPT));
                metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, org.apache.stanbol.enhancer.servicesapi.rdf.Properties.ENHANCER_CONFIDENCE, (RDFTerm)lf.createTypedLiteral((Object)topic.score)));
                ClassificationReport perf = this.getPerformanceEstimates(topic.conceptUri);
                if (perf.uptodate) {
                    metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, precision, (RDFTerm)lf.createTypedLiteral((Object)perf.precision)));
                    metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, recall, (RDFTerm)lf.createTypedLiteral((Object)perf.recall)));
                    metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, f1, (RDFTerm)lf.createTypedLiteral((Object)perf.f1)));
                }
                if ((entity = this.entityhub.getEntity(topic.conceptUri)) == null) {
                    entity = this.referencedSiteManager.getEntity(topic.conceptUri);
                }
                if (entity == null) continue;
                Representation representation = entity.getRepresentation();
                Text label = representation.getFirst(NamespaceEnum.skos + "prefLabel", new String[]{"en", "en-US", "en-GB"});
                if (label == null) {
                    label = representation.getFirst(NamespaceEnum.rdfs + "label", new String[]{"en", "en-US", "en-GB"});
                }
                if (label == null) continue;
                metadata.add((Object)new TripleImpl((BlankNodeOrIRI)enhancement, org.apache.stanbol.enhancer.servicesapi.rdf.Properties.ENHANCER_ENTITY_LABEL, (RDFTerm)new PlainLiteralImpl(label.getText())));
            }
        }
        catch (ClassifierException e) {
            throw new EngineException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new EngineException((Throwable)e);
        }
        catch (EntityhubException e) {
            throw new EngineException((Throwable)e);
        }
        finally {
            ci.getLock().writeLock().unlock();
        }
    }

    public Map<String, Object> getServiceProperties() {
        return Collections.unmodifiableMap(Collections.singletonMap("org.apache.stanbol.enhancer.engine.order", this.order));
    }

    public static TopicClassificationEngine fromParameters(Dictionary<String, Object> config) throws ConfigurationException {
        TopicClassificationEngine engine = new TopicClassificationEngine();
        engine.configure(config);
        return engine;
    }

    public String getName() {
        return this.engineName;
    }

    public List<String> getAcceptedLanguages() {
        return this.acceptedLanguages;
    }

    public List<TopicSuggestion> suggestTopics(Collection<Object> contents) throws ClassifierException {
        return this.suggestTopics(StringUtils.join(contents, (String)"\n\n"));
    }

    public List<TopicSuggestion> suggestTopics(String text) throws ClassifierException {
        ArrayList<TopicSuggestion> suggestedTopics = new ArrayList<TopicSuggestion>(this.MAX_SUGGESTIONS * 3);
        SolrServer solrServer = this.getActiveSolrServer();
        SolrQuery query = new SolrQuery();
        query.setRequestHandler("/mlt");
        query.setFilterQueries(new String[]{this.entryTypeField + ":" + MODEL_ENTRY});
        query.set("mlt.match.include", false);
        query.set("mlt.mindf", 1);
        query.set("mlt.mintf", 1);
        query.set("mlt.maxqt", 30);
        query.set("mlt.maxntp", 10000);
        query.set("mlt.fl", new String[]{this.similarityField});
        query.set("stream.body", new String[]{text});
        query.setRows(Integer.valueOf(this.MAX_SUGGESTIONS * 3));
        query.setFields(new String[]{this.conceptUriField});
        query.setIncludeScore(true);
        try {
            StreamQueryRequest request = new StreamQueryRequest(query);
            QueryResponse response = request.process(solrServer);
            SolrDocumentList results = response.getResults();
            for (SolrDocument result : (SolrDocument[])results.toArray((Object[])new SolrDocument[0])) {
                String conceptUri = (String)result.getFirstValue(this.conceptUriField);
                if (conceptUri == null) {
                    throw new ClassifierException(String.format("Solr Core '%s' is missing required field '%s'.", this.solrCoreId, this.conceptUriField));
                }
                Float score = (Float)result.getFirstValue("score");
                SolrQuery metadataQuery = new SolrQuery("*:*");
                metadataQuery.addFilterQuery(new String[]{this.entryTypeField + ":" + METADATA_ENTRY});
                metadataQuery.addFilterQuery(new String[]{this.conceptUriField + ":" + ClientUtils.escapeQueryChars((String)conceptUri)});
                metadataQuery.setFields(new String[]{this.conceptUriField, this.broaderField, this.primaryTopicUriField});
                SolrDocument metadata = (SolrDocument)solrServer.query((SolrParams)metadataQuery).getResults().get(0);
                String primaryTopicUri = (String)metadata.getFirstValue(this.primaryTopicUriField);
                suggestedTopics.add(new TopicSuggestion(conceptUri, primaryTopicUri, metadata.getFieldValues(this.broaderField), score.floatValue()));
            }
        }
        catch (SolrServerException e) {
            if ("unknown handler: /mlt".equals(e.getCause().getMessage())) {
                String message = String.format("SolrServer with id '%s' for topic engine '%s' lacks configuration for the MoreLikeThisHandler", this.solrCoreId, this.engineName);
                throw new ClassifierException(message, (Throwable)e);
            }
            throw new ClassifierException((Throwable)e);
        }
        if (suggestedTopics.size() <= 1) {
            return suggestedTopics;
        }
        float mean = 0.0f;
        for (TopicSuggestion suggestion : suggestedTopics) {
            mean += suggestion.score / (float)suggestedTopics.size();
        }
        float threshold = 0.25f * ((TopicSuggestion)suggestedTopics.get((int)0)).score + 0.75f * mean;
        ArrayList<TopicSuggestion> filteredSuggestions = new ArrayList<TopicSuggestion>();
        for (TopicSuggestion suggestion : suggestedTopics) {
            if (filteredSuggestions.size() >= this.MAX_SUGGESTIONS) {
                return filteredSuggestions;
            }
            if (!filteredSuggestions.isEmpty() && !(suggestion.score > threshold)) break;
            filteredSuggestions.add(suggestion);
        }
        return filteredSuggestions;
    }

    public Set<String> getNarrowerConcepts(String broadTopicId) throws ClassifierException {
        LinkedHashSet<String> narrowerConcepts = new LinkedHashSet<String>();
        if (this.broaderField == null) {
            return narrowerConcepts;
        }
        SolrServer solrServer = this.getActiveSolrServer();
        SolrQuery query = new SolrQuery("*:*");
        query.addFilterQuery(new String[]{this.entryTypeField + ":" + METADATA_ENTRY});
        query.addFilterQuery(new String[]{this.broaderField + ":" + ClientUtils.escapeQueryChars((String)broadTopicId)});
        query.addField(this.conceptUriField);
        query.addSortField(this.conceptUriField, SolrQuery.ORDER.asc);
        try {
            for (SolrDocument result : solrServer.query((SolrParams)query).getResults()) {
                narrowerConcepts.add(result.getFirstValue(this.conceptUriField).toString());
            }
        }
        catch (SolrServerException e) {
            String msg = String.format("Error while fetching narrower topics of '%s' on Solr Core '%s'.", broadTopicId, this.solrCoreId);
            throw new ClassifierException(msg, (Throwable)e);
        }
        return narrowerConcepts;
    }

    public Set<String> getBroaderConcepts(String id) throws ClassifierException {
        LinkedHashSet<String> broaderConcepts = new LinkedHashSet<String>();
        if (this.broaderField == null) {
            return broaderConcepts;
        }
        SolrServer solrServer = this.getActiveSolrServer();
        SolrQuery query = new SolrQuery("*:*");
        query.addFilterQuery(new String[]{this.conceptUriField + ":" + ClientUtils.escapeQueryChars((String)id)});
        query.addField(this.broaderField);
        try {
            for (SolrDocument result : solrServer.query((SolrParams)query).getResults()) {
                Collection broaderFieldValues = result.getFieldValues(this.broaderField);
                if (broaderFieldValues == null) continue;
                for (Object value : broaderFieldValues) {
                    broaderConcepts.add(value.toString());
                }
            }
        }
        catch (SolrServerException e) {
            String msg = String.format("Error while fetching broader topics of '%s' on Solr Core '%s'.", id, this.solrCoreId);
            throw new ClassifierException(msg, (Throwable)e);
        }
        return broaderConcepts;
    }

    public Set<String> getRootConcepts() throws ClassifierException {
        LinkedHashSet<String> rootConcepts = new LinkedHashSet<String>();
        SolrServer solrServer = this.getActiveSolrServer();
        SolrQuery query = new SolrQuery("*:*");
        query.setRows(this.MAX_ROOTS);
        query.setFields(new String[]{this.conceptUriField});
        query.setSortField(this.conceptUriField, SolrQuery.ORDER.asc);
        query.addFilterQuery(new String[]{this.entryTypeField + ":" + METADATA_ENTRY});
        if (this.broaderField != null) {
            query.addFilterQuery(new String[]{" -" + this.broaderField + ":" + SOLR_NON_EMPTY_FIELD});
        }
        try {
            QueryResponse response = solrServer.query((SolrParams)query);
            if (response.getResults().size() >= this.MAX_ROOTS) {
                log.warn(String.format("TopicClassifier '%s' has more than %d registered topic roots. Some roots might be ignored.", this.engineName, this.MAX_ROOTS));
            }
            for (SolrDocument result : response.getResults()) {
                rootConcepts.add(result.getFirstValue(this.conceptUriField).toString());
            }
        }
        catch (SolrServerException e) {
            String msg = String.format("Error while fetching root topics on Solr Core '%s'.", this.solrCoreId);
            throw new ClassifierException(msg, (Throwable)e);
        }
        return rootConcepts;
    }

    public void addConcept(String conceptUri, String primaryTopicUri, Collection<String> broaderConcepts) throws ClassifierException {
        this.removeConcept(conceptUri);
        SolrInputDocument metadataEntry = new SolrInputDocument();
        String metadataEntryId = UUID.randomUUID().toString();
        String modelEntryId = UUID.randomUUID().toString();
        metadataEntry.addField(this.conceptUriField, (Object)conceptUri);
        metadataEntry.addField(this.entryIdField, (Object)metadataEntryId);
        metadataEntry.addField(this.modelEntryIdField, (Object)modelEntryId);
        metadataEntry.addField(this.entryTypeField, (Object)METADATA_ENTRY);
        if (broaderConcepts != null && this.broaderField != null) {
            metadataEntry.addField(this.broaderField, broaderConcepts);
        }
        if (primaryTopicUri != null && this.primaryTopicUriField != null) {
            metadataEntry.addField(this.primaryTopicUriField, (Object)primaryTopicUri);
        }
        SolrInputDocument modelEntry = new SolrInputDocument();
        modelEntry.addField(this.entryIdField, (Object)modelEntryId);
        modelEntry.addField(this.conceptUriField, (Object)conceptUri);
        modelEntry.addField(this.entryTypeField, (Object)MODEL_ENTRY);
        if (broaderConcepts != null) {
            this.invalidateModelFields(broaderConcepts, this.modelUpdateDateField, this.modelEvaluationDateField);
        }
        SolrServer solrServer = this.getActiveSolrServer();
        try {
            UpdateRequest request = new UpdateRequest();
            request.add(metadataEntry);
            request.add(modelEntry);
            solrServer.request((SolrRequest)request);
            solrServer.commit();
        }
        catch (Exception e) {
            String msg = String.format("Error adding topic with id '%s' on Solr Core '%s'", conceptUri, this.solrCoreId);
            throw new ClassifierException(msg, (Throwable)e);
        }
    }

    public void addConcept(String conceptId, Collection<String> broaderConcepts) throws ClassifierException {
        this.addConcept(conceptId, null, broaderConcepts);
    }

    protected void invalidateModelFields(Collection<String> conceptIds, String ... fieldNames) throws ClassifierException {
        if (conceptIds.isEmpty() || fieldNames.length == 0) {
            return;
        }
        SolrServer solrServer = this.getActiveSolrServer();
        List<String> invalidatedFields = Arrays.asList(fieldNames);
        try {
            UpdateRequest request = new UpdateRequest();
            for (String conceptId : conceptIds) {
                SolrQuery query = new SolrQuery("*:*");
                query.addFilterQuery(new String[]{this.entryTypeField + ":" + METADATA_ENTRY});
                query.addFilterQuery(new String[]{this.conceptUriField + ":" + ClientUtils.escapeQueryChars((String)conceptId)});
                for (SolrDocument result : solrServer.query((SolrParams)query).getResults()) {
                    SolrInputDocument newEntry = new SolrInputDocument();
                    for (String fieldName : result.getFieldNames()) {
                        if (invalidatedFields.contains(fieldName)) continue;
                        newEntry.setField(fieldName, (Object)result.getFieldValues(fieldName));
                    }
                    request.add(newEntry);
                }
            }
            if (request.getDocuments() != null && request.getDocuments().size() > 0) {
                solrServer.request((SolrRequest)request);
            }
        }
        catch (Exception e) {
            String msg = String.format("Error invalidating topics [%s] on Solr Core '%s'", StringUtils.join(conceptIds, (String)", "), this.solrCoreId);
            throw new ClassifierException(msg, (Throwable)e);
        }
    }

    public void removeAllConcepts() throws ClassifierException {
        SolrServer solrServer = this.getActiveSolrServer();
        try {
            solrServer.deleteByQuery("*:*");
            solrServer.commit();
        }
        catch (Exception e) {
            String msg = String.format("Error deleting concepts from Solr Core '%s'", this.solrCoreId);
            throw new ClassifierException(msg, (Throwable)e);
        }
    }

    public void removeConcept(String conceptId) throws ClassifierException {
        if (conceptId == null || conceptId.isEmpty()) {
            throw new ClassifierException("conceptId must not be null or empty");
        }
        SolrServer solrServer = this.getActiveSolrServer();
        try {
            solrServer.deleteByQuery(this.conceptUriField + ":" + ClientUtils.escapeQueryChars((String)conceptId));
            solrServer.commit();
        }
        catch (Exception e) {
            String msg = String.format("Error removing concept '%s' on Solr Core '%s'", conceptId, this.solrCoreId);
            throw new ClassifierException(msg, (Throwable)e);
        }
    }

    public TrainingSet getTrainingSet() {
        if (this.trainingSet != null) {
            return this.trainingSet;
        }
        if (this.trainingSetTracker != null) {
            TrainingSet trainingsSet = (TrainingSet)this.trainingSetTracker.getService();
            if (trainingsSet == null) {
                for (int i = 0; i < 5 && trainingsSet == null; ++i) {
                    try {
                        trainingsSet = (TrainingSet)this.trainingSetTracker.waitForService(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return trainingsSet;
        }
        return null;
    }

    public boolean isUpdatable() {
        return this.getTrainingSet() != null;
    }

    public void setTrainingSet(TrainingSet trainingSet) {
        this.trainingSet = trainingSet;
    }

    protected int batchOverTopics(BatchProcessor<SolrDocument> processor) throws TrainingSetException {
        int processedCount = 0;
        SolrServer solrServer = this.getActiveSolrServer();
        SolrQuery query = new SolrQuery("*:*");
        query.addFilterQuery(new String[]{this.entryTypeField + ":" + METADATA_ENTRY});
        String offset = null;
        boolean done = false;
        int batchSize = 1000;
        query.addSortField(this.conceptUriField, SolrQuery.ORDER.asc);
        query.setRows(Integer.valueOf(batchSize + 1));
        try {
            while (!done) {
                if (offset != null) {
                    query.addFilterQuery(new String[]{this.conceptUriField + ":[" + ClientUtils.escapeQueryChars(offset) + " TO *]"});
                }
                QueryResponse response = solrServer.query((SolrParams)query);
                int count = 0;
                ArrayList<SolrDocument> batchDocuments = new ArrayList<SolrDocument>();
                for (SolrDocument result : response.getResults()) {
                    String conceptId = result.getFirstValue(this.conceptUriField).toString();
                    if (count == batchSize) {
                        offset = conceptId;
                        continue;
                    }
                    ++count;
                    batchDocuments.add(result);
                }
                processedCount += processor.process(batchDocuments);
                solrServer.commit();
                if (count >= batchSize) continue;
                done = true;
            }
            solrServer.optimize();
        }
        catch (Exception e) {
            String msg = String.format("Error while updating topics on Solr Core '%s'.", this.solrCoreId);
            throw new TrainingSetException(msg, (Throwable)e);
        }
        return processedCount;
    }

    public int updateModel(boolean incremental) throws TrainingSetException, ClassifierException {
        this.checkTrainingSet();
        long start = System.currentTimeMillis();
        if (incremental && this.modelUpdateDateField == null) {
            log.warn("org.apache.stanbol.enhancer.engine.topic.modelUpdateDateField field is not configured: switching to batch update mode.");
            incremental = false;
        }
        final boolean incr = incremental;
        int updatedTopics = this.batchOverTopics(new BatchProcessor<SolrDocument>(){

            public int process(List<SolrDocument> batch) throws ClassifierException, TrainingSetException {
                int processed = 0;
                for (SolrDocument result : batch) {
                    Date lastModelUpdate;
                    String conceptId = result.getFirstValue(TopicClassificationEngine.this.conceptUriField).toString();
                    ArrayList<String> impactedTopics = new ArrayList<String>();
                    impactedTopics.add(conceptId);
                    impactedTopics.addAll(TopicClassificationEngine.this.getNarrowerConcepts(conceptId));
                    if (incr && (lastModelUpdate = (Date)result.getFirstValue(TopicClassificationEngine.this.modelUpdateDateField)) != null && !TopicClassificationEngine.this.getTrainingSet().hasChangedSince(impactedTopics, lastModelUpdate)) continue;
                    String metadataEntryId = result.getFirstValue(TopicClassificationEngine.this.entryIdField).toString();
                    String modelEntryId = result.getFirstValue(TopicClassificationEngine.this.modelEntryIdField).toString();
                    String primaryTopicUri = null;
                    if (TopicClassificationEngine.this.primaryTopicUriField != null) {
                        primaryTopicUri = (String)result.getFirstValue(TopicClassificationEngine.this.primaryTopicUriField);
                    }
                    TopicClassificationEngine.this.updateTopic(conceptId, metadataEntryId, modelEntryId, impactedTopics, primaryTopicUri, result.getFieldValues(TopicClassificationEngine.this.broaderField));
                    ++processed;
                }
                return processed;
            }
        });
        long stop = System.currentTimeMillis();
        log.info("Sucessfully updated {} topics in {}s", (Object)updatedTopics, (Object)((double)(stop - start) / 1000.0));
        return updatedTopics;
    }

    protected void updateTopic(String conceptUri, String metadataId, String modelId, List<String> impactedTopics, String primaryTopicUri, Collection<Object> broaderConcepts) throws TrainingSetException, ClassifierException {
        long start = System.currentTimeMillis();
        Batch examples = Batch.emtpyBatch(Example.class);
        StringBuffer sb = new StringBuffer();
        int offset = 0;
        do {
            examples = this.getTrainingSet().getPositiveExamples(impactedTopics, examples.nextOffset);
            for (Example example : examples.items) {
                if (this.cvFoldCount != 0 && offset % this.cvFoldCount == this.cvFoldIndex) {
                    ++offset;
                    continue;
                }
                ++offset;
                sb.append(StringUtils.join((Collection)example.contents, (String)"\n\n"));
                sb.append("\n\n");
            }
        } while (sb.length() < this.MAX_CHARS_PER_TOPIC && examples.hasMore);
        SolrInputDocument modelEntry = new SolrInputDocument();
        modelEntry.addField(this.entryIdField, (Object)modelId);
        modelEntry.addField(this.conceptUriField, (Object)conceptUri);
        modelEntry.addField(this.entryTypeField, (Object)MODEL_ENTRY);
        if (sb.length() > 0) {
            modelEntry.addField(this.similarityField, (Object)sb);
        }
        SolrInputDocument metadataEntry = new SolrInputDocument();
        metadataEntry.addField(this.entryIdField, (Object)metadataId);
        metadataEntry.addField(this.modelEntryIdField, (Object)modelId);
        metadataEntry.addField(this.entryTypeField, (Object)METADATA_ENTRY);
        metadataEntry.addField(this.conceptUriField, (Object)conceptUri);
        if (this.primaryTopicUriField != null) {
            metadataEntry.addField(this.primaryTopicUriField, (Object)primaryTopicUri);
        }
        if (broaderConcepts != null && this.broaderField != null) {
            metadataEntry.addField(this.broaderField, broaderConcepts);
        }
        if (this.modelUpdateDateField != null) {
            metadataEntry.addField(this.modelUpdateDateField, (Object)UTCTimeStamper.nowUtcDate());
        }
        SolrServer solrServer = this.getActiveSolrServer();
        try {
            UpdateRequest request = new UpdateRequest();
            request.add(metadataEntry);
            request.add(modelEntry);
            solrServer.request((SolrRequest)request);
        }
        catch (Exception e) {
            String msg = String.format("Error updating topic with id '%s' on Solr Core '%s'", conceptUri, this.solrCoreId);
            throw new ClassifierException(msg, (Throwable)e);
        }
        long stop = System.currentTimeMillis();
        log.debug("Sucessfully updated topic {} in {}s", (Object)conceptUri, (Object)((double)(stop - start) / 1000.0));
    }

    protected void checkTrainingSet() throws TrainingSetException {
        if (this.getTrainingSet() == null) {
            throw new TrainingSetException(String.format("TopicClassificationEngine %s has no registered training set hence cannot be updated.", this.engineName));
        }
    }

    public void setCrossValidationInfo(int foldIndex, int foldCount) {
        if (foldIndex > foldCount - 1) {
            throw new IllegalArgumentException(String.format("foldIndex=%d should be smaller than foldCount=%d - 1", foldIndex, foldCount));
        }
        this.cvFoldIndex = foldIndex;
        this.cvFoldCount = foldCount;
    }

    protected Dictionary<String, Object> getCanonicalConfiguration(Object server, Object coreConfig) {
        Hashtable<String, Object> config = new Hashtable<String, Object>();
        config.put("stanbol.enhancer.engine.name", this.engineName + "-evaluation");
        config.put(ENTRY_ID_FIELD, DEFAULT_ENTRY_ID_FIELD);
        config.put(ENTRY_TYPE_FIELD, DEFAULT_ENTRY_TYPE_FIELD);
        config.put(MODEL_ENTRY_ID_FIELD, DEFAULT_MODEL_ENTRY_ID_FIELD);
        config.put(SOLR_CORE, server);
        config.put(SOLR_CORE_CONFIG, coreConfig);
        config.put(CONCEPT_URI_FIELD, DEFAULT_CONCEPT_URI_FIELD);
        config.put(PRIMARY_TOPIC_URI_FIELD, DEFAULT_PRIMARY_TOPIC_URI_FIELD);
        config.put(SIMILARTITY_FIELD, DEFAULT_SIMILARTITY_FIELD);
        config.put(BROADER_FIELD, DEFAULT_BROADER_FIELD);
        config.put(MODEL_UPDATE_DATE_FIELD, DEFAULT_MODEL_UPDATE_DATE_FIELD);
        config.put(MODEL_EVALUATION_DATE_FIELD, DEFAULT_MODEL_EVALUATION_DATE_FIELD);
        config.put(PRECISION_FIELD, DEFAULT_PRECISION_FIELD);
        config.put(RECALL_FIELD, DEFAULT_RECALL_FIELD);
        config.put(POSITIVE_SUPPORT_FIELD, DEFAULT_POSITIVE_SUPPORT_FIELD);
        config.put(NEGATIVE_SUPPORT_FIELD, DEFAULT_NEGATIVE_SUPPORT_FIELD);
        config.put(FALSE_POSITIVES_FIELD, DEFAULT_FALSE_POSITIVES_FIELD);
        config.put(FALSE_NEGATIVES_FIELD, DEFAULT_FALSE_NEGATIVES_FIELD);
        return config;
    }

    public boolean isEvaluationRunning() {
        return this.evaluationRunning;
    }

    public synchronized int updatePerformanceEstimates(boolean incremental) throws ClassifierException, TrainingSetException {
        this.checkTrainingSet();
        if (this.evaluationRunning) {
            throw new ClassifierException("Another evaluation is already running");
        }
        int updatedTopics = 0;
        try {
            this.evaluationRunning = true;
            int cvFoldCount = 3;
            int cvIterationCount = 3;
            this.getTrainingSet().optimize();
            for (int cvFoldIndex = 0; cvFoldIndex < cvIterationCount; ++cvFoldIndex) {
                updatedTopics = this.performCVFold(cvFoldIndex, cvFoldCount, cvIterationCount, incremental);
            }
            SolrServer solrServer = this.getActiveSolrServer();
            solrServer.optimize();
        }
        catch (ConfigurationException e) {
            throw new ClassifierException((Throwable)e);
        }
        catch (IOException e) {
            throw new ClassifierException((Throwable)e);
        }
        catch (SolrServerException e) {
            throw new ClassifierException((Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)this.__evaluationServerDir);
            this.evaluationRunning = false;
        }
        return updatedTopics;
    }

    protected int performCVFold(int cvFoldIndex, int cvFoldCount, int cvIterations, boolean incremental) throws ConfigurationException, TrainingSetException, ClassifierException {
        cvIterations = cvIterations <= 0 ? cvFoldCount : cvFoldCount;
        log.info(String.format("Performing evaluation %d-fold CV iteration %d/%d on classifier %s", cvFoldCount, cvFoldIndex + 1, cvIterations, this.engineName));
        long start = System.currentTimeMillis();
        final TopicClassificationEngine classifier = new TopicClassificationEngine();
        try {
            if (this.managedSolrServer != null) {
                classifier.bindManagedSolrServer(this.managedSolrServer);
                classifier.activate(this.context, this.getCanonicalConfiguration(this.engineName + "-evaluation", this.solrCoreConfig));
            } else {
                if (this.__evaluationServer == null) {
                    this.__evaluationServerDir = new File(this.embeddedSolrServerDir, this.engineName + "-evaluation");
                    if (!this.__evaluationServerDir.exists()) {
                        FileUtils.forceMkdir((File)this.__evaluationServerDir);
                    }
                    this.__evaluationServer = EmbeddedSolrHelper.makeEmbeddedSolrServer(this.__evaluationServerDir, "evaluationclassifierserver", "default-topic-model", "default-topic-model");
                }
                classifier.configure(this.getCanonicalConfiguration(this.__evaluationServer, this.solrCoreConfig));
            }
        }
        catch (Exception e) {
            throw new ClassifierException((Throwable)e);
        }
        classifier.removeAllConcepts();
        this.batchOverTopics(new BatchProcessor<SolrDocument>(){

            public int process(List<SolrDocument> batch) throws ClassifierException {
                for (SolrDocument topicEntry : batch) {
                    String conceptId = topicEntry.getFirstValue(TopicClassificationEngine.this.conceptUriField).toString();
                    Collection broader = topicEntry.getFieldValues(TopicClassificationEngine.this.broaderField);
                    if (broader == null) {
                        classifier.addConcept(conceptId, null, null);
                        continue;
                    }
                    ArrayList<String> broaderConcepts = new ArrayList<String>();
                    for (Object broaderConcept : broader) {
                        broaderConcepts.add(broaderConcept.toString());
                    }
                    classifier.addConcept(conceptId, null, broaderConcepts);
                }
                return batch.size();
            }
        });
        classifier.setCrossValidationInfo(cvFoldIndex, cvFoldCount);
        classifier.setTrainingSet(this.getTrainingSet());
        classifier.updateModel(false);
        final int foldCount = cvFoldCount;
        final int foldIndex = cvFoldIndex;
        int updatedTopics = this.batchOverTopics(new BatchProcessor<SolrDocument>(){

            public int process(List<SolrDocument> batch) throws TrainingSetException, ClassifierException {
                int updated = 0;
                for (SolrDocument topicMetadata : batch) {
                    String topic = topicMetadata.getFirstValue(TopicClassificationEngine.this.conceptUriField).toString();
                    List<String> topics = Arrays.asList(topic);
                    ArrayList<String> falseNegativeExamples = new ArrayList<String>();
                    int truePositives = 0;
                    int falseNegatives = 0;
                    int positiveSupport = 0;
                    int offset = 0;
                    Batch examples = Batch.emtpyBatch(Example.class);
                    boolean skipTopic = false;
                    do {
                        examples = TopicClassificationEngine.this.getTrainingSet().getPositiveExamples(topics, examples.nextOffset);
                        if (offset == 0 && examples.items.size() < TopicClassificationEngine.this.MIN_EVALUATION_SAMPLES) {
                            skipTopic = true;
                            break;
                        }
                        for (Example example : examples.items) {
                            if (offset % foldCount != foldIndex) {
                                ++offset;
                                continue;
                            }
                            ++positiveSupport;
                            ++offset;
                            List<TopicSuggestion> suggestedTopics = classifier.suggestTopics(example.contents);
                            boolean match = false;
                            for (TopicSuggestion suggestedTopic : suggestedTopics) {
                                if (!topic.equals(suggestedTopic.conceptUri)) continue;
                                match = true;
                                ++truePositives;
                                break;
                            }
                            if (match) continue;
                            ++falseNegatives;
                            if (falseNegativeExamples.size() >= TopicClassificationEngine.this.MAX_COLLECTED_EXAMPLES / foldCount) continue;
                            falseNegativeExamples.add(example.id);
                        }
                    } while (!skipTopic && examples.hasMore && offset < TopicClassificationEngine.this.MAX_EVALUATION_SAMPLES);
                    ArrayList<String> falsePositiveExamples = new ArrayList<String>();
                    int falsePositives = 0;
                    int negativeSupport = 0;
                    offset = 0;
                    examples = Batch.emtpyBatch(Example.class);
                    while (!skipTopic) {
                        examples = TopicClassificationEngine.this.getTrainingSet().getNegativeExamples(topics, examples.nextOffset);
                        block7: for (Example example : examples.items) {
                            if (offset % foldCount != foldIndex) {
                                ++offset;
                                continue;
                            }
                            ++negativeSupport;
                            ++offset;
                            List<TopicSuggestion> suggestedTopics = classifier.suggestTopics(example.contents);
                            for (TopicSuggestion suggestedTopic : suggestedTopics) {
                                if (!topic.equals(suggestedTopic.conceptUri)) continue;
                                ++falsePositives;
                                if (falsePositiveExamples.size() >= TopicClassificationEngine.this.MAX_COLLECTED_EXAMPLES / foldCount) continue block7;
                                falsePositiveExamples.add(example.id);
                                continue block7;
                            }
                        }
                        if (examples.hasMore && offset < TopicClassificationEngine.this.MAX_EVALUATION_SAMPLES) continue;
                    }
                    if (skipTopic) {
                        log.debug("Skipping evaluation of {} because too few positive examples.", (Object)topic);
                        continue;
                    }
                    float precision = 0.0f;
                    if (truePositives != 0 || falsePositives != 0) {
                        precision = (float)truePositives / (float)(truePositives + falsePositives);
                    }
                    float recall = 0.0f;
                    if (truePositives != 0 || falseNegatives != 0) {
                        recall = (float)truePositives / (float)(truePositives + falseNegatives);
                    }
                    TopicClassificationEngine.this.updatePerformanceMetadata(topic, precision, recall, positiveSupport, negativeSupport, falsePositiveExamples, falseNegativeExamples);
                    ++updated;
                }
                try {
                    TopicClassificationEngine.this.getActiveSolrServer().commit();
                }
                catch (Exception e) {
                    throw new ClassifierException((Throwable)e);
                }
                return updated;
            }
        });
        long stop = System.currentTimeMillis();
        log.info(String.format("Finished CV iteration %d/%d on classifier %s in %fs.", cvFoldIndex + 1, cvFoldCount, this.engineName, (double)(stop - start) / 1000.0));
        if (this.context != null) {
            classifier.deactivate(this.context);
        }
        return updatedTopics;
    }

    protected void updatePerformanceMetadata(String conceptId, float precision, float recall, int positiveSupport, int negativeSupport, List<String> falsePositiveExamples, List<String> falseNegativeExamples) throws ClassifierException {
        SolrServer solrServer = this.getActiveSolrServer();
        try {
            SolrQuery query = new SolrQuery("*:*");
            query.addFilterQuery(new String[]{this.entryTypeField + ":" + METADATA_ENTRY});
            query.addFilterQuery(new String[]{this.conceptUriField + ":" + ClientUtils.escapeQueryChars((String)conceptId)});
            for (SolrDocument result : solrServer.query((SolrParams)query).getResults()) {
                HashMap<String, Collection<Object>> fieldValues = new HashMap<String, Collection<Object>>();
                for (String fieldName : result.getFieldNames()) {
                    fieldValues.put(fieldName, result.getFieldValues(fieldName));
                }
                this.addToList(fieldValues, this.precisionField, Float.valueOf(precision));
                this.addToList(fieldValues, this.recallField, Float.valueOf(recall));
                this.increment(fieldValues, this.positiveSupportField, positiveSupport);
                this.increment(fieldValues, this.negativeSupportField, negativeSupport);
                this.addToList(fieldValues, this.falsePositivesField, falsePositiveExamples);
                this.addToList(fieldValues, this.falseNegativesField, falseNegativeExamples);
                SolrInputDocument newEntry = new SolrInputDocument();
                for (Map.Entry entry : fieldValues.entrySet()) {
                    newEntry.addField((String)entry.getKey(), entry.getValue());
                }
                newEntry.setField(this.modelEvaluationDateField, (Object)UTCTimeStamper.nowUtcDate());
                solrServer.add(newEntry);
            }
            log.info(String.format("Performance for concept '%s': precision=%f, recall=%f, positiveSupport=%d, negativeSupport=%d", conceptId, Float.valueOf(precision), Float.valueOf(recall), positiveSupport, negativeSupport));
        }
        catch (Exception e) {
            String msg = String.format("Error updating performance metadata for topic '%s' on Solr Core '%s'", conceptId, this.solrCoreId);
            throw new ClassifierException(msg, (Throwable)e);
        }
    }

    protected void increment(Map<String, Collection<Object>> fieldValues, String fieldName, int count) {
        Collection<Object> oldValues = fieldValues.get(fieldName);
        if (oldValues != null && !oldValues.isEmpty()) {
            count += ((Integer)oldValues.iterator().next()).intValue();
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(count);
        fieldValues.put(fieldName, values);
    }

    protected void addToList(Map<String, Collection<Object>> fieldValues, String fieldName, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (fieldValues.get(fieldName) != null) {
            values.addAll(fieldValues.get(fieldName));
        }
        if (value instanceof Collection) {
            values.addAll((Collection)value);
        } else {
            values.add(value);
        }
        fieldValues.put(fieldName, values);
    }

    public ClassificationReport getPerformanceEstimates(String conceptId) throws ClassifierException {
        SolrServer solrServer = this.getActiveSolrServer();
        SolrQuery query = new SolrQuery("*:*");
        query.addFilterQuery(new String[]{this.entryTypeField + ":" + METADATA_ENTRY});
        query.addFilterQuery(new String[]{this.conceptUriField + ":" + ClientUtils.escapeQueryChars((String)conceptId)});
        try {
            SolrDocumentList results = solrServer.query((SolrParams)query).getResults();
            if (results.isEmpty()) {
                throw new ClassifierException(String.format("'%s' is not a registered topic", conceptId));
            }
            SolrDocument metadata = (SolrDocument)results.get(0);
            Float precision = this.computeMeanValue(metadata, this.precisionField);
            Float recall = this.computeMeanValue(metadata, this.recallField);
            int positiveSupport = this.computeSumValue(metadata, this.positiveSupportField);
            int negativeSupport = this.computeSumValue(metadata, this.negativeSupportField);
            Date evaluationDate = (Date)metadata.getFirstValue(this.modelEvaluationDateField);
            boolean uptodate = evaluationDate != null;
            ClassificationReport report = new ClassificationReport(precision.floatValue(), recall.floatValue(), positiveSupport, negativeSupport, uptodate, evaluationDate);
            if (metadata.getFieldValues(this.falsePositivesField) == null) {
                metadata.setField(this.falsePositivesField, new ArrayList());
            }
            for (Object falsePositiveId : metadata.getFieldValues(this.falsePositivesField)) {
                report.falsePositiveExampleIds.add(falsePositiveId.toString());
            }
            if (metadata.getFieldValues(this.falseNegativesField) == null) {
                metadata.setField(this.falseNegativesField, new ArrayList());
            }
            for (Object falseNegativeId : metadata.getFieldValues(this.falseNegativesField)) {
                report.falseNegativeExampleIds.add(falseNegativeId.toString());
            }
            return report;
        }
        catch (SolrServerException e) {
            throw new ClassifierException(String.format("Error fetching the performance report for topic " + conceptId, new Object[0]));
        }
    }

    protected Float computeMeanValue(SolrDocument metadata, String fielName) {
        Float mean = Float.valueOf(0.0f);
        Collection values = metadata.getFieldValues(fielName);
        if (values == null || values.isEmpty()) {
            return mean;
        }
        for (Object v : values) {
            mean = Float.valueOf(mean.floatValue() + ((Float)v).floatValue() / (float)values.size());
        }
        return mean;
    }

    protected Integer computeSumValue(SolrDocument metadata, String fielName) {
        Integer sum = 0;
        Collection values = metadata.getFieldValues(fielName);
        if (values == null || values.isEmpty()) {
            return sum;
        }
        for (Object v : values) {
            sum = sum + (Integer)v;
        }
        return sum;
    }

    public List<String> getChainNames() throws InvalidSyntaxException {
        ArrayList<String> chainNames = new ArrayList<String>();
        BundleContext bundleContext = this.context.getBundleContext();
        ServiceReference[] references = bundleContext.getServiceReferences(Chain.class.getName(), null);
        if (references != null) {
            for (ServiceReference ref : references) {
                Chain chain = (Chain)bundleContext.getService(ref);
                try {
                    if (!chain.getEngines().contains(this.getName())) continue;
                    chainNames.add(chain.getName());
                }
                catch (ChainException chainException) {
                    // empty catch block
                }
            }
        }
        return chainNames;
    }

    public int importConceptsFromGraph(ImmutableGraph graph, IRI conceptClass, IRI broaderProperty) throws ClassifierException {
        int importedCount = 0;
        Iterator conceptIterator = graph.filter(null, org.apache.stanbol.enhancer.servicesapi.rdf.Properties.RDF_TYPE, (RDFTerm)conceptClass);
        while (conceptIterator.hasNext()) {
            Triple conceptTriple = (Triple)conceptIterator.next();
            if (!(conceptTriple.getSubject() instanceof IRI)) continue;
            IRI conceptUri = (IRI)conceptTriple.getSubject();
            GraphNode node = new GraphNode((RDFTerm)conceptUri, (Graph)graph);
            ArrayList<String> broaderConcepts = new ArrayList<String>();
            Iterator broaderIterator = node.getObjectNodes(broaderProperty);
            while (broaderIterator.hasNext()) {
                RDFTerm node2 = ((GraphNode)broaderIterator.next()).getNode();
                if (!(node2 instanceof IRI)) continue;
                broaderConcepts.add(((IRI)node2).getUnicodeString());
            }
            this.addConcept(conceptUri.getUnicodeString(), broaderConcepts);
            ++importedCount;
        }
        return importedCount;
    }

    protected void bindEntityhub(Entityhub entityhub) {
        this.entityhub = entityhub;
    }

    protected void unbindEntityhub(Entityhub entityhub) {
        if (this.entityhub == entityhub) {
            this.entityhub = null;
        }
    }

    protected void bindReferencedSiteManager(SiteManager siteManager) {
        this.referencedSiteManager = siteManager;
    }

    protected void unbindReferencedSiteManager(SiteManager siteManager) {
        if (this.referencedSiteManager == siteManager) {
            this.referencedSiteManager = null;
        }
    }
}

