/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.contenthub.store.clerezza;

import java.util.Collection;
import javax.ws.rs.core.MediaType;
import org.apache.clerezza.platform.content.DiscobitsHandler;
import org.apache.clerezza.platform.graphprovider.content.ContentGraphProvider;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.EntityAlreadyExistsException;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.access.NoSuchEntityException;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.utils.GraphNode;
import org.apache.stanbol.contenthub.servicesapi.store.Store;
import org.apache.stanbol.contenthub.store.clerezza.ClerezzaContentItem;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;

public class ClerezzaStore
implements Store {
    DiscobitsHandler handler;
    ContentGraphProvider cgProvider;
    TcManager tcManager;

    public ContentItem create(String id, byte[] content, String contentType) {
        LockableMGraph metadataGraph;
        UriRef uriRef = new UriRef(id);
        try {
            metadataGraph = this.tcManager.createMGraph(uriRef);
        }
        catch (EntityAlreadyExistsException ex) {
            return null;
        }
        this.handler.put(new UriRef(id), MediaType.valueOf((String)contentType), content);
        ClerezzaContentItem contentItem = new ClerezzaContentItem(new GraphNode((Resource)uriRef, (TripleCollection)this.cgProvider.getContentGraph()), (MGraph)new SimpleMGraph((Collection)metadataGraph), this.handler);
        return contentItem;
    }

    public String put(ContentItem ci) {
        LockableMGraph metadataGraph = this.tcManager.getMGraph(new UriRef(ci.getUri().getUnicodeString()));
        metadataGraph.clear();
        metadataGraph.addAll((Collection)ci.getMetadata());
        return ci.getUri().getUnicodeString();
    }

    public ContentItem get(String id) {
        LockableMGraph metadataGraph;
        UriRef uriRef = new UriRef(id);
        try {
            metadataGraph = this.tcManager.getMGraph(uriRef);
        }
        catch (NoSuchEntityException ex) {
            throw new IllegalArgumentException("Is not a content item");
        }
        ClerezzaContentItem contentItem = new ClerezzaContentItem(new GraphNode((Resource)uriRef, (TripleCollection)this.cgProvider.getContentGraph()), (MGraph)metadataGraph, this.handler);
        return contentItem;
    }

    public MGraph getEnhancementGraph() {
        return new SimpleMGraph();
    }

    protected void bindHandler(DiscobitsHandler discobitsHandler) {
        this.handler = discobitsHandler;
    }

    protected void unbindHandler(DiscobitsHandler discobitsHandler) {
        if (this.handler == discobitsHandler) {
            this.handler = null;
        }
    }

    protected void bindCgProvider(ContentGraphProvider contentGraphProvider) {
        this.cgProvider = contentGraphProvider;
    }

    protected void unbindCgProvider(ContentGraphProvider contentGraphProvider) {
        if (this.cgProvider == contentGraphProvider) {
            this.cgProvider = null;
        }
    }

    protected void bindTcManager(TcManager tcManager) {
        this.tcManager = tcManager;
    }

    protected void unbindTcManager(TcManager tcManager) {
        if (this.tcManager == tcManager) {
            this.tcManager = null;
        }
    }
}

