/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.utils;

import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Random;
import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MLink;

public class SqoopUtils {
    private static final Random rand = new Random();

    public static void fillObjectName(MAccountableEntity object) {
        String objectName = object.getName();
        if (objectName != null && !objectName.isEmpty()) {
            return;
        }
        String prefix = "";
        if (object instanceof MLink) {
            prefix = "link_";
        } else if (object instanceof MJob) {
            prefix = "job_";
        }
        object.setName(prefix + rand.nextLong());
    }

    public static String getLocalHostName() {
        String fqdn;
        try {
            fqdn = InetAddress.getLocalHost().getCanonicalHostName().toLowerCase(Locale.getDefault());
        }
        catch (UnknownHostException e1) {
            fqdn = "localhost";
        }
        return fqdn;
    }

    public static String getLocalIpAddress() {
        String address;
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e1) {
            address = "127.0.0.1";
        }
        return address;
    }

    public static String getClasspathDir(Class klass) throws Exception {
        String file = klass.getName();
        file = file.replace('.', '/') + ".class";
        URL url = Thread.currentThread().getContextClassLoader().getResource(file);
        String baseDir = url.toURI().getPath();
        baseDir = baseDir.substring(0, baseDir.length() - file.length() - 1);
        return baseDir;
    }
}

