/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.sqoop.test.utils.SqoopUtils;
import org.bouncycastle.x509.X509V1CertificateGenerator;

public class SecurityUtils {
    public static final String CLIENT_KEYSTORE = "clientKS.jks";
    public static final String SERVER_KEYSTORE = "serverKS.jks";
    public static final String TRUSTSTORE = "trustKS.jks";
    public static final String CLIENT_KEY_PASSWORD = "client_key";
    public static final String CLIENT_KEY_STORE_PASSWORD = "client_keystore";
    public static final String SERVER_KEY_PASSWORD = "server_key";
    public static final String SERVER_KEY_STORE_PASSWORD = "server_keystore";

    public static X509Certificate setupSSLConfig(String keystoresDir, String sslConfDir, Configuration conf, boolean useClientCert, boolean trustStore) throws Exception {
        String clientKeyStorePath = keystoresDir + "/" + CLIENT_KEYSTORE;
        String serverKeyStorePath = keystoresDir + "/" + SERVER_KEYSTORE;
        String serverPassword = "serverP";
        String trustKS = null;
        String trustPassword = "trustP";
        File sslClientConfFile = new File(sslConfDir, SecurityUtils.getSSLConfigFileName("ssl-client"));
        File sslServerConfFile = new File(sslConfDir, SecurityUtils.getSSLConfigFileName("ssl-server"));
        HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
        String hostname = SqoopUtils.getLocalHostName();
        if (useClientCert) {
            KeyPair cKP = SecurityUtils.generateKeyPair("RSA");
            X509Certificate cCert = SecurityUtils.generateCertificate("CN=" + hostname + ", O=client", cKP, 30, "SHA1withRSA");
            SecurityUtils.createKeyStore(clientKeyStorePath, CLIENT_KEY_PASSWORD, CLIENT_KEY_STORE_PASSWORD, "client", cKP.getPrivate(), cCert);
            certs.put("client", cCert);
        }
        KeyPair sKP = SecurityUtils.generateKeyPair("RSA");
        X509Certificate sCert = SecurityUtils.generateCertificate("CN=" + hostname + ", O=server", sKP, 30, "SHA1withRSA");
        SecurityUtils.createKeyStore(serverKeyStorePath, SERVER_KEY_PASSWORD, SERVER_KEY_STORE_PASSWORD, "server", sKP.getPrivate(), sCert);
        certs.put("server", sCert);
        if (trustStore) {
            trustKS = keystoresDir + TRUSTSTORE;
            SecurityUtils.createTrustStore(trustKS, trustPassword, certs);
        }
        Configuration clientSSLConf = SecurityUtils.createSSLConfig(SSLFactory.Mode.CLIENT, clientKeyStorePath, CLIENT_KEY_STORE_PASSWORD, CLIENT_KEY_PASSWORD, trustKS);
        Configuration serverSSLConf = SecurityUtils.createSSLConfig(SSLFactory.Mode.SERVER, serverKeyStorePath, SERVER_KEY_STORE_PASSWORD, SERVER_KEY_PASSWORD, trustKS);
        SecurityUtils.saveConfig(sslClientConfFile, clientSSLConf);
        SecurityUtils.saveConfig(sslServerConfFile, serverSSLConf);
        conf.set("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
        conf.set("hadoop.ssl.client.conf", sslClientConfFile.getName());
        conf.set("hadoop.ssl.server.conf", sslServerConfFile.getName());
        conf.setBoolean("hadoop.ssl.require.client.cert", useClientCert);
        return sCert;
    }

    public static String getSSLConfigFileName(String base) {
        String testUniqueForkId = System.getProperty("test.unique.fork.id");
        String fileSuffix = testUniqueForkId != null ? "-" + testUniqueForkId : "";
        return base + fileSuffix + ".xml";
    }

    public static Configuration createSSLConfig(SSLFactory.Mode mode, String keystore, String keyStorePassword, String keyPassword, String trustKS) {
        String trustPassword = "trustP";
        Configuration sslConf = new Configuration(false);
        if (keystore != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.location"), keystore);
        }
        if (keyStorePassword != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.password"), keyStorePassword);
        }
        if (keyPassword != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.keypassword"), keyPassword);
        }
        if (trustKS != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.location"), trustKS);
        }
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.password"), trustPassword);
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.reload.interval"), "1000");
        return sslConf;
    }

    public static KeyPair generateKeyPair(String algorithm) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
        keyGen.initialize(1024);
        return keyGen.genKeyPair();
    }

    public static X509Certificate generateCertificate(String dn, KeyPair pair, int days, String algorithm) throws CertificateEncodingException, InvalidKeyException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException {
        Date from = new Date();
        Date to = new Date(from.getTime() + (long)days * 86400000L);
        BigInteger sn = new BigInteger(64, new SecureRandom());
        KeyPair keyPair = pair;
        X509V1CertificateGenerator certGen = new X509V1CertificateGenerator();
        X500Principal dnName = new X500Principal(dn);
        certGen.setSerialNumber(sn);
        certGen.setIssuerDN(dnName);
        certGen.setNotBefore(from);
        certGen.setNotAfter(to);
        certGen.setSubjectDN(dnName);
        certGen.setPublicKey(keyPair.getPublic());
        certGen.setSignatureAlgorithm(algorithm);
        X509Certificate cert = certGen.generate(pair.getPrivate());
        return cert;
    }

    public static void createKeyStore(String filename, String keyPassword, String keyStorePassword, String alias, Key privateKey, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setKeyEntry(alias, privateKey, keyPassword.toCharArray(), new Certificate[]{cert});
        SecurityUtils.saveKeyStore(ks, filename, keyStorePassword);
    }

    public static <T extends Certificate> void createTrustStore(String filename, String password, Map<String, T> certs) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        for (Map.Entry<String, T> cert : certs.entrySet()) {
            ks.setCertificateEntry(cert.getKey(), (Certificate)cert.getValue());
        }
        SecurityUtils.saveKeyStore(ks, filename, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveKeyStore(KeyStore ks, String filename, String password) throws GeneralSecurityException, IOException {
        try (FileOutputStream out = new FileOutputStream(filename);){
            ks.store(out, password.toCharArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConfig(File file, Configuration conf) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            conf.writeXml((Writer)writer);
        }
    }
}

