/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.log4j.Logger;

public class HdfsUtils {
    private static final Logger LOG = Logger.getLogger(HdfsUtils.class);
    private static final char PATH_SEPARATOR = '/';
    public static final PathFilter filterHiddenFiles = new PathFilter(){

        public boolean accept(Path path) {
            String fileName = path.getName();
            return !fileName.startsWith("_") && !fileName.startsWith(".");
        }
    };

    public static Path[] getOutputMapreduceFiles(FileSystem fs, String directory) throws IOException {
        LinkedList<Path> files = new LinkedList<Path>();
        for (FileStatus fileStatus : fs.listStatus(new Path(directory), filterHiddenFiles)) {
            LOG.debug((Object)("Found mapreduce output file: " + fileStatus.getPath() + " with size " + fileStatus.getLen()));
            if (!fileStatus.isFile()) continue;
            files.add(fileStatus.getPath());
        }
        return files.toArray(new Path[files.size()]);
    }

    public static void createFile(FileSystem fs, String path, String ... lines) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(new Path(path), true), Charset.forName("UTF-8")));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
        }
    }

    public static String joinPathFragments(String ... paths) {
        StringBuilder builder = new StringBuilder();
        for (String path : paths) {
            builder.append(path);
            if (path.charAt(path.length() - 1) == '/') continue;
            builder.append('/');
        }
        return builder.toString();
    }

    private HdfsUtils() {
    }
}

