/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.utils;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.commons.collections.ListUtils;

public class ConnectorUtils {
    public static Map<String, String> compileTestConnectorAndDependency(String[] connectorSourceFiles, String[] connectorDependencySourceFiles, String[] connectorPropertyFiles, String connectorJarName, String connectorDependencyJarName, boolean dependencyBuiltInsideConnectorJar) throws Exception {
        File file;
        ClassLoader classLoader = ConnectorUtils.class.getClassLoader();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new IllegalStateException("Cannot find the system Java compiler. Check that your class path includes tools.jar");
        }
        Path outputDir = Files.createTempDirectory(null, new FileAttribute[0]);
        LinkedHashMap<String, JarContents> sourceFileToJarMap = new LinkedHashMap<String, JarContents>();
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (String connectorDependencySourceFile : connectorDependencySourceFiles) {
            file = new File(classLoader.getResource(connectorDependencySourceFile).getFile());
            sourceFiles.add(file);
        }
        if (connectorDependencySourceFiles.length > 0) {
            sourceFileToJarMap.put(connectorDependencyJarName, new JarContents(sourceFiles, ListUtils.EMPTY_LIST, ListUtils.EMPTY_LIST));
        }
        sourceFiles = new ArrayList();
        for (String connectorSourceFile : connectorSourceFiles) {
            file = new File(classLoader.getResource(connectorSourceFile).getFile());
            sourceFiles.add(file);
        }
        ArrayList<File> propertiesFiles = new ArrayList<File>();
        for (String connectorPropertyFile : connectorPropertyFiles) {
            File file2 = new File(classLoader.getResource(connectorPropertyFile).getFile());
            propertiesFiles.add(file2);
        }
        ArrayList<String> dependencyFiles = new ArrayList<String>();
        if (dependencyBuiltInsideConnectorJar) {
            dependencyFiles.add(connectorDependencyJarName);
        }
        sourceFileToJarMap.put(connectorJarName, new JarContents(sourceFiles, propertiesFiles, dependencyFiles));
        ConnectorUtils.buildJar(outputDir.toString(), sourceFileToJarMap);
        HashMap<String, String> jarMap = new HashMap<String, String>();
        jarMap.put(connectorJarName, outputDir.toString() + File.separator + connectorJarName);
        jarMap.put(connectorDependencyJarName, outputDir.toString() + File.separator + connectorDependencyJarName);
        return jarMap;
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private static void buildJar(String outputDir, Map<String, JarContents> sourceFileToJarMap) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        ArrayList sourceFiles = new ArrayList();
        for (JarContents jarContents : sourceFileToJarMap.values()) {
            sourceFiles.addAll(jarContents.sourceFiles);
        }
        fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Arrays.asList(new File(outputDir)));
        Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(sourceFiles);
        boolean compiled = compiler.getTask(null, fileManager, null, null, null, compilationUnits1).call();
        if (!compiled) {
            throw new RuntimeException("failed to compile");
        }
        for (Map.Entry<String, JarContents> jarNameAndContents : sourceFileToJarMap.entrySet()) {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, ".");
            JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(outputDir + File.separator + jarNameAndContents.getKey()), manifest);
            ArrayList<String> classesForJar = new ArrayList<String>();
            for (File sourceFile : jarNameAndContents.getValue().getSourceFiles()) {
                String fileName = sourceFile.getName().split("\\.")[0];
                classesForJar.add(fileName);
            }
            File dir = new File(outputDir);
            File[] directoryListing = dir.listFiles();
            if (directoryListing != null) {
                for (File compiledClass : directoryListing) {
                    String classFileName = compiledClass.getName().split("\\$")[0].split("\\.")[0];
                    if (!classesForJar.contains(classFileName)) continue;
                    ConnectorUtils.addFileToJar(compiledClass, target);
                }
            }
            for (File propertiesFile : jarNameAndContents.getValue().getProperitesFiles()) {
                ConnectorUtils.addFileToJar(propertiesFile, target);
            }
            for (String dependencyJarFileName : jarNameAndContents.getValue().getDependencyJarFiles()) {
                File dependencyJarFile = new File(dir, dependencyJarFileName);
                ConnectorUtils.addFileToJar(dependencyJarFile, target);
            }
            target.close();
        }
        File dir = new File(outputDir);
        File[] directoryListing = dir.listFiles();
        if (directoryListing != null) {
            for (File file : directoryListing) {
                String extension = file.getName().split("\\.")[1];
                if (extension.equals("jar")) continue;
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"OS_OPEN_STREAM_EXCEPTION_PATH"})
    private static void addFileToJar(File source, JarOutputStream target) throws IOException {
        String entryName = source.getName().endsWith(".jar") ? "lib/" + source.getName() : source.getName();
        JarEntry entry = new JarEntry(entryName);
        entry.setTime(source.lastModified());
        target.putNextEntry(entry);
        BufferedInputStream in = null;
        try {
            int count;
            in = new BufferedInputStream(new FileInputStream(source));
            long bufferSize = source.length();
            if (bufferSize < Integer.MIN_VALUE || bufferSize > Integer.MAX_VALUE) {
                throw new RuntimeException("file to large to be added to jar");
            }
            byte[] buffer = new byte[(int)bufferSize];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
        }
        finally {
            target.closeEntry();
            if (in != null) {
                in.close();
            }
        }
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public static void deleteJars(Map<String, String> jarMap) {
        for (String jarPath : jarMap.values()) {
            new File(jarPath).delete();
        }
    }

    static class JarContents {
        private List<File> sourceFiles;
        private List<File> properitesFiles;
        private List<String> dependencyJarFiles;

        public JarContents(List<File> sourceFiles, List<File> properitesFiles, List<String> dependencyJarFiles) {
            this.sourceFiles = sourceFiles;
            this.properitesFiles = properitesFiles;
            this.dependencyJarFiles = dependencyJarFiles;
        }

        public List<File> getSourceFiles() {
            return this.sourceFiles;
        }

        public List<File> getProperitesFiles() {
            return this.properitesFiles;
        }

        public List<String> getDependencyJarFiles() {
            return this.dependencyJarFiles;
        }
    }
}

