/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.log4j.Logger;
import org.apache.sqoop.test.utils.HdfsUtils;

public class CompressionUtils {
    private static final Logger LOG = Logger.getLogger(CompressionUtils.class);

    public static void untarStreamToDirectory(InputStream inputStream, String targetDirectory) throws IOException {
        assert (inputStream != null);
        assert (targetDirectory != null);
        LOG.info((Object)("Untaring archive to directory: " + targetDirectory));
        TarArchiveInputStream in = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(inputStream));
        TarArchiveEntry entry = null;
        int BUFFER_SIZE = 2048;
        while ((entry = (TarArchiveEntry)in.getNextEntry()) != null) {
            LOG.info((Object)("Untaring file: " + entry.getName()));
            if (entry.isDirectory()) {
                File targetFile = new File(HdfsUtils.joinPathFragments(targetDirectory, entry.getName()));
                if (targetFile.mkdirs()) continue;
                LOG.warn((Object)("Failed to create folder:" + targetFile.getAbsolutePath()));
                continue;
            }
            byte[] data = new byte[BUFFER_SIZE];
            FileOutputStream fos = new FileOutputStream(HdfsUtils.joinPathFragments(targetDirectory, entry.getName()));
            BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER_SIZE);
            Throwable throwable = null;
            try {
                int count;
                while ((count = in.read(data, 0, BUFFER_SIZE)) != -1) {
                    dest.write(data, 0, count);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dest == null) continue;
                if (throwable != null) {
                    try {
                        dest.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                dest.close();
            }
        }
        in.close();
    }

    private CompressionUtils() {
    }
}

