/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.testng;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class SqoopTestListener
extends TestListenerAdapter {
    private static final Logger LOG = Logger.getLogger(SqoopTestListener.class);
    static PrintStream ps;

    public void onTestStart(ITestResult tr) {
        ps.flush();
        ps.print(this.testName(tr));
        ps.print(" running...\n");
    }

    public void onTestFailure(ITestResult tr) {
        ps.flush();
        ps.print("FAILURE");
        ps.print(this.elapsedTime(tr));
        ps.print("\n\n");
    }

    public void onTestSkipped(ITestResult tr) {
        ps.flush();
        ps.print("SKIPPED");
        ps.print(this.elapsedTime(tr));
        ps.print("\n\n");
    }

    public void onTestSuccess(ITestResult tr) {
        ps.flush();
        ps.print("SUCCESS");
        ps.print(this.elapsedTime(tr));
        ps.print("\n\n");
    }

    private String testName(ITestResult tr) {
        StringBuilder sb = new StringBuilder("Test ").append(tr.getTestClass().getName()).append(".").append(tr.getName());
        if (tr.getParameters() != null && tr.getParameters().length > 0) {
            sb.append(" with parameters [").append(StringUtils.join((Object[])tr.getParameters(), (String)",")).append("]");
        }
        return sb.toString();
    }

    private String elapsedTime(ITestResult tr) {
        StringBuilder sb = new StringBuilder(" in ").append((tr.getEndMillis() - tr.getStartMillis()) / 1000L).append(" seconds");
        return sb.toString();
    }

    static {
        try {
            ps = new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.out), false, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)"Error when initialize the SqoopTestListener.", (Throwable)e);
        }
    }
}

