/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.testng;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

@SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
public class ReconfigureLogListener
extends TestListenerAdapter {
    private static final String TEST_LOG_DIRECTORY = System.getProperty("sqoop.integration.log");
    private static final String TEST_LOGGERS = System.getProperty("sqoop.integration.log.loggers", "org.eclipse.jetty=INFO,org.apache.directory=INFO,org.apache.hadoop.ipc.Server=INFO,org.apache.hadoop.hdfs=INFO,org.apache.hadoop.security.SaslInputStream=INFO,org.apache.hadoop.security.SaslRpcClient=INFO,org.apache.hadoop.ipc.Client=INFO,org.apache.hadoop.conf.Configuration=INFO");
    private static Map<String, Level> loggerConfiguration = new HashMap<String, Level>();
    private static int counter;

    public void onTestStart(ITestResult tr) {
        Logger.getRootLogger().getLoggerRepository().resetConfiguration();
        int ourCounter = counter++;
        FileAppender appender = new FileAppender();
        appender.setName("Sqoop test dynamic logger");
        appender.setFile(TEST_LOG_DIRECTORY + "/" + String.format("%05d", ourCounter) + "_" + tr.getTestClass().getName() + "." + tr.getName() + ".txt");
        appender.setLayout((Layout)new PatternLayout("%d{ISO8601} [%t] %-5p %c %x - %m%n"));
        appender.setImmediateFlush(true);
        appender.setThreshold((Priority)Level.DEBUG);
        appender.activateOptions();
        Logger.getRootLogger().addAppender((Appender)appender);
        for (Map.Entry<String, Level> entry : loggerConfiguration.entrySet()) {
            Logger.getLogger((String)entry.getKey()).setLevel(entry.getValue());
        }
    }

    static {
        for (String rule : TEST_LOGGERS.split(",")) {
            String[] split = rule.split("=");
            if (split.length != 2) {
                throw new RuntimeException("Incorrect rule, expected logger=level: " + rule);
            }
            loggerConfiguration.put(split[0].trim(), Level.toLevel((String)split[1].trim()));
        }
        counter = 0;
    }
}

