/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.testcases;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import jline.console.ConsoleReader;
import org.apache.sqoop.client.SqoopClient;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopCommand;
import org.apache.sqoop.test.infrastructure.SqoopTestCase;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"no-real-cluster"})
public abstract class ShellTestCase
extends SqoopTestCase {
    protected SqoopCommand command = null;
    protected ConsoleReader reader = null;
    protected ByteArrayInputStream in = null;
    protected byte[] data = null;
    private static final String TEST_CONNECTOR_NAME = "test-connector-for-shell";

    @BeforeMethod
    public void setup() throws Exception {
        Groovysh shell = new Groovysh();
        this.command = this.createCommand(shell);
        ShellEnvironment.setIo((IO)shell.getIo());
        ShellEnvironment.setClient((SqoopClient)this.getClient());
        this.data = new byte[1024];
        this.in = new ByteArrayInputStream(this.data);
        this.reader = new ConsoleReader((InputStream)this.in, (OutputStream)System.out);
        ShellEnvironment.setConsoleReader((ConsoleReader)this.reader);
    }

    @AfterMethod
    public void cleanup() throws IOException {
        this.clearJob();
        this.clearLink();
    }

    protected Object execute(List args) {
        return this.command.execute(args);
    }

    protected void initData(String destData) throws UnsupportedEncodingException {
        byte[] destDataBytes = destData.getBytes("UTF-8");
        System.arraycopy(destDataBytes, 0, this.data, 0, destDataBytes.length);
        this.in.reset();
    }

    protected void initEnv() {
        this.in.reset();
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
    }

    protected MLink createLink(String linkName) {
        return this.createLink(linkName, TEST_CONNECTOR_NAME);
    }

    protected void createJob(String fromLinkName, String toLinkName, String jobName) {
        this.createLink(fromLinkName, TEST_CONNECTOR_NAME);
        this.createLink(toLinkName, TEST_CONNECTOR_NAME);
        MJob mjob = this.getClient().createJob(fromLinkName, toLinkName);
        mjob.setName(jobName);
        this.saveJob(mjob);
    }

    protected abstract SqoopCommand createCommand(Groovysh var1);
}

