/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.minicluster;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.common.test.repository.RepositoryProviderFactory;
import org.apache.sqoop.test.kdc.KdcRunner;

public abstract class SqoopMiniCluster {
    private Configuration configuration;
    private String temporaryPath;
    private KdcRunner kdc;

    public SqoopMiniCluster(String temporaryPath) throws Exception {
        this(temporaryPath, new Configuration());
    }

    public SqoopMiniCluster(String temporaryPath, Configuration configuration) throws Exception {
        this.temporaryPath = temporaryPath;
        this.configuration = configuration;
    }

    public String getTemporaryPath() {
        return this.temporaryPath;
    }

    public String getConfigurationPath() {
        return this.temporaryPath + "/config/";
    }

    public String getLogPath() {
        return this.temporaryPath + "/log/";
    }

    public void setKdc(KdcRunner kdc) {
        this.kdc = kdc;
    }

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public abstract String getServerUrl();

    protected void prepareTemporaryPath() throws Exception {
        File tmpDir = new File(this.getTemporaryPath());
        File configDir = new File(this.getConfigurationPath());
        File logDir = new File(this.getLogPath());
        FileUtils.deleteDirectory((File)tmpDir);
        FileUtils.forceMkdir((File)tmpDir);
        FileUtils.forceMkdir((File)configDir);
        FileUtils.forceMkdir((File)logDir);
        System.setProperty("sqoop.config.dir", this.getConfigurationPath());
        FileUtils.writeStringToFile((File)new File(this.getConfigurationPath() + "sqoop_bootstrap.properties"), (String)"sqoop.config.provider=org.apache.sqoop.core.PropertiesConfigurationProvider");
        File f = new File(this.getConfigurationPath() + "sqoop.properties");
        LinkedList<String> sqoopProperties = new LinkedList<String>();
        this.mapToProperties(sqoopProperties, this.getLoggerConfiguration());
        this.mapToProperties(sqoopProperties, this.getRepositoryConfiguration());
        this.mapToProperties(sqoopProperties, this.getSubmissionEngineConfiguration());
        this.mapToProperties(sqoopProperties, this.getExecutionEngineConfiguration());
        this.mapToProperties(sqoopProperties, this.getSecurityConfiguration());
        this.mapToProperties(sqoopProperties, this.getConnectorManagerConfiguration());
        this.mapToProperties(sqoopProperties, this.getDriverManagerConfiguration());
        this.mapToProperties(sqoopProperties, this.getClasspathConfiguration());
        this.mapToProperties(sqoopProperties, this.getBlacklistedConnectorConfiguration());
        FileUtils.writeLines((File)f, sqoopProperties);
        FileOutputStream stream = FileUtils.openOutputStream((File)new File(this.getConfigurationPath() + "hadoop-site.xml"));
        this.configuration.writeXml((OutputStream)stream);
        ((OutputStream)stream).close();
    }

    private void mapToProperties(List<String> output, Map<String, String> input) {
        for (Map.Entry<String, String> entry : input.entrySet()) {
            output.add(entry.getKey() + "=" + entry.getValue());
        }
    }

    protected Map<String, String> getLoggerConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.apache.sqoop.log4j.appender.file", "org.apache.log4j.ConsoleAppender");
        properties.put("org.apache.sqoop.log4j.appender.file.layout", "org.apache.log4j.PatternLayout");
        properties.put("org.apache.sqoop.log4j.appender.file.layout.ConversionPattern", "%d{ISO8601} %-5p [%l] %m%n");
        properties.put("org.apache.sqoop.log4j.debug", "true");
        properties.put("org.apache.sqoop.log4j.rootCategory", "DEBUG, file");
        return properties;
    }

    protected Map<String, String> getRepositoryConfiguration() throws Exception {
        return RepositoryProviderFactory.getRepositoryProperties();
    }

    protected Map<String, String> getSubmissionEngineConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.apache.sqoop.submission.engine", "org.apache.sqoop.submission.mapreduce.MapreduceSubmissionEngine");
        properties.put("org.apache.sqoop.submission.engine.mapreduce.configuration.directory", this.getConfigurationPath());
        properties.put("org.apache.sqoop.submission.engine.mapreduce.configuration.loglevel", "DEBUG");
        return properties;
    }

    protected Map<String, String> getExecutionEngineConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.apache.sqoop.execution.engine", "org.apache.sqoop.execution.mapreduce.MapreduceExecutionEngine");
        return properties;
    }

    protected Map<String, String> getSecurityConfiguration() {
        Map<String, String> properties = new HashMap<String, String>();
        if (this.kdc != null) {
            properties = this.kdc.prepareSqoopConfiguration(properties);
        } else {
            properties.put("org.apache.sqoop.security.authentication.type", "SIMPLE");
            properties.put("org.apache.sqoop.security.authentication.handler", "org.apache.sqoop.security.authentication.SimpleAuthenticationHandler");
        }
        String user = System.getProperty("user.name");
        properties.put("org.apache.sqoop.authentication.proxyuser." + user + ".groups", "*");
        properties.put("org.apache.sqoop.authentication.proxyuser." + user + ".hosts", "*");
        properties.put("org.apache.sqoop.authentication.proxyuser.hadoop.groups", "*");
        properties.put("org.apache.sqoop.authentication.proxyuser.hadoop.hosts", "*");
        properties.put("org.apache.sqoop.security.repo_encryption.enabled", String.valueOf(true));
        properties.put("org.apache.sqoop.security.repo_encryption.password_generator", "echo youwillnevergetthis");
        properties.put("org.apache.sqoop.security.repo_encryption.hmac_algorithm", "HmacSHA256");
        properties.put("org.apache.sqoop.security.repo_encryption.cipher_algorithm", "AES");
        properties.put("org.apache.sqoop.security.repo_encryption.cipher_key_size", "16");
        properties.put("org.apache.sqoop.security.repo_encryption.initialization_vector_size", "16");
        properties.put("org.apache.sqoop.security.repo_encryption.cipher_spec", "AES/CBC/PKCS5Padding");
        properties.put("org.apache.sqoop.security.repo_encryption.pbkdf2_algorithm", "PBKDF2WithHmacSHA1");
        properties.put("org.apache.sqoop.security.repo_encryption.pbkdf2_rounds", "4000");
        return properties;
    }

    protected Map<String, String> getConnectorManagerConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.apache.sqoop.connector.autoupgrade", "true");
        return properties;
    }

    protected Map<String, String> getDriverManagerConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.apache.sqoop.driver.autoupgrade", "true");
        return properties;
    }

    protected Map<String, String> getClasspathConfiguration() {
        return MapUtils.EMPTY_MAP;
    }

    protected Map<String, String> getBlacklistedConnectorConfiguration() {
        return MapUtils.EMPTY_MAP;
    }
}

