/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.minicluster;

import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.client.SqoopClient;
import org.apache.sqoop.test.minicluster.SqoopMiniCluster;

public class RealSqoopCluster
extends SqoopMiniCluster {
    private static final String SERVER_URL_KEY = "org.apache.sqoop.minicluster.real.server_url";
    private String serverUrl = System.getProperty("org.apache.sqoop.minicluster.real.server_url");
    private SqoopClient client = new SqoopClient(this.serverUrl);

    public RealSqoopCluster(String temporaryPath) throws Exception {
        super(temporaryPath);
        if (this.serverUrl == null) {
            throw new RuntimeException("Missing URL for real Sqoop 2 server: org.apache.sqoop.minicluster.real.server_url");
        }
    }

    public RealSqoopCluster(String temporaryPath, Configuration configuration) throws Exception {
        this(temporaryPath);
    }

    @Override
    public void start() throws Exception {
        this.client.deleteAllLinksAndJobs();
    }

    @Override
    public void stop() throws Exception {
        this.client.deleteAllLinksAndJobs();
    }

    @Override
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public String getConfigurationPath() {
        return System.getProperty("sqoop.hadoop.config.path", "/etc/hadoop/conf");
    }
}

