/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.minicluster;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.test.minicluster.JettySqoopMiniCluster;
import org.apache.sqoop.test.utils.ConnectorUtils;

public class JettySqoopMiniClusterWithExternalConnector
extends JettySqoopMiniCluster {
    private String extraClasspath;

    public JettySqoopMiniClusterWithExternalConnector(String temporaryPath, Configuration configuration) throws Exception {
        super(temporaryPath, configuration);
        this.prepareConnector();
    }

    private void prepareConnector() throws Exception {
        String[] connectorSourceFiles = new String[]{"TestConnectorForShell/TestConnectorForShell.java", "TestConnectorForShell/TestExtractorForShell.java", "TestConnectorForShell/TestFromDestroyerForShell.java", "TestConnectorForShell/TestFromInitializerForShell.java", "TestConnectorForShell/TestFromJobConfigForShell.java", "TestConnectorForShell/TestFromJobConfigurationForShell.java", "TestConnectorForShell/TestLinkConfigForShell.java", "TestConnectorForShell/TestLinkConfigurationForShell.java", "TestConnectorForShell/TestLoaderForShell.java", "TestConnectorForShell/TestPartitionerForShell.java", "TestConnectorForShell/TestPartitionForShell.java", "TestConnectorForShell/TestToDestroyerForShell.java", "TestConnectorForShell/TestToInitializerForShell.java", "TestConnectorForShell/TestToJobConfigForShell.java", "TestConnectorForShell/TestToJobConfigurationForShell.java"};
        String[] connectorPropertyFiles = new String[]{"TestConnectorForShell/sqoopconnector.properties", "TestConnectorForShell/test-connector-for-shell.properties"};
        String testConnectorJarName = "test-connector-for-shell.jar";
        Map<String, String> connectorJarMap = ConnectorUtils.compileTestConnectorAndDependency(connectorSourceFiles, new String[0], connectorPropertyFiles, testConnectorJarName, "", false);
        this.extraClasspath = connectorJarMap.get(testConnectorJarName);
    }

    @Override
    protected Map<String, String> getClasspathConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.extraClasspath != null) {
            properties.put("org.apache.sqoop.classpath.extra", this.extraClasspath);
        }
        return properties;
    }
}

