/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.minicluster;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.server.SqoopJettyServer;
import org.apache.sqoop.test.minicluster.SqoopMiniCluster;
import org.apache.sqoop.test.utils.SqoopUtils;

public class JettySqoopMiniCluster
extends SqoopMiniCluster {
    private SqoopJettyServer sqoopJettyServer;

    public JettySqoopMiniCluster(String temporaryPath, Configuration configuration) throws Exception {
        super(temporaryPath, configuration);
    }

    @Override
    public void start() throws Exception {
        this.prepareTemporaryPath();
        this.sqoopJettyServer = new SqoopJettyServer();
        this.sqoopJettyServer.startServer();
    }

    @Override
    public void stop() throws Exception {
        if (this.sqoopJettyServer != null) {
            this.sqoopJettyServer.stopServerForTest();
        }
    }

    @Override
    public String getServerUrl() {
        if (this.sqoopJettyServer != null) {
            String host;
            String serverUrl = this.sqoopJettyServer.getServerUrl();
            try {
                host = new URL(serverUrl).getHost();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Invalid sqoop server url: " + serverUrl);
            }
            String fqdn = SqoopUtils.getLocalHostName();
            return serverUrl.replaceFirst(host, fqdn);
        }
        throw new RuntimeException("Jetty server wasn't started.");
    }
}

