/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.kdc;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.sqoop.client.SqoopClient;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.test.kdc.KdcRunner;
import org.apache.sqoop.test.utils.HdfsUtils;
import org.apache.sqoop.test.utils.SecurityUtils;
import org.apache.sqoop.test.utils.SqoopUtils;

@SuppressWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
public class MiniKdcRunner
extends KdcRunner {
    private MiniKdc miniKdc;
    private String sqoopClientPrincipal;
    private String sqoopClientKeytabFile;
    private String spnegoPrincipal;
    private String spnegoKeytabFile;
    private String hadoopPrincipal;
    private String hadoopKeytabFile;

    @Override
    public Configuration prepareHadoopConfiguration(Configuration config) throws Exception {
        config.set("hadoop.security.authentication", "kerberos");
        config.set("dfs.namenode.kerberos.principal", this.hadoopPrincipal);
        config.set("dfs.namenode.keytab.file", this.hadoopKeytabFile);
        config.set("dfs.namenode.kerberos.internal.spnego.principal", this.spnegoPrincipal);
        config.set("dfs.web.authentication.kerberos.principal", this.spnegoPrincipal);
        config.set("dfs.web.authentication.kerberos.keytab", this.spnegoKeytabFile);
        config.set("dfs.encrypt.data.transfer", "true");
        config.set("dfs.datanode.kerberos.principal", this.hadoopPrincipal);
        config.set("dfs.datanode.keytab.file", this.hadoopKeytabFile);
        String sslKeystoresDir = this.getTemporaryPath() + "/ssl-keystore";
        String sslConfDir = SqoopUtils.getClasspathDir(MiniKdcRunner.class);
        FileUtils.deleteDirectory((File)new File(sslKeystoresDir));
        FileUtils.forceMkdir((File)new File(sslKeystoresDir));
        SecurityUtils.setupSSLConfig(sslKeystoresDir, sslConfDir, config, false, true);
        config.set("dfs.https.server.keystore.resource", SecurityUtils.getSSLConfigFileName("ssl-server"));
        config.set("dfs.block.access.token.enable", "true");
        config.set("dfs.http.policy", "HTTPS_ONLY");
        config.set("dfs.data.transfer.protection", "privacy");
        config.set("dfs.client.https.keystore.resource", SecurityUtils.getSSLConfigFileName("ssl-client"));
        config.set("yarn.resourcemanager.principal", this.hadoopPrincipal);
        config.set("yarn.resourcemanager.keytab", this.hadoopKeytabFile);
        config.set("yarn.resourcemanager.webapp.spnego-principal", this.spnegoPrincipal);
        config.set("yarn.resourcemanager.webapp.spnego-keytab-file", this.spnegoKeytabFile);
        config.set("yarn.nodemanager.principal", this.hadoopPrincipal);
        config.set("yarn.nodemanager.keytab", this.hadoopKeytabFile);
        config.set("mapreduce.jobhistory.principal", this.hadoopPrincipal);
        config.set("mapreduce.jobhistory.keytab", this.hadoopKeytabFile);
        config.set("yarn.app.mapreduce.am.command-opts", "-Xmx1024m -Djava.security.krb5.conf=\\\"" + this.miniKdc.getKrb5conf().getCanonicalPath() + "\\\"");
        config.set("mapred.child.java.opts", "-Xmx200m -Djava.security.krb5.conf=\\\"" + this.miniKdc.getKrb5conf().getCanonicalPath() + "\\\"");
        return config;
    }

    @Override
    public Map<String, String> prepareSqoopConfiguration(Map<String, String> properties) {
        properties.put("org.apache.sqoop.security.authentication.type", "KERBEROS");
        properties.put("org.apache.sqoop.security.authentication.kerberos.http.principal", this.spnegoPrincipal);
        properties.put("org.apache.sqoop.security.authentication.kerberos.http.keytab", this.spnegoKeytabFile);
        properties.put("org.apache.sqoop.security.authentication.handler", "org.apache.sqoop.security.authentication.KerberosAuthenticationHandler");
        properties.put("org.apache.sqoop.security.authentication.kerberos.principal", this.hadoopPrincipal);
        properties.put("org.apache.sqoop.security.authentication.kerberos.keytab", this.hadoopKeytabFile);
        return properties;
    }

    @Override
    public void start() throws Exception {
        Properties kdcConf = MiniKdc.createConf();
        File baseDir = new File(this.getTemporaryPath(), "minikdc");
        FileUtils.deleteDirectory((File)baseDir);
        FileUtils.forceMkdir((File)baseDir);
        this.miniKdc = new MiniKdc(kdcConf, baseDir);
        this.miniKdc.start();
        this.createPrincipals();
    }

    @Override
    public void stop() throws Exception {
        this.miniKdc.stop();
    }

    public MiniKdc getMiniKdc() {
        return this.miniKdc;
    }

    @Override
    public void authenticateWithSqoopServer(final SqoopClient client) throws Exception {
        this.doAsSqoopClient(new Callable<Collection<MConnector>>(){

            @Override
            public Collection<MConnector> call() {
                return client.getConnectors();
            }
        });
    }

    @Override
    public void authenticateWithSqoopServer(final URL url, final DelegationTokenAuthenticatedURL.Token authToken) throws Exception {
        this.doAsSqoopClient(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                new DelegationTokenAuthenticatedURL().openConnection(url, authToken);
                return null;
            }
        });
    }

    private void createPrincipals() throws Exception {
        this.createSpnegoPrincipal();
        this.createSqoopPrincipals();
        this.createHadoopPrincipals();
    }

    private void createSpnegoPrincipal() throws Exception {
        String keytabDir = HdfsUtils.joinPathFragments(this.getTemporaryPath(), "spnego");
        File keytabDirFile = new File(keytabDir);
        FileUtils.deleteDirectory((File)keytabDirFile);
        FileUtils.forceMkdir((File)keytabDirFile);
        File keytabFile = new File(keytabDirFile, "HTTP.keytab");
        String host = SqoopUtils.getLocalHostName();
        this.miniKdc.createPrincipal(keytabFile, new String[]{"HTTP/" + host});
        this.spnegoKeytabFile = keytabFile.getAbsolutePath();
        this.spnegoPrincipal = "HTTP/" + host + "@" + this.miniKdc.getRealm();
    }

    private void createSqoopPrincipals() throws Exception {
        String keytabDir = HdfsUtils.joinPathFragments(this.getTemporaryPath(), "sqoop");
        File keytabDirFile = new File(keytabDir);
        FileUtils.deleteDirectory((File)keytabDirFile);
        FileUtils.forceMkdir((File)keytabDirFile);
        String sqoopClientUserName = "sqoopclient";
        File userKeytabFile = new File(keytabDirFile, sqoopClientUserName + ".keytab");
        this.miniKdc.createPrincipal(userKeytabFile, new String[]{sqoopClientUserName});
        this.sqoopClientPrincipal = sqoopClientUserName + "@" + this.miniKdc.getRealm();
        this.sqoopClientKeytabFile = userKeytabFile.getAbsolutePath();
    }

    private void createHadoopPrincipals() throws Exception {
        String keytabDir = HdfsUtils.joinPathFragments(this.getTemporaryPath(), "hadoop");
        File keytabDirFile = new File(keytabDir);
        FileUtils.deleteDirectory((File)keytabDirFile);
        FileUtils.forceMkdir((File)keytabDirFile);
        String hadoopUserName = "hadoop";
        File keytabFile = new File(keytabDirFile, hadoopUserName + ".keytab");
        String host = SqoopUtils.getLocalHostName();
        this.miniKdc.createPrincipal(keytabFile, new String[]{hadoopUserName + "/" + host});
        this.hadoopKeytabFile = keytabFile.getAbsolutePath();
        this.hadoopPrincipal = hadoopUserName + "/" + host + "@" + this.miniKdc.getRealm();
    }

    private <T> T doAsSqoopClient(Callable<T> callable) throws Exception {
        return MiniKdcRunner.doAs(this.sqoopClientPrincipal, this.sqoopClientKeytabFile, callable);
    }

    private static <T> T doAs(String principal, String keytabFile, final Callable<T> callable) throws Exception {
        LoginContext loginContext = null;
        try {
            HashSet<Principal> principals = new HashSet<Principal>();
            Class<?> userClass = Class.forName("org.apache.hadoop.security.User");
            Constructor<?> constructor = userClass.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            principals.add((Principal)constructor.newInstance(principal));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            loginContext = new LoginContext("", subject, null, new KerberosConfiguration(principal, keytabFile));
            loginContext.login();
            subject = loginContext.getSubject();
            Object t = Subject.doAs(subject, new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return callable.call();
                }
            });
            return t;
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
        finally {
            if (loginContext != null) {
                loginContext.logout();
            }
        }
    }

    private static class KerberosConfiguration
    extends javax.security.auth.login.Configuration {
        private String principal;
        private String keytabFile;

        public KerberosConfiguration(String principal, String keytabFile) {
            this.principal = principal;
            this.keytabFile = keytabFile;
        }

        private String getKrb5LoginModuleName() {
            return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (System.getProperty("java.vendor").contains("IBM")) {
                options.put("useKeytab", this.keytabFile.startsWith("file://") ? this.keytabFile : "file://" + this.keytabFile);
                options.put("principal", this.principal);
                options.put("refreshKrb5Config", "true");
                options.put("credsType", "both");
            } else {
                options.put("keyTab", this.keytabFile);
                options.put("principal", this.principal);
                options.put("useKeyTab", "true");
                options.put("storeKey", "true");
                options.put("doNotPrompt", "true");
                options.put("useTicketCache", "true");
                options.put("renewTGT", "true");
                options.put("refreshKrb5Config", "true");
                options.put("isInitiator", "true");
            }
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                if (System.getProperty("java.vendor").contains("IBM")) {
                    System.setProperty("KRB5CCNAME", ticketCache);
                    options.put("useDefaultCcache", "true");
                    options.put("renewTGT", "true");
                } else {
                    options.put("ticketCache", ticketCache);
                }
            }
            options.put("debug", "true");
            return new AppConfigurationEntry[]{new AppConfigurationEntry(this.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

