/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.test.infrastructure.providers;

import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.sqoop.test.infrastructure.providers.InfrastructureProvider;
import org.apache.sqoop.test.kdc.KdcRunner;
import org.apache.sqoop.test.minicluster.JettySqoopMiniCluster;
import org.apache.sqoop.test.minicluster.SqoopMiniCluster;
import org.apache.sqoop.test.minicluster.SqoopMiniClusterFactory;

public class SqoopInfrastructureProvider
extends InfrastructureProvider {
    private static final Logger LOG = Logger.getLogger(SqoopInfrastructureProvider.class);
    protected SqoopMiniCluster instance;
    protected String rootPath;
    protected Configuration hadoopConf;
    protected KdcRunner kdc;

    @Override
    public void start() {
        try {
            this.instance = SqoopMiniClusterFactory.getSqoopMiniCluster(System.getProperties(), JettySqoopMiniCluster.class, this.rootPath, this.hadoopConf, this.kdc);
            this.instance.start();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not start Sqoop mini cluster.", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            this.instance.stop();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not stop Sqoop mini cluster.", (Throwable)e);
        }
    }

    @Override
    public void setHadoopConfiguration(Configuration conf) {
        this.hadoopConf = conf;
    }

    @Override
    public Configuration getHadoopConfiguration() {
        return this.hadoopConf;
    }

    @Override
    public void setRootPath(String path) {
        this.rootPath = path;
    }

    @Override
    public String getRootPath() {
        return this.rootPath;
    }

    @Override
    public void setKdc(KdcRunner kdc) {
        this.kdc = kdc;
    }

    public SqoopMiniCluster getInstance() {
        return this.instance;
    }
}

